/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereUtils;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequest;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponse;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.atmosphere.util.Utils;

public class AtmosphereWebSocketServletDestination
extends ServletDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(AtmosphereWebSocketServletDestination.class);
    private AtmosphereFramework framework = new AtmosphereFramework(false, true);

    public AtmosphereWebSocketServletDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, String path) throws IOException {
        super(bus, registry, ei, path);
        this.framework.setUseNativeImplementation(false);
        this.framework.addInitParameter("org.atmosphere.useNative", "true");
        this.framework.addInitParameter("org.atmosphere.cpr.sessionSupport", "true");
        this.framework.addInitParameter("org.atmosphere.useWebSocket", "true");
        this.framework.addInitParameter("org.atmosphere.websocket.WebSocketProtocol.executeAsync", "true");
        AtmosphereUtils.addInterceptors(this.framework, bus);
        this.framework.addAtmosphereHandler("/", (AtmosphereHandler)new DestinationHandler());
        this.framework.init();
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (Utils.webSocketEnabled((HttpServletRequest)req)) {
            try {
                this.framework.doCometSupport(AtmosphereRequest.wrap((HttpServletRequest)req), AtmosphereResponse.wrap((HttpServletResponse)resp));
            }
            catch (ServletException e) {
                throw new IOException(e);
            }
            return;
        }
        super.invoke(config, context, req, resp);
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        try {
            this.framework.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            super.shutdown();
        }
    }

    AtmosphereFramework getAtmosphereFramework() {
        return this.framework;
    }

    private class DestinationHandler
    extends AbstractReflectorAtmosphereHandler {
        private DestinationHandler() {
        }

        public void onRequest(AtmosphereResource resource) throws IOException {
            LOG.fine("onRequest");
            try {
                AtmosphereWebSocketServletDestination.this.invokeInternal(null, resource.getRequest().getServletContext(), (HttpServletRequest)resource.getRequest(), (HttpServletResponse)resource.getResponse());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to invoke service", e);
            }
        }
    }
}

