/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.HttpUpgradeListener;
import io.undertow.servlet.handlers.ServletRequestContext;
import io.undertow.servlet.spec.HttpServletRequestImpl;
import io.undertow.servlet.spec.HttpServletResponseImpl;
import io.undertow.servlet.spec.ServletContextImpl;
import io.undertow.util.Methods;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.protocol.Handshake;
import io.undertow.websockets.core.protocol.version07.Hybi07Handshake;
import io.undertow.websockets.core.protocol.version08.Hybi08Handshake;
import io.undertow.websockets.core.protocol.version13.Hybi13Handshake;
import io.undertow.websockets.spi.AsyncWebSocketHttpServerExchange;
import io.undertow.websockets.spi.WebSocketHttpExchange;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.http_undertow.UndertowHTTPDestination;
import org.apache.cxf.transport.http_undertow.UndertowHTTPHandler;
import org.apache.cxf.transport.http_undertow.UndertowHTTPServerEngineFactory;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.WebSocketUtils;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereUtils;
import org.apache.cxf.transport.websocket.undertow.WebSocketUndertowServletRequest;
import org.apache.cxf.transport.websocket.undertow.WebSocketUndertowServletResponse;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;
import org.xnio.ChannelListener;
import org.xnio.StreamConnection;

public class AtmosphereWebSocketUndertowDestination
extends UndertowHTTPDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(AtmosphereWebSocketUndertowDestination.class);
    private final Executor executor;
    private AtmosphereFramework framework = new AtmosphereFramework(false, true);

    public AtmosphereWebSocketUndertowDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, UndertowHTTPServerEngineFactory serverEngineFactory) throws IOException {
        super(bus, registry, ei, serverEngineFactory);
        this.framework.setUseNativeImplementation(false);
        this.framework.addInitParameter("org.atmosphere.useNative", "true");
        this.framework.addInitParameter("org.atmosphere.cpr.sessionSupport", "true");
        this.framework.addInitParameter("org.atmosphere.useWebSocket", "true");
        this.framework.addInitParameter("org.atmosphere.websocket.WebSocketProtocol.executeAsync", "true");
        this.framework.addInitParameter("org.atmosphere.websocket.suppressJSR356", "true");
        AtmosphereUtils.addInterceptors(this.framework, bus);
        this.framework.addAtmosphereHandler("/", (AtmosphereHandler)new DestinationHandler());
        this.framework.init();
        this.executor = ((WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getAutomaticWorkQueue();
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    private static String getNonWSAddress(EndpointInfo endpointInfo) {
        String address = endpointInfo.getAddress();
        if (address.startsWith("ws")) {
            address = "http" + address.substring(2);
        }
        return address;
    }

    protected String getAddress(EndpointInfo endpointInfo) {
        return AtmosphereWebSocketUndertowDestination.getNonWSAddress(endpointInfo);
    }

    protected String getBasePath(String contextPath) throws IOException {
        if (StringUtils.isEmpty((String)this.endpointInfo.getAddress())) {
            return "";
        }
        return new URL(this.getAddress(this.endpointInfo)).getPath();
    }

    protected UndertowHTTPHandler createUndertowHTTPHandler(UndertowHTTPDestination jhd, boolean cmExact) {
        return new AtmosphereUndertowWebSocketHandler(jhd, cmExact);
    }

    public void shutdown() {
        try {
            this.framework.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            super.shutdown();
        }
    }

    AtmosphereFramework getAtmosphereFramework() {
        return this.framework;
    }

    private class DestinationHandler
    extends AbstractReflectorAtmosphereHandler {
        private DestinationHandler() {
        }

        public void onRequest(AtmosphereResource resource) throws IOException {
            LOG.fine("onRequest");
            try {
                AtmosphereWebSocketUndertowDestination.this.invokeInternal(null, resource.getRequest().getServletContext(), (HttpServletRequest)resource.getRequest(), (HttpServletResponse)resource.getResponse());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to invoke service", e);
            }
        }
    }

    private class AtmosphereUndertowWebSocketHandler
    extends UndertowHTTPHandler {
        private final Set<Handshake> handshakes;
        private final Set<WebSocketChannel> peerConnections;

        AtmosphereUndertowWebSocketHandler(UndertowHTTPDestination jhd, boolean cmExact) {
            super(jhd, cmExact);
            this.peerConnections = Collections.newSetFromMap(new ConcurrentHashMap());
            this.handshakes = new HashSet<Handshake>();
            this.handshakes.add((Handshake)new Hybi13Handshake());
            this.handshakes.add((Handshake)new Hybi08Handshake());
            this.handshakes.add((Handshake)new Hybi07Handshake());
        }

        public void handleRequest(HttpServerExchange undertowExchange) throws Exception {
            if (undertowExchange.isInIoThread()) {
                undertowExchange.dispatch((HttpHandler)this);
                return;
            }
            if (!undertowExchange.getRequestMethod().equals(Methods.GET)) {
                this.handleNormalRequest(undertowExchange);
                return;
            }
            final AsyncWebSocketHttpServerExchange facade = new AsyncWebSocketHttpServerExchange(undertowExchange, this.peerConnections);
            Handshake handshaker = null;
            for (Handshake method : this.handshakes) {
                if (!method.matches((WebSocketHttpExchange)facade)) continue;
                handshaker = method;
                break;
            }
            if (handshaker == null) {
                this.handleNormalRequest(undertowExchange);
            } else {
                final Handshake selected = handshaker;
                undertowExchange.upgradeChannel(new HttpUpgradeListener(){

                    public void handleUpgrade(StreamConnection streamConnection, final HttpServerExchange exchange) {
                        try {
                            WebSocketChannel channel = selected.createChannel((WebSocketHttpExchange)facade, streamConnection, facade.getBufferPool());
                            AtmosphereUndertowWebSocketHandler.this.peerConnections.add(channel);
                            channel.getReceiveSetter().set((ChannelListener)new AbstractReceiveListener(){

                                protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) {
                                    AtmosphereUndertowWebSocketHandler.this.handleReceivedMessage(channel, message, exchange);
                                }

                                protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
                                    AtmosphereUndertowWebSocketHandler.this.handleReceivedMessage(channel, message, exchange);
                                }
                            });
                            channel.resumeReceives();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
                handshaker.handshake((WebSocketHttpExchange)facade);
            }
        }

        public void handleNormalRequest(HttpServerExchange undertowExchange) throws Exception {
            HttpServletResponseImpl response = new HttpServletResponseImpl(undertowExchange, (ServletContextImpl)this.servletContext);
            HttpServletRequestImpl request = new HttpServletRequestImpl(undertowExchange, (ServletContextImpl)this.servletContext);
            ServletRequestContext servletRequestContext = new ServletRequestContext(((ServletContextImpl)this.servletContext).getDeployment(), request, response, null);
            undertowExchange.putAttachment(ServletRequestContext.ATTACHMENT_KEY, (Object)servletRequestContext);
            try {
                AtmosphereWebSocketUndertowDestination.this.framework.doCometSupport(AtmosphereRequestImpl.wrap((HttpServletRequest)request), AtmosphereResponseImpl.wrap((HttpServletResponse)response));
            }
            catch (ServletException e) {
                throw new IOException(e);
            }
        }

        public void handleNormalRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
            try {
                AtmosphereWebSocketUndertowDestination.this.framework.doCometSupport(AtmosphereRequestImpl.wrap((HttpServletRequest)request), AtmosphereResponseImpl.wrap((HttpServletResponse)response));
            }
            catch (ServletException e) {
                throw new IOException(e);
            }
        }

        private void handleReceivedMessage(final WebSocketChannel channel, final Object message, final HttpServerExchange exchange) {
            AtmosphereWebSocketUndertowDestination.this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        WebSocketUndertowServletRequest request = new WebSocketUndertowServletRequest(channel, message, exchange);
                        WebSocketUndertowServletResponse response = new WebSocketUndertowServletResponse(channel);
                        if (request.getHeader("requestId") != null) {
                            String headerValue = request.getHeader("requestId");
                            if (WebSocketUtils.isContainingCRLF(headerValue)) {
                                LOG.warning("Invalid characters (CR/LF) in header requestId");
                            } else {
                                response.setHeader("responseId", headerValue);
                            }
                        }
                        AtmosphereUndertowWebSocketHandler.this.handleNormalRequest(request, response);
                    }
                    catch (Exception ex) {
                        LOG.log(Level.WARNING, "Failed to invoke service", ex);
                    }
                }
            });
        }
    }
}

