/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.transport.websocket.atmosphere;

import java.io.IOException;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.cxf.Bus;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.http.DestinationRegistry;
import org.apache.cxf.transport.servlet.ServletDestination;
import org.apache.cxf.transport.websocket.WebSocketDestinationService;
import org.apache.cxf.transport.websocket.atmosphere.AtmosphereUtils;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.AtmosphereHandler;
import org.atmosphere.cpr.AtmosphereRequestImpl;
import org.atmosphere.cpr.AtmosphereResource;
import org.atmosphere.cpr.AtmosphereResponseImpl;
import org.atmosphere.handler.AbstractReflectorAtmosphereHandler;

public class AtmosphereWebSocketServletDestination
extends ServletDestination
implements WebSocketDestinationService {
    private static final Logger LOG = LogUtils.getL7dLogger(AtmosphereWebSocketServletDestination.class);
    private AtmosphereFramework framework;

    public AtmosphereWebSocketServletDestination(Bus bus, DestinationRegistry registry, EndpointInfo ei, String path) throws IOException {
        super(bus, registry, ei, path);
        this.framework = this.create(bus);
    }

    private AtmosphereFramework create(Bus bus) {
        AtmosphereFramework instance = new AtmosphereFramework(false, true);
        instance.setUseNativeImplementation(false);
        instance.addInitParameter("org.atmosphere.useNative", "true");
        instance.addInitParameter("org.atmosphere.cpr.sessionSupport", "true");
        instance.addInitParameter("org.atmosphere.useWebSocket", "true");
        instance.addInitParameter("org.atmosphere.websocket.WebSocketProtocol.executeAsync", "true");
        instance.addInitParameter("org.atmosphere.websocket.suppressJSR356", "true");
        AtmosphereUtils.addInterceptors(instance, bus);
        instance.addAtmosphereHandler("/", (AtmosphereHandler)new DestinationHandler());
        return instance;
    }

    public void finalizeConfig() {
        final ServletContext ctx = (ServletContext)this.bus.getExtension(ServletContext.class);
        if (ctx != null) {
            try {
                this.framework.init(new ServletConfig(){

                    public String getServletName() {
                        return null;
                    }

                    public ServletContext getServletContext() {
                        return ctx;
                    }

                    public String getInitParameter(String name) {
                        return null;
                    }

                    public Enumeration<String> getInitParameterNames() {
                        return null;
                    }
                });
            }
            catch (ServletException e) {
                e.printStackTrace();
            }
        } else {
            this.framework.init();
        }
    }

    public void onServletConfigAvailable(ServletConfig config) throws ServletException {
        Object container = config.getServletContext().getAttribute("javax.websocket.server.ServerContainer");
        if (container != null) {
            if (this.framework.initialized()) {
                this.framework.destroy();
            }
            this.framework = this.create(this.getBus());
            this.framework.addInitParameter("org.atmosphere.useNative", "false");
            this.framework.addInitParameter("org.atmosphere.websocket.suppressJSR356", "false");
            this.framework.init(config);
        }
    }

    public void invoke(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (AtmosphereUtils.useAtmosphere(req)) {
            try {
                this.framework.doCometSupport(AtmosphereRequestImpl.wrap((HttpServletRequest)req), AtmosphereResponseImpl.wrap((HttpServletResponse)resp));
            }
            catch (ServletException e) {
                throw new IOException(e);
            }
            return;
        }
        super.invoke(config, context, req, resp);
    }

    @Override
    public void invokeInternal(ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.invoke(config, context, req, resp);
    }

    protected void setupMessage(Message inMessage, ServletConfig config, ServletContext context, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        super.setupMessage(inMessage, config, context, req, resp);
        Object address = req.getAttribute("org.apache.cxf.transport.endpoint.address");
        if (address == null) {
            String basePath = (String)inMessage.get((Object)Message.BASE_PATH);
            req.setAttribute("org.apache.cxf.transport.endpoint.address", (Object)basePath);
        }
    }

    public void shutdown() {
        try {
            this.framework.destroy();
        }
        catch (Exception exception) {
        }
        finally {
            super.shutdown();
        }
    }

    AtmosphereFramework getAtmosphereFramework() {
        return this.framework;
    }

    private class DestinationHandler
    extends AbstractReflectorAtmosphereHandler {
        private DestinationHandler() {
        }

        public void onRequest(AtmosphereResource resource) throws IOException {
            LOG.fine("onRequest");
            try {
                AtmosphereWebSocketServletDestination.this.invokeInternal(null, resource.getRequest().getServletContext(), (HttpServletRequest)resource.getRequest(), (HttpServletResponse)resource.getResponse());
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to invoke service", e);
            }
        }
    }
}

