/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing;

import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.ConduitSelector;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.NullConduitSelector;
import org.apache.cxf.endpoint.PreexistingConduitSelector;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.OutgoingChainInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.Extensible;
import org.apache.cxf.service.model.FaultInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.workqueue.AutomaticWorkQueue;
import org.apache.cxf.workqueue.OneShotAsyncExecutor;
import org.apache.cxf.workqueue.SynchronousExecutor;
import org.apache.cxf.workqueue.WorkQueueManager;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.JAXWSAConstants;
import org.apache.cxf.ws.addressing.Names;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextUtils {
    public static final ObjectFactory WSA_OBJECT_FACTORY = new ObjectFactory();
    private static final EndpointReferenceType NONE_ENDPOINT_REFERENCE = EndpointReferenceUtils.getEndpointReference((String)"http://www.w3.org/2005/08/addressing/none");
    private static final Logger LOG = LogUtils.getL7dLogger(ContextUtils.class);
    private static final String ACTION = ContextUtils.class.getName() + ".ACTION";
    private static final String URN_UUID = "urn:uuid:";
    private static JAXBContext jaxbContext;
    private static final String MAP_FAULT_NAME_PROPERTY = "org.apache.cxf.ws.addressing.map.fault.name";
    private static final String MAP_FAULT_REASON_PROPERTY = "org.apache.cxf.ws.addressing.map.fault.reason";
    private static final String PARTIAL_REPONSE_SENT_PROPERTY = "org.apache.cxf.ws.addressing.partial.response.sent";

    private ContextUtils() {
    }

    public static boolean isOutbound(Message message) {
        Exchange exchange = message.getExchange();
        return message != null && exchange != null && (message == exchange.getOutMessage() || message == exchange.getOutFaultMessage());
    }

    public static boolean isFault(Message message) {
        return message != null && message.getExchange() != null && (message == message.getExchange().getInFaultMessage() || message == message.getExchange().getOutFaultMessage());
    }

    public static boolean isRequestor(Message message) {
        Boolean requestor = (Boolean)message.get((Object)"org.apache.cxf.client");
        return requestor != null && requestor != false;
    }

    public static String getMAPProperty(boolean isRequestor, boolean isProviderContext, boolean isOutbound) {
        return isRequestor ? (isProviderContext ? "javax.xml.ws.addressing.context" : (isOutbound ? "javax.xml.ws.addressing.context.outbound" : "javax.xml.ws.addressing.context.inbound")) : (isOutbound ? "javax.xml.ws.addressing.context.outbound" : "javax.xml.ws.addressing.context.inbound");
    }

    public static void storeMAPs(AddressingProperties maps, Message message, boolean isOutbound) {
        ContextUtils.storeMAPs(maps, message, isOutbound, ContextUtils.isRequestor(message), false);
    }

    public static void storeMAPs(AddressingProperties maps, Message message, boolean isOutbound, boolean isRequestor) {
        ContextUtils.storeMAPs(maps, message, isOutbound, isRequestor, false);
    }

    public static void storeMAPs(AddressingProperties maps, Message message, boolean isOutbound, boolean isRequestor, boolean isProviderContext) {
        if (maps != null) {
            String mapProperty = ContextUtils.getMAPProperty(isRequestor, isProviderContext, isOutbound);
            LOG.log(Level.INFO, "associating MAPs with context property {0}", mapProperty);
            message.put((Object)mapProperty, (Object)maps);
        }
    }

    public static AddressingPropertiesImpl retrieveMAPs(Message message, boolean isProviderContext, boolean isOutbound) {
        return ContextUtils.retrieveMAPs(message, isProviderContext, isOutbound, true);
    }

    public static AddressingPropertiesImpl retrieveMAPs(Message message, boolean isProviderContext, boolean isOutbound, boolean warnIfMissing) {
        boolean isRequestor = ContextUtils.isRequestor(message);
        String mapProperty = ContextUtils.getMAPProperty(isProviderContext, isRequestor, isOutbound);
        LOG.log(Level.INFO, "retrieving MAPs from context property {0}", mapProperty);
        AddressingPropertiesImpl maps = (AddressingPropertiesImpl)message.get((Object)mapProperty);
        if (maps != null) {
            LOG.log(Level.INFO, "current MAPs {0}", maps);
        } else if (!isProviderContext) {
            LogUtils.log((Logger)LOG, (Level)(warnIfMissing ? Level.WARNING : Level.INFO), (String)"MAPS_RETRIEVAL_FAILURE_MSG");
        }
        return maps;
    }

    public static AttributedURIType getAttributedURI(String uri) {
        AttributedURIType attributedURI = WSA_OBJECT_FACTORY.createAttributedURIType();
        attributedURI.setValue(uri);
        return attributedURI;
    }

    public static RelatesToType getRelatesTo(String uri) {
        RelatesToType relatesTo = WSA_OBJECT_FACTORY.createRelatesToType();
        relatesTo.setValue(uri);
        return relatesTo;
    }

    public static boolean isGenericAddress(EndpointReferenceType ref) {
        return ref == null || ref.getAddress() == null || "http://www.w3.org/2005/08/addressing/anonymous".equals(ref.getAddress().getValue()) || "http://www.w3.org/2005/08/addressing/none".equals(ref.getAddress().getValue());
    }

    public static boolean hasEmptyAction(AddressingProperties maps) {
        boolean empty;
        boolean bl = empty = maps.getAction() == null;
        if (maps.getAction() != null && maps.getAction().getValue().length() == 0) {
            maps.setAction(null);
            empty = false;
        }
        return empty;
    }

    public static void rebaseResponse(EndpointReferenceType reference, AddressingProperties inMAPs, final Message inMessage) {
        String namespaceURI = inMAPs.getNamespaceURI();
        if (!ContextUtils.retrievePartialResponseSent(inMessage)) {
            ContextUtils.storePartialResponseSent(inMessage);
            Exchange exchange = inMessage.getExchange();
            Message fullResponse = exchange.getOutMessage();
            Message partialResponse = ContextUtils.createMessage(exchange);
            ContextUtils.ensurePartialResponseMAPs(partialResponse, namespaceURI);
            ContextUtils.propogateReceivedMAPs(inMAPs, partialResponse);
            partialResponse.put((Object)"org.apache.cxf.partial.response", (Object)Boolean.TRUE);
            Destination target = inMessage.getDestination();
            if (target == null) {
                return;
            }
            try {
                exchange.setOutMessage(partialResponse);
                Conduit backChannel = target.getBackChannel(inMessage, partialResponse, reference);
                if (backChannel != null) {
                    InterceptorChain chain = fullResponse != null ? fullResponse.getInterceptorChain() : OutgoingChainInterceptor.getOutInterceptorChain((Exchange)exchange);
                    partialResponse.setInterceptorChain(chain);
                    exchange.put(ConduitSelector.class, (Object)new PreexistingConduitSelector(backChannel, (Endpoint)exchange.get(Endpoint.class)));
                    if (chain != null && !chain.doIntercept(partialResponse) && partialResponse.getContent(Exception.class) != null) {
                        if (partialResponse.getContent(Exception.class) instanceof Fault) {
                            throw (Fault)partialResponse.getContent(Exception.class);
                        }
                        throw new Fault((Throwable)partialResponse.getContent(Exception.class));
                    }
                    if (chain != null) {
                        chain.reset();
                    }
                    exchange.put(ConduitSelector.class, (Object)new NullConduitSelector());
                    if (fullResponse != null) {
                        exchange.setOutMessage(fullResponse);
                    } else {
                        fullResponse = ContextUtils.createMessage(exchange);
                        exchange.setOutMessage(fullResponse);
                    }
                    if (ContextUtils.retrieveAsyncPostResponseDispatch(inMessage)) {
                        inMessage.getInterceptorChain().pause();
                        ContextUtils.getExecutor(inMessage).execute(new Runnable(){

                            public void run() {
                                inMessage.getInterceptorChain().resume();
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "SERVER_TRANSPORT_REBASE_FAILURE_MSG", e);
            }
        }
    }

    public static void propogateReceivedMAPs(AddressingProperties inMAPs, Exchange exchange) {
        if (exchange.getOutMessage() == null) {
            exchange.setOutMessage(ContextUtils.createMessage(exchange));
        }
        ContextUtils.propogateReceivedMAPs(inMAPs, exchange.getOutMessage());
        if (exchange.getOutFaultMessage() == null) {
            exchange.setOutFaultMessage(ContextUtils.createMessage(exchange));
        }
        ContextUtils.propogateReceivedMAPs(inMAPs, exchange.getOutFaultMessage());
    }

    private static void propogateReceivedMAPs(AddressingProperties inMAPs, Message responseMessage) {
        if (responseMessage != null) {
            ContextUtils.storeMAPs(inMAPs, responseMessage, false, false, false);
        }
    }

    private static void ensurePartialResponseMAPs(Message partialResponse, String namespaceURI) {
        AddressingPropertiesImpl maps = new AddressingPropertiesImpl();
        maps.setTo(EndpointReferenceUtils.getAnonymousEndpointReference());
        maps.setReplyTo(WSA_OBJECT_FACTORY.createEndpointReferenceType());
        maps.getReplyTo().setAddress(ContextUtils.getAttributedURI("http://www.w3.org/2005/08/addressing/none"));
        maps.setAction(ContextUtils.getAttributedURI(""));
        maps.exposeAs(namespaceURI);
        ContextUtils.storeMAPs(maps, partialResponse, true, true, false);
    }

    private static Executor getExecutor(Message message) {
        Endpoint endpoint = (Endpoint)message.getExchange().get(Endpoint.class);
        Executor executor = endpoint.getService().getExecutor();
        if (executor == null || SynchronousExecutor.isA((Executor)executor)) {
            WorkQueueManager workQueueManager;
            AutomaticWorkQueue autoWorkQueue;
            Bus bus = (Bus)message.getExchange().get(Bus.class);
            executor = bus != null ? ((autoWorkQueue = (workQueueManager = (WorkQueueManager)bus.getExtension(WorkQueueManager.class)).getNamedWorkQueue("ws-addressing")) != null ? autoWorkQueue : workQueueManager.getAutomaticWorkQueue()) : OneShotAsyncExecutor.getInstance();
        }
        message.getExchange().put(Executor.class, (Object)executor);
        return executor;
    }

    public static void storeMAPFaultName(String faultName, Message message) {
        message.put((Object)MAP_FAULT_NAME_PROPERTY, (Object)faultName);
    }

    public static String retrieveMAPFaultName(Message message) {
        return (String)message.get((Object)MAP_FAULT_NAME_PROPERTY);
    }

    public static void storeMAPFaultReason(String reason, Message message) {
        message.put((Object)MAP_FAULT_REASON_PROPERTY, (Object)reason);
    }

    public static String retrieveMAPFaultReason(Message message) {
        return (String)message.get((Object)MAP_FAULT_REASON_PROPERTY);
    }

    public static void storePartialResponseSent(Message message) {
        message.put((Object)PARTIAL_REPONSE_SENT_PROPERTY, (Object)Boolean.TRUE);
    }

    public static boolean retrievePartialResponseSent(Message message) {
        Boolean ret = (Boolean)message.get((Object)PARTIAL_REPONSE_SENT_PROPERTY);
        return ret != null && ret != false;
    }

    public static void storeDeferUncorrelatedMessageAbort(Message message) {
        if (message.getExchange() != null) {
            message.getExchange().put((Object)"defer.uncorrelated.message.abort", (Object)Boolean.TRUE);
        }
    }

    public static boolean retrieveDeferUncorrelatedMessageAbort(Message message) {
        Boolean ret = message.getExchange() != null ? (Boolean)message.getExchange().get((Object)"defer.uncorrelated.message.abort") : null;
        return ret != null && ret != false;
    }

    public static void storeDeferredUncorrelatedMessageAbort(Message message) {
        if (message.getExchange() != null) {
            message.getExchange().put((Object)"deferred.uncorrelated.message.abort", (Object)Boolean.TRUE);
        }
    }

    public static boolean retrieveDeferredUncorrelatedMessageAbort(Message message) {
        Boolean ret = message.getExchange() != null ? (Boolean)message.getExchange().get((Object)"deferred.uncorrelated.message.abort") : null;
        return ret != null && ret != false;
    }

    public static boolean retrieveAsyncPostResponseDispatch(Message message) {
        Boolean ret = (Boolean)message.get((Object)"org.apache.cxf.async.post.response.dispatch");
        return ret != null && ret != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JAXBContext getJAXBContext() throws JAXBException {
        Class<ContextUtils> clazz = ContextUtils.class;
        synchronized (ContextUtils.class) {
            if (jaxbContext == null) {
                jaxbContext = JAXBContext.newInstance((String)WSA_OBJECT_FACTORY.getClass().getPackage().getName(), (ClassLoader)WSA_OBJECT_FACTORY.getClass().getClassLoader());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return jaxbContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setJAXBContext(JAXBContext ctx) throws JAXBException {
        Class<ContextUtils> clazz = ContextUtils.class;
        synchronized (ContextUtils.class) {
            jaxbContext = ctx;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static String generateUUID() {
        return URN_UUID + UUID.randomUUID();
    }

    public static Conduit getConduit(Conduit conduit, Message message) {
        if (conduit == null) {
            Exchange exchange = message.getExchange();
            conduit = exchange != null ? exchange.getConduit(message) : null;
        }
        return conduit;
    }

    public static AttributedURIType getAction(Message message) {
        String action = null;
        LOG.fine("Determining action");
        Exception fault = (Exception)message.getContent(Exception.class);
        action = ContextUtils.getActionFromServiceModel(message, fault);
        LOG.fine("action: " + action);
        return action != null ? ContextUtils.getAttributedURI(action) : null;
    }

    private static String getActionFromServiceModel(Message message, Exception fault) {
        String action;
        block4: {
            BindingOperationInfo bindingOpInfo;
            block5: {
                action = null;
                bindingOpInfo = (BindingOperationInfo)message.getExchange().get(BindingOperationInfo.class);
                if (bindingOpInfo == null) break block4;
                if (bindingOpInfo.isUnwrappedCapable()) {
                    bindingOpInfo = bindingOpInfo.getUnwrappedOperation();
                }
                if (fault != null) break block5;
                SoapOperationInfo soi = (SoapOperationInfo)bindingOpInfo.getExtensor(SoapOperationInfo.class);
                if (null != soi) {
                    action = soi.getAction();
                }
                if (action != null && !"".equals(action)) break block4;
                MessageInfo msgInfo = ContextUtils.isRequestor(message) ? bindingOpInfo.getOperationInfo().getInput() : bindingOpInfo.getOperationInfo().getOutput();
                String cachedAction = (String)msgInfo.getProperty(ACTION);
                action = cachedAction == null ? ContextUtils.getActionFromMessageAttributes(msgInfo) : cachedAction;
                break block4;
            }
            Throwable t = fault.getCause();
            for (BindingFaultInfo bfi : bindingOpInfo.getFaults()) {
                FaultInfo fi = bfi.getFaultInfo();
                if (t == null || !t.getClass().isAssignableFrom(fi.getMessagePart(0).getTypeClass()) || fi.getExtensionAttributes() == null) continue;
                String attr = (String)fi.getExtensionAttributes().get(Names.WSAW_ACTION_QNAME);
                if (attr == null) {
                    attr = (String)fi.getExtensionAttributes().get(new QName("http://www.w3.org/2005/02/addressing/wsdl", "Action"));
                }
                if (attr == null) continue;
                action = attr;
                break;
            }
        }
        LOG.fine("action determined from service model: " + action);
        return action;
    }

    private static String getActionFromMessageAttributes(MessageInfo msgInfo) {
        String attr;
        String action = null;
        if (msgInfo != null && msgInfo.getExtensionAttributes() != null && (attr = ContextUtils.getAction((Extensible)msgInfo)) != null) {
            action = attr;
            msgInfo.setProperty(ACTION, (Object)action);
        }
        return action;
    }

    public static String getAction(Extensible ext) {
        Object o = ext.getExtensionAttribute(JAXWSAConstants.WSAW_ACTION_QNAME);
        if (o == null) {
            o = ext.getExtensionAttributes().get(new QName("http://www.w3.org/2005/02/addressing/wsdl", "Action"));
        }
        if (o instanceof QName) {
            return ((QName)o).getLocalPart();
        }
        return o.toString();
    }

    public static EndpointReferenceType getNoneEndpointReference() {
        return NONE_ENDPOINT_REFERENCE;
    }

    public static void applyReferenceParam(EndpointReferenceType toEpr, JAXBElement<String> el) {
        if (null == toEpr.getReferenceParameters()) {
            toEpr.setReferenceParameters(WSA_OBJECT_FACTORY.createReferenceParametersType());
        }
        toEpr.getReferenceParameters().getAny().add(el);
    }

    private static Message createMessage(Exchange exchange) {
        Endpoint ep = (Endpoint)exchange.get(Endpoint.class);
        MessageImpl msg = null;
        if (ep != null) {
            msg = new MessageImpl();
            msg.setExchange(exchange);
            if (ep.getBinding() != null) {
                msg = ep.getBinding().createMessage((Message)msg);
            }
        }
        return msg;
    }
}

