/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.backend.notification;

import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.ws.eventing.LanguageSpecificStringType;
import org.apache.cxf.ws.eventing.SubscriptionEnd;
import org.apache.cxf.ws.eventing.backend.database.SubscriptionTicket;
import org.apache.cxf.ws.eventing.backend.notification.SubscriptionEndStatus;
import org.apache.cxf.ws.eventing.client.EndToEndpoint;
import org.apache.cxf.ws.eventing.shared.handlers.ReferenceParametersAddingHandler;

public class SubscriptionEndNotificationTask
implements Runnable {
    private SubscriptionTicket target;
    private String reason;
    private SubscriptionEndStatus status;

    public SubscriptionEndNotificationTask(SubscriptionTicket ticket, String reason, SubscriptionEndStatus status) {
        this.target = ticket;
        this.reason = reason;
        this.status = status;
    }

    @Override
    public void run() {
        try {
            ReferenceParametersAddingHandler handler = new ReferenceParametersAddingHandler(this.target.getNotificationReferenceParams());
            JaxWsProxyFactoryBean service = new JaxWsProxyFactoryBean();
            service.getOutInterceptors().add(new LoggingOutInterceptor());
            service.setServiceClass(EndToEndpoint.class);
            service.setAddress(this.target.getEndToURL());
            service.getHandlers().add(handler);
            EndToEndpoint endpoint = (EndToEndpoint)service.create();
            SubscriptionEnd message = new SubscriptionEnd();
            message.setStatus(this.status.toString());
            if (this.reason != null) {
                LanguageSpecificStringType reasonElement = new LanguageSpecificStringType();
                reasonElement.setLang("en-US");
                reasonElement.setValue(this.reason);
                message.getReason().add(reasonElement);
            }
            endpoint.subscriptionEnd(message);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

