/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.eventing.shared.utils;

import java.util.Iterator;
import java.util.logging.Logger;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.ws.eventing.FilterType;
import org.w3c.dom.Element;

public final class FilteringUtil {
    public static final String NAMESPACE_XPATH10 = "http://www.w3.org/2011/03/ws-evt/Dialects/XPath10";
    public static final String NAMESPACE_XPATH20 = "http://www.w3.org/2011/03/ws-evt/Dialects/XPath20";
    private static final Logger LOG = LogUtils.getLogger(FilteringUtil.class);
    private static XPathFactory xPathFactory = XPathFactory.newInstance();

    private FilteringUtil() {
    }

    public static boolean isFilteringDialectSupported(String namespace) {
        return namespace.equals(NAMESPACE_XPATH10);
    }

    public static boolean doesConformToFilter(Element elm, FilterType filter) {
        if (filter == null || filter.getContent() == null) {
            return true;
        }
        String xPathString = (String)filter.getContent().get(0);
        try {
            XPath xPath = xPathFactory.newXPath();
            XPathExpression xPathExpression = xPath.compile(xPathString);
            return (Boolean)xPathExpression.evaluate(elm, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException ex) {
            LOG.severe(ex.toString());
            return false;
        }
    }

    public static boolean isValidFilter(String xPathString) {
        if (xPathString == null) {
            return true;
        }
        try {
            XPath xPath = xPathFactory.newXPath();
            xPath.compile(xPathString);
            return true;
        }
        catch (XPathExpressionException ex) {
            return false;
        }
    }

    public static boolean runFilterOnMessage(SOAPMessage msg, FilterType filter) {
        try {
            Iterator i = msg.getSOAPBody().getChildElements();
            String xPath = (String)filter.getContent().get(0);
            while (i.hasNext()) {
                Element elm = (Element)i.next();
                if (FilteringUtil.doesConformToFilter(elm, filter)) {
                    LOG.info("Message passed through filter: " + xPath);
                    continue;
                }
                LOG.info("Filter " + xPath + " filtered out this message.");
                return false;
            }
            return true;
        }
        catch (SOAPException e) {
            LOG.severe("SOAPException in runFilterOnMessage: " + e.toString());
            return false;
        }
    }
}

