/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.service.model.BindingFaultInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.Destination;
import org.apache.cxf.ws.policy.Assertor;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.EndpointPolicy;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.PolicyEngineImpl;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.PolicyInterceptorProvider;
import org.apache.cxf.ws.policy.PolicyInterceptorProviderRegistry;
import org.apache.cxf.ws.policy.PolicyUtils;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EndpointPolicyImpl
implements EndpointPolicy {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(EndpointPolicyImpl.class);
    private Policy policy;
    private Collection<PolicyAssertion> chosenAlternative;
    private Collection<PolicyAssertion> vocabulary;
    private Collection<PolicyAssertion> faultVocabulary;
    private List<Interceptor> interceptors;
    private List<Interceptor> faultInterceptors;
    private EndpointInfo ei;
    private PolicyEngineImpl engine;
    private boolean requestor;
    private Assertor assertor;

    public EndpointPolicyImpl() {
    }

    public EndpointPolicyImpl(Policy p) {
        this.policy = p;
    }

    public EndpointPolicyImpl(EndpointInfo ei, PolicyEngineImpl engine, boolean requestor, Assertor assertor) {
        this.ei = ei;
        this.engine = engine;
        this.requestor = requestor;
        this.assertor = assertor;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public Assertor getAssertor() {
        return this.assertor;
    }

    public EndpointPolicy updatePolicy(Policy p) {
        EndpointPolicyImpl epi = this.createEndpointPolicy();
        if (!PolicyUtils.isEmptyPolicy(p)) {
            Policy normalizedPolicy = (Policy)p.normalize(this.engine == null ? null : this.engine.getRegistry(), true);
            epi.setPolicy(this.getPolicy().merge(normalizedPolicy));
        } else {
            Policy clonedPolicy = new Policy();
            clonedPolicy.addPolicyComponents(this.getPolicy().getPolicyComponents());
            epi.setPolicy(clonedPolicy);
        }
        epi.checkExactlyOnes();
        epi.finalizeConfig();
        return epi;
    }

    public Collection<PolicyAssertion> getChosenAlternative() {
        return this.chosenAlternative;
    }

    public synchronized Collection<PolicyAssertion> getVocabulary() {
        if (this.vocabulary == null) {
            this.initializeVocabulary();
        }
        return this.vocabulary;
    }

    public synchronized Collection<PolicyAssertion> getFaultVocabulary() {
        if (this.vocabulary == null) {
            this.initializeVocabulary();
        }
        return this.faultVocabulary;
    }

    public synchronized List<Interceptor> getInterceptors() {
        if (this.interceptors == null) {
            this.initializeInterceptors();
        }
        return this.interceptors;
    }

    public synchronized List<Interceptor> getFaultInterceptors() {
        if (this.interceptors == null) {
            this.initializeInterceptors();
        }
        return this.faultInterceptors;
    }

    void initialize() {
        this.initializePolicy();
        this.checkExactlyOnes();
        this.finalizeConfig();
    }

    void finalizeConfig() {
        this.chooseAlternative();
    }

    void initializePolicy() {
        this.policy = this.engine.getAggregatedServicePolicy(this.ei.getService());
        this.policy = this.policy.merge(this.engine.getAggregatedEndpointPolicy(this.ei));
        if (!this.policy.isEmpty()) {
            this.policy = (Policy)this.policy.normalize(this.engine == null ? null : this.engine.getRegistry(), true);
        }
    }

    void chooseAlternative() {
        Collection alternative = null;
        alternative = this.requestor ? this.engine.getAlternativeSelector().selectAlternative(this.policy, (PolicyEngine)this.engine, this.assertor) : this.getSupportedAlternatives();
        if (null == alternative) {
            throw new PolicyException(new Message("NO_ALTERNATIVE_EXC", BUNDLE, new Object[0]));
        }
        this.setChosenAlternative(alternative);
    }

    protected Collection<PolicyAssertion> getSupportedAlternatives() {
        ArrayList<PolicyAssertion> alternatives = new ArrayList<PolicyAssertion>();
        Iterator it = this.policy.getAlternatives();
        while (it.hasNext()) {
            List alternative = CastUtils.cast((List)((List)it.next()), PolicyAssertion.class);
            if (!this.engine.supportsAlternative(alternative, this.assertor)) continue;
            alternatives.addAll(alternative);
        }
        return alternatives;
    }

    void initializeVocabulary() {
        this.vocabulary = new ArrayList<PolicyAssertion>();
        if (this.requestor) {
            this.faultVocabulary = new ArrayList<PolicyAssertion>();
        }
        if (this.getChosenAlternative() != null) {
            for (PolicyAssertion a : this.getChosenAlternative()) {
                if (a.isOptional()) continue;
                this.vocabulary.add(a);
                if (null == this.faultVocabulary) continue;
                this.faultVocabulary.add(a);
            }
        }
        for (BindingOperationInfo boi : this.ei.getBinding().getOperations()) {
            EffectivePolicy p = null;
            p = this.requestor ? this.engine.getEffectiveClientRequestPolicy(this.ei, boi, (Conduit)this.assertor) : this.engine.getEffectiveServerRequestPolicy(this.ei, boi);
            Collection<PolicyAssertion> c = this.engine.getAssertions(p, false);
            if (c != null) {
                this.vocabulary.addAll(c);
                if (null != this.faultVocabulary) {
                    this.faultVocabulary.addAll(c);
                }
            }
            if ((c = this.engine.getAssertions(p = this.requestor ? this.engine.getEffectiveClientResponsePolicy(this.ei, boi) : this.engine.getEffectiveServerResponsePolicy(this.ei, boi, (Destination)this.assertor), false)) != null) {
                this.vocabulary.addAll(c);
                if (null != this.faultVocabulary) {
                    this.faultVocabulary.addAll(c);
                }
            }
            if (boi.getFaults() == null) continue;
            for (BindingFaultInfo bfi : boi.getFaults()) {
                p = this.requestor ? this.engine.getEffectiveClientFaultPolicy(this.ei, bfi) : this.engine.getEffectiveServerFaultPolicy(this.ei, bfi, (Destination)this.assertor);
                c = this.engine.getAssertions(p, false);
                if (c == null) continue;
                this.vocabulary.addAll(c);
                if (null == this.faultVocabulary) continue;
                this.faultVocabulary.addAll(c);
            }
        }
    }

    Collection<PolicyAssertion> getSupportedAlternatives(Policy p) {
        ArrayList<PolicyAssertion> alternatives = new ArrayList<PolicyAssertion>();
        Iterator it = p.getAlternatives();
        while (it.hasNext()) {
            List alternative = CastUtils.cast((List)((List)it.next()), PolicyAssertion.class);
            if (!this.engine.supportsAlternative(alternative, null)) continue;
            alternatives.addAll(alternative);
        }
        return alternatives;
    }

    void initializeInterceptors(PolicyInterceptorProviderRegistry reg, Set<Interceptor> out, PolicyAssertion a, boolean fault) {
        Policy p;
        QName qn = a.getName();
        PolicyInterceptorProvider pp = (PolicyInterceptorProvider)reg.get((Object)qn);
        if (null != pp) {
            out.addAll(fault ? pp.getInFaultInterceptors() : pp.getInInterceptors());
        }
        if ((p = a.getPolicy()) != null) {
            for (PolicyAssertion a2 : this.getSupportedAlternatives(p)) {
                this.initializeInterceptors(reg, out, a2, fault);
            }
        }
    }

    void initializeInterceptors() {
        if (this.engine == null || this.engine.getBus() == null || this.engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class) == null) {
            return;
        }
        PolicyInterceptorProviderRegistry reg = (PolicyInterceptorProviderRegistry)this.engine.getBus().getExtension(PolicyInterceptorProviderRegistry.class);
        LinkedHashSet<Interceptor> out = new LinkedHashSet<Interceptor>();
        if (this.getChosenAlternative() != null) {
            for (PolicyAssertion a : this.getChosenAlternative()) {
                this.initializeInterceptors(reg, out, a, false);
            }
        }
        if (this.requestor) {
            this.interceptors = new ArrayList<Interceptor>(out);
            out.clear();
            for (PolicyAssertion a : this.getChosenAlternative()) {
                this.initializeInterceptors(reg, out, a, true);
            }
            this.faultInterceptors = new ArrayList<Interceptor>(out);
        } else if (this.ei != null && this.ei.getBinding() != null) {
            for (BindingOperationInfo boi : this.ei.getBinding().getOperations()) {
                Collection<PolicyAssertion> c;
                EffectivePolicy p = this.engine.getEffectiveServerRequestPolicy(this.ei, boi);
                if (p == null || p.getPolicy() == null || p.getPolicy().isEmpty() || (c = this.engine.getAssertions(p, true)) == null) continue;
                for (PolicyAssertion a : c) {
                    this.initializeInterceptors(reg, out, a, false);
                    this.initializeInterceptors(reg, out, a, true);
                }
            }
            this.interceptors = new ArrayList<Interceptor>(out);
        } else {
            this.interceptors = new ArrayList<Interceptor>(out);
        }
    }

    void setPolicy(Policy ep) {
        this.policy = ep;
    }

    void setChosenAlternative(Collection<PolicyAssertion> c) {
        this.chosenAlternative = c;
    }

    void setVocabulary(Collection<PolicyAssertion> v) {
        this.vocabulary = v;
    }

    void setFaultVocabulary(Collection<PolicyAssertion> v) {
        this.faultVocabulary = v;
    }

    void setInterceptors(List<Interceptor> in) {
        this.interceptors = in;
    }

    void setFaultInterceptors(List<Interceptor> inFault) {
        this.faultInterceptors = inFault;
    }

    protected EndpointPolicyImpl createEndpointPolicy() {
        return new EndpointPolicyImpl(this.ei, this.engine, this.requestor, this.assertor);
    }

    void checkExactlyOnes() {
        List assertions = this.policy.getPolicyComponents();
        if (assertions.size() <= 1) {
            return;
        }
        Policy p = new Policy();
        ExactlyOne alternatives = new ExactlyOne();
        p.addPolicyComponent((PolicyComponent)alternatives);
        for (Object a : assertions) {
            alternatives.addPolicyComponents(((ExactlyOne)a).getPolicyComponents());
        }
        this.setPolicy(p);
    }
}

