/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.configuration.spring.MapProvider;
import org.apache.cxf.extension.BusExtension;
import org.apache.cxf.extension.RegistryImpl;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.AssertionBuilderRegistry;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyException;
import org.apache.cxf.ws.policy.builder.xml.XmlPrimitiveAssertion;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionBuilderRegistryImpl
extends RegistryImpl<QName, AssertionBuilder>
implements AssertionBuilderRegistry,
BusExtension {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(AssertionBuilderRegistryImpl.class);
    private static final Logger LOG = LogUtils.getL7dLogger(AssertionBuilderRegistryImpl.class);
    private static final int IGNORED_CACHE_SIZE = 10;
    private boolean ignoreUnknownAssertions = true;
    private List<QName> ignored = new ArrayList<QName>(10);

    public AssertionBuilderRegistryImpl() {
        super(null);
    }

    public AssertionBuilderRegistryImpl(Map<QName, AssertionBuilder> builders) {
        super(builders);
    }

    public AssertionBuilderRegistryImpl(MapProvider<QName, AssertionBuilder> builders) {
        super(builders.createMap());
    }

    public Class<?> getRegistrationType() {
        return AssertionBuilderRegistry.class;
    }

    public void register(AssertionBuilder builder) {
        Collection names = builder.getKnownElements();
        for (QName n : names) {
            super.register((Object)n, (Object)builder);
        }
    }

    public boolean isIgnoreUnknownAssertions() {
        return this.ignoreUnknownAssertions;
    }

    public void setIgnoreUnknownAssertions(boolean ignore) {
        this.ignoreUnknownAssertions = ignore;
    }

    public PolicyAssertion build(Element element) {
        QName qname = new QName(element.getNamespaceURI(), element.getLocalName());
        AssertionBuilder builder = (AssertionBuilder)this.get(qname);
        if (null == builder) {
            Message m = new Message("NO_ASSERTIONBUILDER_EXC", BUNDLE, new Object[]{qname.toString()});
            if (this.ignoreUnknownAssertions) {
                boolean alreadyWarned = this.ignored.contains(qname);
                if (alreadyWarned) {
                    this.ignored.remove(qname);
                } else if (this.ignored.size() == 10) {
                    this.ignored.remove(9);
                }
                this.ignored.add(0, qname);
                if (!alreadyWarned) {
                    LOG.warning(m.toString());
                }
                return new XmlPrimitiveAssertion(element);
            }
            throw new PolicyException(m);
        }
        return builder.build(element);
    }
}

