/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.binding.Binding;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.SoapBinding;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.rm.BindingFaultFactory;
import org.apache.cxf.ws.rm.EncoderDecoder;
import org.apache.cxf.ws.rm.ProtocolVariation;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceAcknowledgement;
import org.w3c.dom.Element;

public class SoapFaultFactory
implements BindingFaultFactory {
    private static final Logger LOG = LogUtils.getL7dLogger(SoapFaultFactory.class);
    private SoapVersion version;

    public SoapFaultFactory(Binding binding) {
        this.version = ((SoapBinding)binding).getSoapVersion();
    }

    public Fault createFault(SequenceFault sf, Message msg) {
        Fault f = null;
        if (this.version == Soap11.getInstance()) {
            f = this.createSoap11Fault(sf);
            f.initCause((Throwable)sf);
        } else {
            f = this.createSoap12Fault(sf, msg);
        }
        return f;
    }

    Fault createSoap11Fault(SequenceFault sf) {
        SoapFault fault = new SoapFault(sf.getReason(), sf.isSender() ? this.version.getSender() : this.version.getReceiver());
        return fault;
    }

    Fault createSoap12Fault(SequenceFault sf, Message msg) {
        SoapFault fault = (SoapFault)this.createSoap11Fault(sf);
        fault.setSubCode(sf.getFaultCode());
        Object detail = sf.getDetail();
        if (null == detail) {
            return fault;
        }
        try {
            RMProperties rmps = RMContextUtils.retrieveRMProperties(msg, false);
            AddressingProperties maps = RMContextUtils.retrieveMAPs(msg, false, false);
            EncoderDecoder codec = ProtocolVariation.findVariant(rmps.getNamespaceURI(), maps.getNamespaceURI()).getCodec();
            this.setDetail(fault, detail, codec);
        }
        catch (Exception ex) {
            LogUtils.log((Logger)LOG, (Level)Level.SEVERE, (String)"MARSHAL_FAULT_DETAIL_EXC", (Throwable)ex);
            ex.printStackTrace();
        }
        return fault;
    }

    void setDetail(SoapFault fault, Object detail, EncoderDecoder codec) throws Exception {
        String name = fault.getSubCode().getLocalPart();
        Element element = null;
        if ("InvalidAcknowledgement".equals(name)) {
            element = codec.encodeSequenceAcknowledgement((SequenceAcknowledgement)detail);
        } else if (!"CreateSequenceRefused".equals(name) && !"WSRMRequired".equals(name)) {
            element = codec.encodeIdentifier((Identifier)detail);
        }
        fault.setDetail(element);
    }

    public String toString(Fault f) {
        SoapFault sf = (SoapFault)f;
        org.apache.cxf.common.i18n.Message msg = new org.apache.cxf.common.i18n.Message("SEQ_FAULT_MSG", LOG, new Object[]{sf.getReason(), sf.getFaultCode(), sf.getSubCode()});
        return msg.toString();
    }
}

