//
// This file was generated by the Eclipse Implementation of JAXB, v4.0.5 
// See https://eclipse-ee4j.github.io/jaxb-ri 
// Any modifications to this file will be lost upon recompilation of the source schema. 
//


package org.apache.cxf.ws.rm.manager;

import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;


/**
 * RM source configuration properties. 
 *             Used for configuring an RM source.
 * 
 * <p>Java class for SourcePolicyType complex type</p>.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.</p>
 * 
 * <pre>{@code
 * <complexType name="SourcePolicyType">
 *   <complexContent>
 *     <restriction base="{http://www.w3.org/2001/XMLSchema}anyType">
 *       <sequence>
 *         <element name="sequenceTerminationPolicy" type="{http://cxf.apache.org/ws/rm/manager}SequenceTerminationPolicyType" minOccurs="0"/>
 *         <element name="retryPolicy" type="{http://cxf.apache.org/ws/rm/manager}RetryPolicyType" minOccurs="0"/>
 *       </sequence>
 *       <attribute name="sequenceExpiration" type="{http://www.w3.org/2001/XMLSchema}duration" default="PT0S" />
 *       <attribute name="acksTo" type="{http://www.w3.org/2001/XMLSchema}string" />
 *       <attribute name="includeOffer" type="{http://www.w3.org/2001/XMLSchema}boolean" default="true" />
 *       <attribute name="offeredSequenceExpiration" type="{http://www.w3.org/2001/XMLSchema}duration" default="PT0S" />
 *       <attribute name="maxSequences" type="{http://www.w3.org/2001/XMLSchema}int" default="0" />
 *       <attribute name="ackRequestMode" type="{http://cxf.apache.org/ws/rm/manager}AckRequestModeType" default="pending" />
 *     </restriction>
 *   </complexContent>
 * </complexType>
 * }</pre>
 * 
 * 
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlType(name = "SourcePolicyType", propOrder = {
    "sequenceTerminationPolicy",
    "retryPolicy"
})
public class SourcePolicyType {

    protected SequenceTerminationPolicyType sequenceTerminationPolicy;
    protected RetryPolicyType retryPolicy;
    /**
     * Preferred lifetime of a sequence - included in createSequence 
     *                     requests issued by an RM source. 
     *                     A default of PT0S means that the sequence should never expire.
     * 
     */
    @XmlAttribute(name = "sequenceExpiration")
    protected Duration sequenceExpiration;
    /**
     * Address to which sequence acknowledgements should be sent. 
     *                     If this attribute is not set, defaults to the anonymous address.
     * 
     */
    @XmlAttribute(name = "acksTo")
    protected String acksTo;
    /**
     * Indicates if an RM source should include an offer for an inbound sequence
     *                     when issuing a createSequence request.
     * 
     */
    @XmlAttribute(name = "includeOffer")
    protected Boolean includeOffer;
    /**
     * The lifetime of an offered inbound sequence.
     *                     A default of PT0S means that the sequence never expires.
     * 
     */
    @XmlAttribute(name = "offeredSequenceExpiration")
    protected Duration offeredSequenceExpiration;
    /**
     * The maximum number of sequences that can be held active. A value of
     *                     0 indicates there is no limit.
     * 
     */
    @XmlAttribute(name = "maxSequences")
    protected Integer maxSequences;
    /**
     * When AckRequested will be included in a message being sent. The default value "pending"
     *                     means AckRequested will only be included when a previously-send message is waiting for
     *                     acknowledgement.
     * 
     */
    @XmlAttribute(name = "ackRequestMode")
    protected AckRequestModeType ackRequestMode;

    /**
     * Gets the value of the sequenceTerminationPolicy property.
     * 
     * @return
     *     possible object is
     *     {@link SequenceTerminationPolicyType }
     *     
     */
    public SequenceTerminationPolicyType getSequenceTerminationPolicy() {
        return sequenceTerminationPolicy;
    }

    /**
     * Sets the value of the sequenceTerminationPolicy property.
     * 
     * @param value
     *     allowed object is
     *     {@link SequenceTerminationPolicyType }
     *     
     */
    public void setSequenceTerminationPolicy(SequenceTerminationPolicyType value) {
        this.sequenceTerminationPolicy = value;
    }

    public boolean isSetSequenceTerminationPolicy() {
        return (this.sequenceTerminationPolicy!= null);
    }

    /**
     * Gets the value of the retryPolicy property.
     * 
     * @return
     *     possible object is
     *     {@link RetryPolicyType }
     *     
     */
    public RetryPolicyType getRetryPolicy() {
        return retryPolicy;
    }

    /**
     * Sets the value of the retryPolicy property.
     * 
     * @param value
     *     allowed object is
     *     {@link RetryPolicyType }
     *     
     */
    public void setRetryPolicy(RetryPolicyType value) {
        this.retryPolicy = value;
    }

    public boolean isSetRetryPolicy() {
        return (this.retryPolicy!= null);
    }

    /**
     * Sets the value of the sequenceExpiration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     * @see #getSequenceExpiration()
     */
    public void setSequenceExpiration(Duration value) {
        this.sequenceExpiration = value;
    }

    public boolean isSetSequenceExpiration() {
        return (this.sequenceExpiration!= null);
    }

    /**
     * Address to which sequence acknowledgements should be sent. 
     *                     If this attribute is not set, defaults to the anonymous address.
     * 
     * @return
     *     possible object is
     *     {@link String }
     *     
     */
    public String getAcksTo() {
        return acksTo;
    }

    /**
     * Sets the value of the acksTo property.
     * 
     * @param value
     *     allowed object is
     *     {@link String }
     *     
     * @see #getAcksTo()
     */
    public void setAcksTo(String value) {
        this.acksTo = value;
    }

    public boolean isSetAcksTo() {
        return (this.acksTo!= null);
    }

    /**
     * Sets the value of the offeredSequenceExpiration property.
     * 
     * @param value
     *     allowed object is
     *     {@link Duration }
     *     
     * @see #getOfferedSequenceExpiration()
     */
    public void setOfferedSequenceExpiration(Duration value) {
        this.offeredSequenceExpiration = value;
    }

    public boolean isSetOfferedSequenceExpiration() {
        return (this.offeredSequenceExpiration!= null);
    }

    /**
     * Sets the value of the ackRequestMode property.
     * 
     * @param value
     *     allowed object is
     *     {@link AckRequestModeType }
     *     
     * @see #getAckRequestMode()
     */
    public void setAckRequestMode(AckRequestModeType value) {
        this.ackRequestMode = value;
    }

    public boolean isSetAckRequestMode() {
        return (this.ackRequestMode!= null);
    }

    /**
     * Preferred lifetime of a sequence - included in createSequence 
     *                     requests issued by an RM source. 
     *                     A default of PT0S means that the sequence should never expire.
     * 
     */
    public Duration getSequenceExpiration() {
        if (null == sequenceExpiration) {
            try {
                return DatatypeFactory.newInstance().newDuration("PT0S");
            } catch (DatatypeConfigurationException _x) {
            }
        }
        return sequenceExpiration;
    }

    /**
     * Sets the value of the includeOffer property.
     * 
     */
    public void setIncludeOffer(boolean value) {
        includeOffer = value;
    }

    public void unsetIncludeOffer() {
        includeOffer = null;
    }

    public boolean isSetIncludeOffer() {
        return (this.includeOffer!= null);
    }

    /**
     * Indicates if an RM source should include an offer for an inbound sequence
     *                     when issuing a createSequence request.
     * 
     */
    public boolean isIncludeOffer() {
        if (null == includeOffer) {
            return true;
        }
        return includeOffer;
    }

    /**
     * The lifetime of an offered inbound sequence.
     *                     A default of PT0S means that the sequence never expires.
     * 
     */
    public Duration getOfferedSequenceExpiration() {
        if (null == offeredSequenceExpiration) {
            try {
                return DatatypeFactory.newInstance().newDuration("PT0S");
            } catch (DatatypeConfigurationException _x) {
            }
        }
        return offeredSequenceExpiration;
    }

    /**
     * Sets the value of the maxSequences property.
     * 
     */
    public void setMaxSequences(int value) {
        maxSequences = value;
    }

    public void unsetMaxSequences() {
        maxSequences = null;
    }

    public boolean isSetMaxSequences() {
        return (this.maxSequences!= null);
    }

    /**
     * The maximum number of sequences that can be held active. A value of
     *                     0 indicates there is no limit.
     * 
     */
    public int getMaxSequences() {
        if (null == maxSequences) {
            return  0;
        }
        return maxSequences;
    }

    /**
     * When AckRequested will be included in a message being sent. The default value "pending"
     *                     means AckRequested will only be included when a previously-send message is waiting for
     *                     acknowledgement.
     * 
     */
    public AckRequestModeType getAckRequestMode() {
        if (null == ackRequestMode) {
            return AckRequestModeType.fromValue("pending");
        }
        return ackRequestMode;
    }

}
