/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.LAYOUT, SP12Constants.LAYOUT);

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        Layout layout = new Layout(consts);
        this.processAlternative(element, layout, consts);
        return layout;
    }

    public void processAlternative(Element element, Layout parent, SPConstants consts) {
        Element child;
        Element polEl = PolicyConstants.findPolicyElement((Element)element);
        if (polEl != null && (child = DOMUtils.getFirstElement((Node)polEl)) != null) {
            parent.setValue(SPConstants.Layout.valueOf(child.getLocalName()));
        }
    }

    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

