/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.KerberosToken;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.ws.security.message.token.KerberosSecurity;

public class KerberosTokenPolicyValidator
extends AbstractTokenPolicyValidator {
    private Message message;

    public KerberosTokenPolicyValidator(Message message) {
        this.message = message;
    }

    public boolean validatePolicy(AssertionInfoMap aim, KerberosSecurity kerberosToken) {
        Collection krbAis = (Collection)aim.get((Object)SP12Constants.KERBEROS_TOKEN);
        if (krbAis != null && !krbAis.isEmpty()) {
            for (AssertionInfo ai : krbAis) {
                KerberosToken kerberosTokenPolicy = (KerberosToken)ai.getAssertion();
                ai.setAsserted(true);
                if (!this.isTokenRequired(kerberosTokenPolicy, this.message) || this.checkToken(kerberosTokenPolicy, kerberosToken)) continue;
                ai.setNotAsserted("An incorrect Kerberos Token Type is detected");
                return false;
            }
        }
        return true;
    }

    private boolean checkToken(KerberosToken kerberosTokenPolicy, KerberosSecurity kerberosToken) {
        boolean isV5ApReq = kerberosTokenPolicy.isV5ApReqToken11();
        boolean isGssV5ApReq = kerberosTokenPolicy.isGssV5ApReqToken11();
        if (isV5ApReq && kerberosToken.isV5ApReq()) {
            return true;
        }
        if (isGssV5ApReq && kerberosToken.isGssV5ApReq()) {
            return true;
        }
        return !isV5ApReq && !isGssV5ApReq;
    }
}

