/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.SamlToken;
import org.apache.cxf.ws.security.policy.model.Token;
import org.apache.cxf.ws.security.wss4j.AbstractTokenInterceptor;
import org.apache.cxf.ws.security.wss4j.SAMLUtils;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.handler.WSHandlerResult;
import org.apache.ws.security.processor.SAMLTokenProcessor;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.apache.ws.security.saml.ext.SAMLParms;
import org.apache.ws.security.validate.Validator;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SamlTokenInterceptor
extends AbstractTokenInterceptor {
    @Override
    protected void processToken(SoapMessage message) {
        Header h = this.findSecurityHeader(message, false);
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        Element child = DOMUtils.getFirstElement((Node)el);
        while (child != null) {
            if ("Assertion".equals(child.getLocalName()) && ("urn:oasis:names:tc:SAML:1.0:assertion".equals(child.getNamespaceURI()) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(child.getNamespaceURI()))) {
                try {
                    List<WSSecurityEngineResult> samlResults = this.processToken(child, message);
                    if (samlResults != null) {
                        ArrayList<WSHandlerResult> results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
                        if (results == null) {
                            results = new ArrayList<WSHandlerResult>();
                            message.put("RECV_RESULTS", results);
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, samlResults);
                        results.add(0, rResult);
                        boolean signed = false;
                        for (WSSecurityEngineResult result : samlResults) {
                            AssertionWrapper wrapper = (AssertionWrapper)result.get((Object)"saml-assertion");
                            if (!wrapper.isSigned()) continue;
                            signed = true;
                            break;
                        }
                        this.assertTokens(message, SP12Constants.SAML_TOKEN, signed);
                        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
                        for (AssertionInfo ai : aim.getAssertionInfo(SP12Constants.SAML_TOKEN)) {
                            SamlToken samlToken = (SamlToken)ai.getAssertion();
                            for (WSSecurityEngineResult result : samlResults) {
                                AssertionWrapper assertionWrapper = (AssertionWrapper)result.get((Object)"saml-assertion");
                                if (!this.checkVersion(samlToken, assertionWrapper)) {
                                    ai.setNotAsserted("Wrong SAML Version");
                                }
                                TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
                                Certificate[] tlsCerts = null;
                                if (tlsInfo != null) {
                                    tlsCerts = tlsInfo.getPeerCertificates();
                                }
                                if (!SAMLUtils.checkHolderOfKey(assertionWrapper, null, tlsCerts)) {
                                    ai.setNotAsserted("Assertion fails holder-of-key requirements");
                                    continue;
                                }
                                if (SAMLUtils.checkSenderVouches(assertionWrapper, tlsCerts, null, null)) continue;
                                ai.setNotAsserted("Assertion fails sender-vouches requirements");
                            }
                        }
                        Principal principal = (Principal)samlResults.get(0).get((Object)"principal");
                        message.put("wss4j.principal.result", (Object)principal);
                        SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
                        if (sc == null || sc.getUserPrincipal() == null) {
                            message.put(SecurityContext.class, (Object)new DefaultSecurityContext(principal, null));
                        }
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault((Throwable)ex);
                }
            }
            child = DOMUtils.getNextElement((Element)child);
        }
    }

    private List<WSSecurityEngineResult> processToken(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        RequestData data = new RequestData(){

            public CallbackHandler getCallbackHandler() {
                return SamlTokenInterceptor.this.getCallback(message);
            }

            public Validator getValidator(QName qName) throws WSSecurityException {
                String key = null;
                if (WSSecurityEngine.SAML_TOKEN.equals(qName)) {
                    key = "ws-security.saml1.validator";
                } else if (WSSecurityEngine.SAML2_TOKEN.equals(qName)) {
                    key = "ws-security.saml2.validator";
                }
                if (key != null) {
                    Object o = message.getContextualProperty(key);
                    try {
                        if (o instanceof Validator) {
                            return (Validator)o;
                        }
                        if (o instanceof Class) {
                            return (Validator)((Class)o).newInstance();
                        }
                        if (o instanceof String) {
                            return (Validator)ClassLoaderUtils.loadClass((String)o.toString(), SamlTokenInterceptor.class).newInstance();
                        }
                    }
                    catch (RuntimeException t) {
                        throw t;
                    }
                    catch (Throwable t) {
                        throw new WSSecurityException(t.getMessage(), t);
                    }
                }
                return super.getValidator(qName);
            }
        };
        data.setWssConfig(WSSConfig.getNewInstance());
        data.setSigCrypto(this.getCrypto(null, "ws-security.signature.crypto", "ws-security.signature.properties", message));
        SAMLTokenProcessor p = new SAMLTokenProcessor();
        List results = p.handleToken(tokenElement, data, wsDocInfo);
        return results;
    }

    @Override
    protected Token assertTokens(SoapMessage message) {
        return this.assertTokens(message, SP12Constants.SAML_TOKEN, true);
    }

    @Override
    protected void addToken(SoapMessage message) {
        WSSConfig.init();
        SamlToken tok = (SamlToken)this.assertTokens(message);
        Header h = this.findSecurityHeader(message, true);
        try {
            AssertionWrapper wrapper = this.addSamlToken(tok, message);
            if (wrapper == null) {
                AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
                Collection ais = aim.getAssertionInfo(SP12Constants.SAML_TOKEN);
                for (AssertionInfo ai : ais) {
                    if (!ai.isAsserted()) continue;
                    ai.setAsserted(false);
                }
                return;
            }
            Element el = (Element)h.getObject();
            el.appendChild(wrapper.toDOM(el.getOwnerDocument()));
        }
        catch (WSSecurityException ex) {
            this.policyNotAsserted((Token)tok, ex.getMessage(), message);
        }
    }

    private AssertionWrapper addSamlToken(SamlToken token, SoapMessage message) throws WSSecurityException {
        Object o = message.getContextualProperty("ws-security.saml-callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        if (handler == null) {
            return null;
        }
        SAMLParms samlParms = new SAMLParms();
        samlParms.setCallbackHandler(handler);
        if (token.isUseSamlVersion11Profile10() || token.isUseSamlVersion11Profile11()) {
            samlParms.setSAMLVersion(SAMLVersion.VERSION_11);
        } else if (token.isUseSamlVersion20Profile11()) {
            samlParms.setSAMLVersion(SAMLVersion.VERSION_20);
        }
        AssertionWrapper assertion = new AssertionWrapper(samlParms);
        boolean selfSignAssertion = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.self-sign-saml-assertion", (boolean)false);
        if (selfSignAssertion) {
            Crypto crypto = this.getCrypto(token, "ws-security.signature.crypto", "ws-security.signature.properties", message);
            String userNameKey = "ws-security.signature.username";
            String user = (String)message.getContextualProperty(userNameKey);
            if (crypto != null && StringUtils.isEmpty((String)user)) {
                try {
                    user = crypto.getDefaultX509Identifier();
                }
                catch (WSSecurityException e1) {
                    throw new Fault((Throwable)e1);
                }
            }
            if (StringUtils.isEmpty((String)user)) {
                return null;
            }
            String password = (String)message.getContextualProperty("ws-security.password");
            if (StringUtils.isEmpty((String)password)) {
                password = this.getPassword(user, token, 3, message);
            }
            if (password == null) {
                password = "";
            }
            assertion.signAssertion(user, password, crypto, false);
        }
        return assertion;
    }

    private Crypto getCrypto(SamlToken samlToken, String cryptoKey, String propKey, SoapMessage message) throws WSSecurityException {
        Properties properties;
        Crypto crypto;
        block19: {
            crypto = (Crypto)message.getContextualProperty(cryptoKey);
            if (crypto != null) {
                return crypto;
            }
            Object o = message.getContextualProperty(propKey);
            if (o == null) {
                return null;
            }
            properties = null;
            if (o instanceof Properties) {
                properties = (Properties)o;
            } else {
                if (o instanceof String) {
                    ResourceManager rm = (ResourceManager)((Bus)message.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
                    URL url = (URL)rm.resolveResource((String)o, URL.class);
                    try {
                        if (url == null) {
                            url = ClassLoaderUtils.getResource((String)((String)o), ((Object)((Object)this)).getClass());
                        }
                        if (url == null) {
                            try {
                                url = new URL((String)o);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (url != null) {
                            InputStream ins = url.openStream();
                            properties = new Properties();
                            properties.load(ins);
                            ins.close();
                        } else if (samlToken != null) {
                            this.policyNotAsserted((Token)samlToken, "Could not find properties file " + o, message);
                        }
                        break block19;
                    }
                    catch (IOException e) {
                        if (samlToken != null) {
                            this.policyNotAsserted((Token)samlToken, e.getMessage(), message);
                        }
                        break block19;
                    }
                }
                if (o instanceof URL) {
                    properties = new Properties();
                    try {
                        InputStream ins = ((URL)o).openStream();
                        properties.load(ins);
                        ins.close();
                    }
                    catch (IOException e) {
                        if (samlToken == null) break block19;
                        this.policyNotAsserted((Token)samlToken, e.getMessage(), message);
                    }
                }
            }
        }
        if (properties != null) {
            crypto = CryptoFactory.getInstance((Properties)properties);
        }
        return crypto;
    }

    private boolean checkVersion(SamlToken samlToken, AssertionWrapper assertionWrapper) {
        if ((samlToken.isUseSamlVersion11Profile10() || samlToken.isUseSamlVersion11Profile11()) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_11) {
            return false;
        }
        return !samlToken.isUseSamlVersion20Profile11() || assertionWrapper.getSamlVersion() == SAMLVersion.VERSION_20;
    }
}

