/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.tokenstore;

import java.io.Serializable;
import java.security.Principal;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.util.Date;
import java.util.Properties;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SecurityToken
implements Serializable {
    private static final long serialVersionUID = 3820740387121650613L;
    private String id;
    private String wsuId;
    private transient Element token;
    private transient Element attachedReference;
    private transient Element unattachedReference;
    private Properties properties;
    private transient byte[] secret;
    private Date created;
    private Date expires;
    private String issuerAddress;
    private String encrKeySha1Value;
    private int tokenHash;
    private String transformedTokenIdentifier;
    private String tokenType;
    private X509Certificate x509cert;
    private transient Crypto crypto;
    private transient Principal principal;

    public SecurityToken() {
    }

    public SecurityToken(String id) {
        this.id = id;
        if (this.id != null && this.id.length() > 0 && this.id.charAt(0) == '#') {
            this.id = this.id.substring(1);
        }
    }

    public SecurityToken(String id, Date created, Date expires) {
        this.id = id;
        if (this.id != null && this.id.length() > 0 && this.id.charAt(0) == '#') {
            this.id = this.id.substring(1);
        }
        if (created != null) {
            this.created = new Date(created.getTime());
        }
        if (expires != null) {
            this.expires = new Date(expires.getTime());
        }
    }

    public SecurityToken(String id, Element tokenElem, Date created, Date expires) {
        this.id = id;
        if (this.id != null && this.id.length() > 0 && this.id.charAt(0) == '#') {
            this.id = this.id.substring(1);
        }
        this.token = SecurityToken.cloneElement(tokenElem);
        if (created != null) {
            this.created = new Date(created.getTime());
        }
        if (expires != null) {
            this.expires = new Date(expires.getTime());
        }
    }

    public SecurityToken(String id, Element tokenElem, Element lifetimeElem) {
        this.id = id;
        if (this.id != null && this.id.length() > 0 && this.id.charAt(0) == '#') {
            this.id = this.id.substring(1);
        }
        this.token = SecurityToken.cloneElement(tokenElem);
        if (lifetimeElem != null) {
            this.processLifeTime(lifetimeElem);
        }
    }

    private static Element cloneElement(Element el) {
        try {
            W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
            writer.setNsRepairing(true);
            StaxUtils.copy((Element)el, (XMLStreamWriter)writer);
            return writer.getDocument().getDocumentElement();
        }
        catch (Exception exception) {
            return el;
        }
    }

    private void processLifeTime(Element lifetimeElem) {
        try {
            Element createdElem = DOMUtils.getFirstChildWithName((Element)lifetimeElem, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Created");
            XmlSchemaDateFormat zulu = new XmlSchemaDateFormat();
            this.created = zulu.parse(DOMUtils.getContent((Node)createdElem));
            Element expiresElem = DOMUtils.getFirstChildWithName((Element)lifetimeElem, (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", (String)"Expires");
            this.expires = zulu.parse(DOMUtils.getContent((Node)expiresElem));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Element getToken() {
        return this.token;
    }

    public void setToken(Element token) {
        this.token = token;
    }

    public String getTransformedTokenIdentifier() {
        return this.transformedTokenIdentifier;
    }

    public void setTransformedTokenIdentifier(String transformedTokenIdentifier) {
        this.transformedTokenIdentifier = transformedTokenIdentifier;
    }

    public void setId(String id) {
        this.id = id;
        if (this.id != null && this.id.length() > 0 && this.id.charAt(0) == '#') {
            this.id = this.id.substring(1);
        }
    }

    public String getId() {
        return this.id;
    }

    public byte[] getSecret() {
        return this.secret;
    }

    public void setSecret(byte[] secret) {
        this.secret = secret;
    }

    public Element getAttachedReference() {
        return this.attachedReference;
    }

    public void setAttachedReference(Element attachedReference) {
        if (attachedReference != null) {
            this.attachedReference = SecurityToken.cloneElement(attachedReference);
        }
    }

    public Element getUnattachedReference() {
        return this.unattachedReference;
    }

    public void setUnattachedReference(Element unattachedReference) {
        if (unattachedReference != null) {
            this.unattachedReference = SecurityToken.cloneElement(unattachedReference);
        }
    }

    public Date getCreated() {
        if (this.created == null) {
            return null;
        }
        return (Date)this.created.clone();
    }

    public Date getExpires() {
        if (this.expires == null) {
            return null;
        }
        return (Date)this.expires.clone();
    }

    public boolean isExpired() {
        Date rightNow;
        return this.expires != null && this.expires.before(rightNow = new Date());
    }

    public void setExpires(Date expires) {
        this.expires = expires == null ? null : new Date(expires.getTime());
    }

    public String getIssuerAddress() {
        return this.issuerAddress;
    }

    public void setIssuerAddress(String issuerAddress) {
        this.issuerAddress = issuerAddress;
    }

    public void setSHA1(String sha) {
        this.encrKeySha1Value = sha;
    }

    public String getSHA1() {
        return this.encrKeySha1Value;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public void setTokenType(String s) {
        this.tokenType = s;
    }

    public void setWsuId(String wsuId) {
        this.wsuId = wsuId;
    }

    public String getWsuId() {
        String t;
        if (this.wsuId != null) {
            return this.wsuId;
        }
        Element elem = this.getAttachedReference();
        if (elem != null && (t = SecurityToken.getIdFromSTR(elem)) != null) {
            return t;
        }
        elem = this.getUnattachedReference();
        if (elem != null && (t = SecurityToken.getIdFromSTR(elem)) != null) {
            return t;
        }
        return null;
    }

    public static String getIdFromSTR(Element str) {
        Element child = DOMUtils.getFirstElement((Node)str);
        if (child == null) {
            return null;
        }
        if ("KeyInfo".equals(child.getLocalName()) && "http://www.w3.org/2000/09/xmldsig#".equals(child.getNamespaceURI())) {
            return DOMUtils.getContent((Node)child);
        }
        if (Reference.TOKEN.getLocalPart().equals(child.getLocalName()) && Reference.TOKEN.getNamespaceURI().equals(child.getNamespaceURI())) {
            return child.getAttributeNS(null, "URI").substring(1);
        }
        return null;
    }

    public void setX509Certificate(X509Certificate cert, Crypto cpt) {
        this.x509cert = cert;
        this.crypto = cpt;
    }

    public X509Certificate getX509Certificate() {
        return this.x509cert;
    }

    public Crypto getCrypto() {
        return this.crypto;
    }

    public void setTokenHash(int hash) {
        this.tokenHash = hash;
    }

    public int getTokenHash() {
        return this.tokenHash;
    }

    public void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    public Principal getPrincipal() {
        return this.principal;
    }
}

