/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyConstants;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.HttpsToken;
import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.neethi.builders.AssertionBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HttpsTokenBuilder
implements AssertionBuilder<Element> {
    PolicyBuilder builder;

    public HttpsTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public Assertion build(Element element, AssertionBuilderFactory factory) {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        HttpsToken httpsToken = new HttpsToken(consts);
        httpsToken.setOptional(PolicyConstants.isOptional((Element)element));
        httpsToken.setIgnorable(PolicyConstants.isIgnorable((Element)element));
        if (consts.getVersion() == SPConstants.Version.SP_V11) {
            String attr = DOMUtils.getAttribute((Element)element, (QName)SPConstants.REQUIRE_CLIENT_CERTIFICATE);
            if (attr != null) {
                httpsToken.setRequireClientCertificate("true".equals(attr));
            }
        } else {
            Element polEl = PolicyConstants.findPolicyElement((Element)element);
            if (polEl == null) {
                throw new IllegalArgumentException("sp:HttpsToken/wsp:Policy must have a value");
            }
            Element child = DOMUtils.getFirstElement((Node)polEl);
            if (child != null) {
                if (SP12Constants.HTTP_BASIC_AUTHENTICATION.equals(DOMUtils.getElementQName((Element)child))) {
                    httpsToken.setHttpBasicAuthentication(true);
                } else if (SP12Constants.HTTP_DIGEST_AUTHENTICATION.equals(DOMUtils.getElementQName((Element)child))) {
                    httpsToken.setHttpDigestAuthentication(true);
                } else if (SP12Constants.REQUIRE_CLIENT_CERTIFICATE.equals(DOMUtils.getElementQName((Element)child))) {
                    httpsToken.setRequireClientCertificate(true);
                }
            }
        }
        return httpsToken;
    }

    public QName[] getKnownElements() {
        return new QName[]{SP11Constants.HTTPS_TOKEN, SP12Constants.HTTPS_TOKEN};
    }
}

