/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.model;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.AbstractSecurityAssertion;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.neethi.PolicyComponent;

public class RequiredParts
extends AbstractSecurityAssertion {
    private List<Header> headers = new ArrayList<Header>();

    public RequiredParts(SPConstants version) {
        super(version);
    }

    public List<Header> getHeaders() {
        return this.headers;
    }

    public void addHeader(Header header) {
        this.headers.add(header);
    }

    public QName getRealName() {
        return SP12Constants.REQUIRED_PARTS;
    }

    public QName getName() {
        return SP12Constants.REQUIRED_PARTS;
    }

    @Override
    public PolicyComponent normalize() {
        return this;
    }

    public void serialize(XMLStreamWriter writer) throws XMLStreamException {
        String localName = this.getRealName().getLocalPart();
        String namespaceURI = this.getRealName().getNamespaceURI();
        String prefix = writer.getPrefix(namespaceURI);
        if (prefix == null) {
            prefix = this.getRealName().getPrefix();
            writer.setPrefix(prefix, namespaceURI);
        }
        writer.writeStartElement(prefix, localName, namespaceURI);
        writer.writeNamespace(prefix, namespaceURI);
        for (Header header : this.headers) {
            writer.writeStartElement(prefix, "Header", namespaceURI);
            if (!StringUtils.isEmpty((String)header.getName())) {
                writer.writeAttribute("Name", header.getName());
            }
            writer.writeAttribute("Namespace", header.getNamespace());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

