/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedElements;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.SupportingTokenPolicyValidator;
import org.apache.ws.security.WSDataRef;
import org.apache.ws.security.WSSecurityEngine;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.message.token.KerberosSecurity;
import org.apache.ws.security.message.token.PKIPathSecurity;
import org.apache.ws.security.message.token.X509Security;
import org.apache.ws.security.saml.SAMLKeyInfo;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractSupportingTokenPolicyValidator
extends AbstractTokenPolicyValidator
implements SupportingTokenPolicyValidator {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSupportingTokenPolicyValidator.class);
    private Message message;
    private List<WSSecurityEngineResult> results;
    private List<WSSecurityEngineResult> signedResults;
    private List<WSSecurityEngineResult> encryptedResults;
    private List<WSSecurityEngineResult> utResults;
    private List<WSSecurityEngineResult> samlResults;
    private boolean validateUsernameToken = true;
    private Element timestamp;
    private boolean signed;
    private boolean encrypted;
    private boolean derived;
    private boolean endorsed;
    private SignedEncryptedElements signedElements;
    private SignedEncryptedElements encryptedElements;
    private SignedEncryptedParts signedParts;
    private SignedEncryptedParts encryptedParts;

    @Override
    public void setUsernameTokenResults(List<WSSecurityEngineResult> utResultsList, boolean valUsernameToken) {
        this.utResults = utResultsList;
        this.validateUsernameToken = valUsernameToken;
    }

    @Override
    public void setSAMLTokenResults(List<WSSecurityEngineResult> samlResultsList) {
        this.samlResults = samlResultsList;
    }

    @Override
    public void setTimestampElement(Element timestampElement) {
        this.timestamp = timestampElement;
    }

    public void setMessage(Message msg) {
        this.message = msg;
    }

    public void setResults(List<WSSecurityEngineResult> results) {
        this.results = results;
    }

    public void setSignedResults(List<WSSecurityEngineResult> signedResults) {
        this.signedResults = signedResults;
    }

    public void setEncryptedResults(List<WSSecurityEngineResult> encryptedResults) {
        this.encryptedResults = encryptedResults;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public void setEncrypted(boolean encrypted) {
        this.encrypted = encrypted;
    }

    public void setDerived(boolean derived) {
        this.derived = derived;
    }

    public void setEndorsed(boolean endorsed) {
        this.endorsed = endorsed;
    }

    protected boolean processUsernameTokens() {
        if (!this.validateUsernameToken) {
            return true;
        }
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        tokenResults.addAll(this.utResults);
        ArrayList<WSSecurityEngineResult> dktResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.utResults) {
            byte[] secret;
            WSSecurityEngineResult dktResult;
            if (!this.derived || (dktResult = this.getMatchingDerivedKey(secret = (byte[])wser.get((Object)"secret"))) == null) continue;
            dktResults.add(dktResult);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        tokenResults.addAll(dktResults);
        return (!this.endorsed || this.checkEndorsed(tokenResults)) && this.validateSignedEncryptedPolicies(tokenResults);
    }

    protected boolean processSAMLTokens() {
        if (this.samlResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(this.samlResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(this.samlResults)) {
            return false;
        }
        if (this.endorsed && !this.checkEndorsed(this.samlResults)) {
            return false;
        }
        return this.validateSignedEncryptedPolicies(this.samlResults);
    }

    protected boolean processKerberosTokens() {
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        ArrayList<WSSecurityEngineResult> dktResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.results) {
            byte[] secret;
            WSSecurityEngineResult dktResult;
            BinarySecurity binarySecurity;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 4096 || !((binarySecurity = (BinarySecurity)wser.get((Object)"binary-security-token")) instanceof KerberosSecurity)) continue;
            if (this.derived && (dktResult = this.getMatchingDerivedKey(secret = (byte[])wser.get((Object)"secret"))) != null) {
                dktResults.add(dktResult);
            }
            tokenResults.add(wser);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        tokenResults.addAll(dktResults);
        if (this.endorsed && !this.checkEndorsed(tokenResults)) {
            return false;
        }
        return this.validateSignedEncryptedPolicies(tokenResults);
    }

    protected boolean processX509Tokens() {
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        ArrayList<WSSecurityEngineResult> dktResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.results) {
            WSSecurityEngineResult resultToStore;
            BinarySecurity binarySecurity;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 4096 || !((binarySecurity = (BinarySecurity)wser.get((Object)"binary-security-token")) instanceof X509Security) && !(binarySecurity instanceof PKIPathSecurity)) continue;
            if (this.derived && (resultToStore = this.processX509DerivedTokenResult(wser)) != null) {
                dktResults.add(resultToStore);
            }
            tokenResults.add(wser);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        tokenResults.addAll(dktResults);
        if (this.endorsed && !this.checkEndorsed(tokenResults)) {
            return false;
        }
        return this.validateSignedEncryptedPolicies(tokenResults);
    }

    protected boolean processKeyValueTokens() {
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.signedResults) {
            PublicKey publicKey = (PublicKey)wser.get((Object)"public-key");
            if (publicKey == null) continue;
            tokenResults.add(wser);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        if (this.endorsed && !this.checkEndorsed(tokenResults)) {
            return false;
        }
        return this.validateSignedEncryptedPolicies(tokenResults);
    }

    private boolean validateSignedEncryptedPolicies(List<WSSecurityEngineResult> tokenResults) {
        if (!this.validateSignedEncryptedParts(this.signedParts, false, this.signedResults, tokenResults)) {
            return false;
        }
        if (!this.validateSignedEncryptedParts(this.encryptedParts, true, this.encryptedResults, tokenResults)) {
            return false;
        }
        if (!this.validateSignedEncryptedElements(this.signedElements, false, this.signedResults, tokenResults)) {
            return false;
        }
        return this.validateSignedEncryptedElements(this.encryptedElements, false, this.encryptedResults, tokenResults);
    }

    protected boolean processSCTokens() {
        ArrayList<WSSecurityEngineResult> tokenResults = new ArrayList<WSSecurityEngineResult>();
        ArrayList<WSSecurityEngineResult> dktResults = new ArrayList<WSSecurityEngineResult>();
        for (WSSecurityEngineResult wser : this.results) {
            byte[] secret;
            WSSecurityEngineResult dktResult;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 1024) continue;
            if (this.derived && (dktResult = this.getMatchingDerivedKey(secret = (byte[])wser.get((Object)"secret"))) != null) {
                dktResults.add(dktResult);
            }
            tokenResults.add(wser);
        }
        if (tokenResults.isEmpty()) {
            return false;
        }
        if (this.signed && !this.areTokensSigned(tokenResults)) {
            return false;
        }
        if (this.encrypted && !this.areTokensEncrypted(tokenResults)) {
            return false;
        }
        tokenResults.addAll(dktResults);
        if (this.endorsed && !this.checkEndorsed(tokenResults)) {
            return false;
        }
        return this.validateSignedEncryptedPolicies(tokenResults);
    }

    private WSSecurityEngineResult processX509DerivedTokenResult(WSSecurityEngineResult result) {
        byte[] secret;
        WSSecurityEngineResult dktResult;
        X509Certificate cert = (X509Certificate)result.get((Object)"x509-certificate");
        WSSecurityEngineResult encrResult = this.getMatchingEncryptedKey(cert);
        if (encrResult != null && (dktResult = this.getMatchingDerivedKey(secret = (byte[])encrResult.get((Object)"secret"))) != null) {
            return dktResult;
        }
        return null;
    }

    private WSSecurityEngineResult getMatchingDerivedKey(byte[] secret) {
        for (WSSecurityEngineResult wser : this.results) {
            byte[] dktSecret;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 2048 || !Arrays.equals(secret, dktSecret = (byte[])wser.get((Object)"secret"))) continue;
            return wser;
        }
        return null;
    }

    private WSSecurityEngineResult getMatchingEncryptedKey(X509Certificate cert) {
        for (WSSecurityEngineResult wser : this.results) {
            X509Certificate encrCert;
            Integer actInt = (Integer)wser.get((Object)"action");
            if (actInt != 4 || !cert.equals(encrCert = (X509Certificate)wser.get((Object)"x509-certificate"))) continue;
            return wser;
        }
        return null;
    }

    private boolean isTLSInUse() {
        TLSSessionInfo tlsInfo = (TLSSessionInfo)this.message.get(TLSSessionInfo.class);
        return tlsInfo != null;
    }

    private boolean checkEndorsed(List<WSSecurityEngineResult> tokenResults) {
        boolean endorsingSatisfied = false;
        if (this.isTLSInUse()) {
            endorsingSatisfied = this.checkTimestampIsSigned(tokenResults);
        }
        if (!endorsingSatisfied) {
            endorsingSatisfied = this.checkSignatureIsSigned(tokenResults);
        }
        return endorsingSatisfied;
    }

    private boolean areTokensSigned(List<WSSecurityEngineResult> tokens) {
        if (!this.isTLSInUse()) {
            for (WSSecurityEngineResult wser : tokens) {
                Element tokenElement = (Element)wser.get((Object)"token-element");
                if (tokenElement != null && this.isTokenSigned(tokenElement)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean areTokensEncrypted(List<WSSecurityEngineResult> tokens) {
        if (!this.isTLSInUse()) {
            for (WSSecurityEngineResult wser : tokens) {
                Element tokenElement = (Element)wser.get((Object)"token-element");
                if (tokenElement != null && this.isTokenEncrypted(tokenElement)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkTimestampIsSigned(List<WSSecurityEngineResult> tokenResults) {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (sl == null) continue;
            for (WSDataRef dataRef : sl) {
                if (this.timestamp != dataRef.getProtectedElement() || !this.checkSignatureOrEncryptionResult(signedResult, tokenResults)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSignatureIsSigned(List<WSSecurityEngineResult> tokenResults) {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (sl == null || sl.size() < 1) continue;
            for (WSDataRef dataRef : sl) {
                QName signedQName = dataRef.getName();
                if (!WSSecurityEngine.SIGNATURE.equals(signedQName) || !this.checkSignatureOrEncryptionResult(signedResult, tokenResults)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkSignatureOrEncryptionResult(WSSecurityEngineResult result, List<WSSecurityEngineResult> tokenResult) {
        X509Certificate cert = (X509Certificate)result.get((Object)"x509-certificate");
        byte[] secret = (byte[])result.get((Object)"secret");
        PublicKey publicKey = (PublicKey)result.get((Object)"public-key");
        for (WSSecurityEngineResult token : tokenResult) {
            Integer actInt = (Integer)token.get((Object)"action");
            BinarySecurity binarySecurity = (BinarySecurity)token.get((Object)"binary-security-token");
            if (binarySecurity instanceof X509Security || binarySecurity instanceof PKIPathSecurity) {
                X509Certificate foundCert = (X509Certificate)token.get((Object)"x509-certificate");
                if (!foundCert.equals(cert)) continue;
                return true;
            }
            if (actInt == 16 || actInt == 8) {
                AssertionWrapper assertionWrapper = (AssertionWrapper)token.get((Object)"saml-assertion");
                SAMLKeyInfo samlKeyInfo = assertionWrapper.getSubjectKeyInfo();
                if (samlKeyInfo == null) continue;
                X509Certificate[] subjectCerts = samlKeyInfo.getCerts();
                byte[] subjectSecretKey = samlKeyInfo.getSecret();
                PublicKey subjectPublicKey = samlKeyInfo.getPublicKey();
                if (!(cert != null && subjectCerts != null && cert.equals(subjectCerts[0]) || subjectSecretKey != null && Arrays.equals(subjectSecretKey, secret)) && (subjectPublicKey == null || !subjectPublicKey.equals(publicKey))) continue;
                return true;
            }
            if (publicKey != null) {
                PublicKey foundPublicKey = (PublicKey)token.get((Object)"public-key");
                if (!publicKey.equals(foundPublicKey)) continue;
                return true;
            }
            byte[] foundSecret = (byte[])token.get((Object)"secret");
            byte[] derivedKey = (byte[])token.get((Object)"encrypted-ephemeral-key-bytes");
            if ((foundSecret == null || !Arrays.equals(foundSecret, secret)) && (derivedKey == null || !Arrays.equals(derivedKey, secret))) continue;
            return true;
        }
        return false;
    }

    private boolean validateSignedEncryptedParts(SignedEncryptedParts parts, boolean content, List<WSSecurityEngineResult> protResults, List<WSSecurityEngineResult> tokenResults) {
        if (parts == null) {
            return true;
        }
        if (parts.isBody()) {
            SOAPMessage soapMessage = (SOAPMessage)this.message.getContent(SOAPMessage.class);
            SOAPBody soapBody = null;
            try {
                soapBody = soapMessage.getSOAPBody();
            }
            catch (SOAPException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
                return false;
            }
            if (!this.checkProtectionResult((Element)soapBody, content, protResults, tokenResults)) {
                return false;
            }
        }
        for (Header h : parts.getHeaders()) {
            SOAPMessage soapMessage = (SOAPMessage)this.message.getContent(SOAPMessage.class);
            SOAPHeader soapHeader = null;
            try {
                soapHeader = soapMessage.getSOAPHeader();
            }
            catch (SOAPException ex) {
                LOG.log(Level.FINE, ex.getMessage(), ex);
                return false;
            }
            List elements = h.getName() == null ? DOMUtils.getChildrenWithNamespace((Element)soapHeader, (String)h.getNamespace()) : DOMUtils.getChildrenWithName((Element)soapHeader, (String)h.getNamespace(), (String)h.getName());
            for (Element el : elements) {
                if (this.checkProtectionResult(el, false, protResults, tokenResults)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkProtectionResult(Element elementToProtect, boolean content, List<WSSecurityEngineResult> protResults, List<WSSecurityEngineResult> tokenResults) {
        for (WSSecurityEngineResult result : protResults) {
            List dataRefs = CastUtils.cast((List)((List)result.get((Object)"data-ref-uris")));
            if (dataRefs == null) continue;
            for (WSDataRef dataRef : dataRefs) {
                if (elementToProtect != dataRef.getProtectedElement() || content != dataRef.isContent() || !this.checkSignatureOrEncryptionResult(result, tokenResults)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean validateSignedEncryptedElements(SignedEncryptedElements elements, boolean content, List<WSSecurityEngineResult> protResults, List<WSSecurityEngineResult> tokenResults) {
        if (elements == null) {
            return true;
        }
        Map<String, String> namespaces = elements.getDeclaredNamespaces();
        List<String> xpaths = elements.getXPathExpressions();
        if (xpaths != null) {
            SOAPMessage soapMessage = (SOAPMessage)this.message.getContent(SOAPMessage.class);
            Element soapEnvelope = soapMessage.getSOAPPart().getDocumentElement();
            for (String xPath : xpaths) {
                if (this.checkXPathResult(soapEnvelope, xPath, namespaces, protResults, tokenResults)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkXPathResult(Element soapEnvelope, String xPath, Map<String, String> namespaces, List<WSSecurityEngineResult> protResults, List<WSSecurityEngineResult> tokenResults) {
        XPathFactory factory = XPathFactory.newInstance();
        XPath xpath = factory.newXPath();
        if (namespaces != null) {
            xpath.setNamespaceContext((NamespaceContext)new MapNamespaceContext(namespaces));
        }
        for (String xpathString : Arrays.asList(xPath)) {
            NodeList list;
            try {
                list = (NodeList)xpath.evaluate(xpathString, soapEnvelope, XPathConstants.NODESET);
            }
            catch (XPathExpressionException e) {
                LOG.log(Level.FINE, e.getMessage(), e);
                return false;
            }
            if (list.getLength() == 0) continue;
            for (int x = 0; x < list.getLength(); ++x) {
                Element el = (Element)list.item(x);
                if (this.checkProtectionResult(el, false, protResults, tokenResults)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isTokenSigned(Element token) {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List dataRefs = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            for (WSDataRef dataRef : dataRefs) {
                if (token != dataRef.getProtectedElement()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isTokenEncrypted(Element token) {
        for (WSSecurityEngineResult signedResult : this.encryptedResults) {
            List dataRefs = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (dataRefs == null) {
                return false;
            }
            for (WSDataRef dataRef : dataRefs) {
                if (token != dataRef.getProtectedElement()) continue;
                return true;
            }
        }
        return false;
    }

    public void setUtResults(List<WSSecurityEngineResult> utResults) {
        this.utResults = utResults;
    }

    public void setValidateUsernameToken(boolean validateUsernameToken) {
        this.validateUsernameToken = validateUsernameToken;
    }

    public void setTimestamp(Element timestamp) {
        this.timestamp = timestamp;
    }

    public void setSignedElements(SignedEncryptedElements signedElements) {
        this.signedElements = signedElements;
    }

    public void setEncryptedElements(SignedEncryptedElements encryptedElements) {
        this.encryptedElements = encryptedElements;
    }

    public void setSignedParts(SignedEncryptedParts signedParts) {
        this.signedParts = signedParts;
    }

    public void setEncryptedParts(SignedEncryptedParts encryptedParts) {
        this.encryptedParts = encryptedParts;
    }
}

