/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Layout;
import org.apache.cxf.ws.security.policy.model.TransportBinding;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AlgorithmSuitePolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.w3c.dom.Element;

public class TransportBindingPolicyValidator
extends AbstractBindingPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection ais = (Collection)aim.get((Object)SP12Constants.TRANSPORT_BINDING);
        if (ais == null || ais.isEmpty()) {
            return true;
        }
        for (AssertionInfo ai : ais) {
            boolean timestampLast;
            AlgorithmSuitePolicyValidator algorithmValidator;
            TransportBinding binding = (TransportBinding)ai.getAssertion();
            ai.setAsserted(true);
            boolean initiator = MessageUtils.isRequestor((Message)message);
            TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
            if (!initiator && tlsInfo == null) {
                ai.setNotAsserted("TLS is not enabled");
                continue;
            }
            if (binding.getTransportToken() != null) {
                this.assertPolicy(aim, binding.getTransportToken());
            }
            if (!(algorithmValidator = new AlgorithmSuitePolicyValidator(results)).validatePolicy(ai, binding.getAlgorithmSuite())) continue;
            if (!this.validateTimestamp(binding.isIncludeTimestamp(), true, results, signedResults, message)) {
                String error = "Received Timestamp does not match the requirements";
                this.notAssertPolicy(aim, SP12Constants.INCLUDE_TIMESTAMP, error);
                ai.setNotAsserted(error);
                continue;
            }
            this.assertPolicy(aim, SP12Constants.INCLUDE_TIMESTAMP);
            Layout layout = binding.getLayout();
            boolean timestampFirst = layout.getValue() == SPConstants.Layout.LaxTsFirst;
            boolean bl = timestampLast = layout.getValue() == SPConstants.Layout.LaxTsLast;
            if (!this.validateLayout(timestampFirst, timestampLast, results)) {
                String error = "Layout does not match the requirements";
                this.notAssertPolicy(aim, layout, error);
                ai.setNotAsserted(error);
                continue;
            }
            this.assertPolicy(aim, layout);
        }
        this.assertPolicy(aim, SP12Constants.ENCRYPTED_PARTS);
        this.assertPolicy(aim, SP12Constants.SIGNED_PARTS);
        return true;
    }
}

