/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.interceptors;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.crypto.SecretKey;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AbstractPolicyInterceptorProvider;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.kerberos.KerberosClient;
import org.apache.cxf.ws.security.kerberos.KerberosUtils;
import org.apache.cxf.ws.security.policy.interceptors.NegotiationUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.KerberosTokenInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JStaxInInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyBasedWSS4JStaxOutInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyStaxActionInInterceptor;
import org.apache.cxf.ws.security.wss4j.StaxSecurityContextInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.cxf.ws.security.wss4j.policyvalidators.KerberosTokenPolicyValidator;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.KerberosSecurity;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.stax.securityEvent.KerberosTokenSecurityEvent;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.wss4j.stax.securityToken.KerberosServiceSecurityToken;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.utils.Base64;

public class KerberosTokenInterceptorProvider
extends AbstractPolicyInterceptorProvider {
    private static final long serialVersionUID = 5922028830873137490L;

    public KerberosTokenInterceptorProvider() {
        super(Arrays.asList(SP11Constants.KERBEROS_TOKEN, SP12Constants.KERBEROS_TOKEN));
        this.getOutInterceptors().add(new KerberosTokenOutInterceptor());
        this.getOutFaultInterceptors().add(new KerberosTokenOutInterceptor());
        this.getInInterceptors().add(new KerberosTokenDOMInInterceptor());
        this.getInFaultInterceptors().add(new KerberosTokenDOMInInterceptor());
        this.getInInterceptors().add(new KerberosTokenStaxInInterceptor());
        this.getInFaultInterceptors().add(new KerberosTokenStaxInInterceptor());
        this.getOutInterceptors().add(new KerberosTokenInterceptor());
        this.getInInterceptors().add(new KerberosTokenInterceptor());
        this.getOutInterceptors().add(PolicyBasedWSS4JStaxOutInterceptor.INSTANCE);
        this.getOutFaultInterceptors().add(PolicyBasedWSS4JStaxOutInterceptor.INSTANCE);
        this.getInInterceptors().add(PolicyBasedWSS4JStaxInInterceptor.INSTANCE);
        this.getInFaultInterceptors().add(PolicyBasedWSS4JStaxInInterceptor.INSTANCE);
    }

    static final TokenStore getTokenStore(Message message) {
        return WSS4JUtils.getTokenStore(message);
    }

    private static SecurityToken createSecurityToken(KerberosSecurity binarySecurityToken) {
        SecurityToken token = new SecurityToken(binarySecurityToken.getID());
        token.setToken(binarySecurityToken.getElement());
        token.setTokenType(binarySecurityToken.getValueType());
        byte[] tokenBytes = binarySecurityToken.getToken();
        try {
            token.setSHA1(Base64.encode((byte[])WSSecurityUtil.generateDigest((byte[])tokenBytes)));
        }
        catch (WSSecurityException wSSecurityException) {
            // empty catch block
        }
        return token;
    }

    static class KerberosTokenStaxInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private static final Logger LOG = LogUtils.getL7dLogger(KerberosTokenStaxInInterceptor.class);

        public KerberosTokenStaxInInterceptor() {
            super("pre-protocol");
            this.addAfter(PolicyStaxActionInInterceptor.class.getName());
            this.getBefore().add(StaxSecurityContextInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            block3: {
                AssertionInfoMap aim;
                block5: {
                    Collection<AssertionInfo> ais;
                    block4: {
                        aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
                        boolean enableStax = MessageUtils.isTrue((Object)message.getContextualProperty("ws-security.enable.streaming"));
                        if (aim == null || !enableStax) break block3;
                        ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "KerberosToken");
                        if (ais.isEmpty()) {
                            return;
                        }
                        if (this.isRequestor(message)) break block4;
                        SecurityEvent event = this.findKerberosEvent(message);
                        if (event == null) break block5;
                        for (AssertionInfo ai : ais) {
                            ai.setAsserted(true);
                        }
                        KerberosServiceSecurityToken kerberosToken = (KerberosServiceSecurityToken)((KerberosTokenSecurityEvent)event).getSecurityToken();
                        if (kerberosToken == null) break block5;
                        this.storeKerberosToken(message, kerberosToken);
                        break block5;
                    }
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
                NegotiationUtils.assertPolicy(aim, "WssKerberosV5ApReqToken11");
                NegotiationUtils.assertPolicy(aim, "WssGssKerberosV5ApReqToken11");
            }
        }

        private void storeKerberosToken(Message message, KerberosServiceSecurityToken kerberosToken) {
            SecurityToken token = new SecurityToken(kerberosToken.getId());
            token.setTokenType(kerberosToken.getKerberosTokenValueType());
            SecretKey secretKey = this.getSecretKeyFromToken(kerberosToken);
            token.setKey(secretKey);
            if (secretKey != null) {
                token.setSecret(secretKey.getEncoded());
            }
            byte[] ticket = kerberosToken.getBinaryContent();
            try {
                token.setSHA1(Base64.encode((byte[])WSSecurityUtil.generateDigest((byte[])ticket)));
            }
            catch (WSSecurityException e) {
                // empty catch block
            }
            KerberosTokenInterceptorProvider.getTokenStore(message).add(token);
            message.getExchange().put((Object)"ws-security.token.id", (Object)token.getId());
        }

        private SecurityEvent findKerberosEvent(Message message) {
            List incomingEventList = (List)message.get((Object)(SecurityEvent.class.getName() + ".in"));
            if (incomingEventList != null) {
                for (SecurityEvent incomingEvent : incomingEventList) {
                    if (WSSecurityEventConstants.KerberosToken != incomingEvent.getSecurityEventType()) continue;
                    return incomingEvent;
                }
            }
            return null;
        }

        private SecretKey getSecretKeyFromToken(KerberosServiceSecurityToken kerberosToken) {
            try {
                Map secretKeys = kerberosToken.getSecretKey();
                if (secretKeys != null) {
                    for (String key : kerberosToken.getSecretKey().keySet()) {
                        if (!(secretKeys.get(key) instanceof SecretKey)) continue;
                        return (SecretKey)secretKeys.get(key);
                    }
                }
            }
            catch (XMLSecurityException e) {
                LOG.fine(e.getMessage());
            }
            return null;
        }
    }

    static class KerberosTokenDOMInInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public KerberosTokenDOMInInterceptor() {
            super("pre-protocol");
            this.addAfter(WSS4JInInterceptor.class.getName());
            this.addAfter(PolicyBasedWSS4JInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
            boolean enableStax = MessageUtils.isTrue((Object)message.getContextualProperty("ws-security.enable.streaming"));
            if (aim != null && !enableStax) {
                Collection<AssertionInfo> ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "KerberosToken");
                if (ais.isEmpty()) {
                    return;
                }
                if (!this.isRequestor(message)) {
                    List results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
                    if (results != null && results.size() > 0) {
                        this.parseHandlerResults((WSHandlerResult)results.get(0), message, aim);
                    }
                } else {
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
                NegotiationUtils.assertPolicy(aim, "WssKerberosV5ApReqToken11");
                NegotiationUtils.assertPolicy(aim, "WssGssKerberosV5ApReqToken11");
            }
        }

        private void parseHandlerResults(WSHandlerResult rResult, Message message, AssertionInfoMap aim) {
            List<WSSecurityEngineResult> kerberosResults = this.findKerberosResults(rResult.getResults());
            Iterator<WSSecurityEngineResult> i$ = kerberosResults.iterator();
            while (i$.hasNext()) {
                KerberosTokenPolicyValidator kerberosValidator = new KerberosTokenPolicyValidator(message);
                WSSecurityEngineResult wser = i$.next();
                KerberosSecurity kerberosToken = (KerberosSecurity)wser.get((Object)"binary-security-token");
                boolean valid = kerberosValidator.validatePolicy(aim, kerberosToken);
                if (!valid) continue;
                SecurityToken token = KerberosTokenInterceptorProvider.createSecurityToken(kerberosToken);
                token.setSecret((byte[])wser.get((Object)"secret"));
                KerberosTokenInterceptorProvider.getTokenStore(message).add(token);
                message.getExchange().put((Object)"ws-security.token.id", (Object)token.getId());
                return;
            }
        }

        private List<WSSecurityEngineResult> findKerberosResults(List<WSSecurityEngineResult> wsSecEngineResults) {
            ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
            for (WSSecurityEngineResult wser : wsSecEngineResults) {
                BinarySecurity binarySecurity;
                Integer actInt = (Integer)wser.get((Object)"action");
                if (actInt != 4096 || !((binarySecurity = (BinarySecurity)wser.get((Object)"binary-security-token")) instanceof KerberosSecurity)) continue;
                results.add(wser);
            }
            return results;
        }
    }

    static class KerberosTokenOutInterceptor
    extends AbstractPhaseInterceptor<Message> {
        public KerberosTokenOutInterceptor() {
            super("prepare-send");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) throws Fault {
            block10: {
                AssertionInfoMap aim;
                block12: {
                    Collection<AssertionInfo> ais;
                    block11: {
                        aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
                        if (aim == null) break block10;
                        ais = NegotiationUtils.getAllAssertionsByLocalname(aim, "KerberosToken");
                        if (ais.isEmpty()) {
                            return;
                        }
                        if (!this.isRequestor(message)) break block11;
                        SecurityToken tok = null;
                        try {
                            KerberosClient client;
                            KerberosClient kerberosClient = client = KerberosUtils.getClient(message, "kerberos");
                            synchronized (kerberosClient) {
                                tok = client.requestSecurityToken();
                            }
                        }
                        catch (RuntimeException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new Fault((Throwable)e);
                        }
                        if (tok == null) break block12;
                        for (AssertionInfo ai : ais) {
                            ai.setAsserted(true);
                        }
                        ((Endpoint)message.getExchange().get(Endpoint.class)).put((Object)"ws-security.token.id", (Object)tok.getId());
                        message.getExchange().put((Object)"ws-security.token.id", (Object)tok.getId());
                        KerberosTokenInterceptorProvider.getTokenStore(message).add(tok);
                        if (tok.getSHA1() == null) break block12;
                        KerberosTokenInterceptorProvider.getTokenStore(message).add(tok.getSHA1(), tok);
                        break block12;
                    }
                    for (AssertionInfo ai : ais) {
                        ai.setAsserted(true);
                    }
                }
                NegotiationUtils.assertPolicy(aim, "WssKerberosV5ApReqToken11");
                NegotiationUtils.assertPolicy(aim, "WssGssKerberosV5ApReqToken11");
            }
        }
    }
}

