/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapInterceptor;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.PhaseInterceptor;
import org.apache.cxf.resource.ResourceManager;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.JasyptPasswordEncryptor;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;

public abstract class AbstractWSS4JStaxInterceptor
implements SoapInterceptor,
PhaseInterceptor<SoapMessage> {
    private static final Set<QName> HEADERS = new HashSet<QName>();
    private static final Logger LOG;
    private Map<String, Object> properties = new ConcurrentHashMap<String, Object>();
    private Map<String, Crypto> cryptos = new ConcurrentHashMap<String, Crypto>();
    private WSSSecurityProperties securityProperties;
    private Set<String> before = new HashSet<String>();
    private Set<String> after = new HashSet<String>();
    private String phase;
    private String id = this.getClass().getName();

    public AbstractWSS4JStaxInterceptor() {
    }

    public AbstractWSS4JStaxInterceptor(Map<String, Object> properties) {
        this();
        this.properties.putAll(properties);
    }

    protected void translateProperties(SoapMessage msg) {
        PasswordEncryptor passwordEncryptor;
        String actor;
        String validateSAMLSubjectConf;
        String certConstraints;
        String utTTL;
        String utFutureTTL;
        String ttl;
        String futureTTL;
        String bspCompliant = (String)msg.getContextualProperty("ws-security.is-bsp-compliant");
        if (bspCompliant != null) {
            if (this.securityProperties != null) {
                this.securityProperties.setDisableBSPEnforcement(Boolean.valueOf(bspCompliant).booleanValue());
            } else {
                this.properties.put("isBSPCompliant", bspCompliant);
            }
        }
        if ((futureTTL = (String)msg.getContextualProperty("ws-security.timestamp.futureTimeToLive")) != null) {
            if (this.securityProperties != null) {
                this.securityProperties.setTimeStampFutureTTL(Integer.valueOf(Integer.parseInt(futureTTL)));
            } else {
                this.properties.put("futureTimeToLive", futureTTL);
            }
        }
        if ((ttl = (String)msg.getContextualProperty("ws-security.timestamp.timeToLive")) != null) {
            if (this.securityProperties != null) {
                this.securityProperties.setTimestampTTL(Integer.valueOf(Integer.parseInt(ttl)));
            } else {
                this.properties.put("timeToLive", ttl);
            }
        }
        if ((utFutureTTL = (String)msg.getContextualProperty("ws-security.usernametoken.futureTimeToLive")) != null) {
            if (this.securityProperties != null) {
                this.securityProperties.setUtFutureTTL(Integer.valueOf(Integer.parseInt(utFutureTTL)));
            } else {
                this.properties.put("utFutureTimeToLive", utFutureTTL);
            }
        }
        if ((utTTL = (String)msg.getContextualProperty("ws-security.usernametoken.timeToLive")) != null) {
            if (this.securityProperties != null) {
                this.securityProperties.setUtTTL(Integer.valueOf(Integer.parseInt(utTTL)));
            } else {
                this.properties.put("utTimeToLive", utTTL);
            }
        }
        if ((certConstraints = (String)msg.getContextualProperty("ws-security.subject.cert.constraints")) != null) {
            if (this.securityProperties != null) {
                this.securityProperties.setSubjectCertConstraints(this.convertCertConstraints(certConstraints));
            } else {
                this.properties.put("sigSubjectCertConstraints", certConstraints);
            }
        }
        if ((validateSAMLSubjectConf = (String)msg.getContextualProperty("ws-security.validate.saml.subject.conf")) != null) {
            if (this.securityProperties != null) {
                this.securityProperties.setValidateSamlSubjectConfirmation(Boolean.valueOf(validateSAMLSubjectConf).booleanValue());
            } else {
                this.properties.put("validateSamlSubjectConfirmation", validateSAMLSubjectConf);
            }
        }
        if ((actor = (String)msg.getContextualProperty("ws-security.actor")) != null) {
            if (this.securityProperties != null) {
                this.securityProperties.setActor(actor);
            } else {
                this.properties.put("actor", actor);
            }
        }
        boolean mustUnderstand = MessageUtils.getContextualBoolean((Message)msg, (String)"ws-security.must-understand", (boolean)true);
        if (this.properties != null) {
            this.properties.put("mustUnderstand", Boolean.toString(mustUnderstand));
        }
        if ((passwordEncryptor = (PasswordEncryptor)msg.getContextualProperty("ws-security.password.encryptor.instance")) != null && this.securityProperties == null) {
            this.properties.put("passwordEncyptorInstance", passwordEncryptor);
        }
    }

    private Collection<Pattern> convertCertConstraints(String certConstraints) {
        String[] certConstraintsList = certConstraints.split(",");
        if (certConstraintsList != null) {
            ArrayList<Pattern> subjectCertConstraints = new ArrayList<Pattern>(certConstraintsList.length);
            for (String certConstraint : certConstraintsList) {
                try {
                    subjectCertConstraints.add(Pattern.compile(certConstraint.trim()));
                }
                catch (PatternSyntaxException ex) {
                    LOG.log(Level.SEVERE, ex.getMessage(), ex);
                }
            }
            return subjectCertConstraints;
        }
        return null;
    }

    protected void configureCallbackHandler(SoapMessage soapMessage) throws WSSecurityException {
        Object o = soapMessage.getContextualProperty("ws-security.callback-handler");
        if (o instanceof String) {
            try {
                o = ClassLoaderUtils.loadClass((String)((String)o), this.getClass()).newInstance();
            }
            catch (Exception e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e);
            }
        }
        if (o == null && this.getPassword(soapMessage) != null) {
            final String password = this.getPassword(soapMessage);
            o = new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (!(callback instanceof WSPasswordCallback)) continue;
                        WSPasswordCallback wsPasswordCallback = (WSPasswordCallback)callback;
                        wsPasswordCallback.setPassword(password);
                    }
                }
            };
        }
        if (o instanceof CallbackHandler) {
            Map<String, Object> config = this.getProperties();
            if (this.securityProperties != null) {
                this.securityProperties.setCallbackHandler((CallbackHandler)o);
            } else {
                config.put("passwordCallbackRef", (CallbackHandler)o);
            }
        }
    }

    public Set<URI> getRoles() {
        return null;
    }

    public void handleFault(SoapMessage message) {
    }

    public void postHandleMessage(SoapMessage message) throws Fault {
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return null;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }

    public Object getOption(String key) {
        return this.properties.get(key);
    }

    public void setProperty(String key, String value) {
        this.properties.put(key, value);
    }

    public String getPassword(Object msgContext) {
        return (String)((Message)msgContext).getContextualProperty("password");
    }

    public Object getProperty(Object msgContext, String key) {
        Object obj = ((Message)msgContext).getContextualProperty(key);
        if (obj == null) {
            obj = this.getOption(key);
        }
        return obj;
    }

    public void setPassword(Object msgContext, String password) {
        ((Message)msgContext).put((Object)"password", (Object)password);
    }

    public void setProperty(Object msgContext, String key, Object value) {
        ((Message)msgContext).put((Object)key, value);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Set<QName> getUnderstoodHeaders() {
        return HEADERS;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public Set<String> getAfter() {
        return this.after;
    }

    public void setAfter(Set<String> after) {
        this.after = after;
    }

    public Set<String> getBefore() {
        return this.before;
    }

    public void setBefore(Set<String> before) {
        this.before = before;
    }

    protected boolean isRequestor(SoapMessage message) {
        return MessageUtils.isRequestor((Message)message);
    }

    public WSSSecurityProperties getSecurityProperties() {
        return this.securityProperties;
    }

    public void setSecurityProperties(WSSSecurityProperties securityProperties) {
        this.securityProperties = securityProperties;
    }

    protected Crypto loadCrypto(SoapMessage soapMessage, String cryptoPropertyFile, String cryptoPropertyRefId) throws WSSecurityException {
        String propFile;
        Crypto crypto = null;
        String refId = (String)this.getProperty(soapMessage, cryptoPropertyRefId);
        if (refId != null) {
            crypto = this.cryptos.get(refId);
            if (crypto == null) {
                Object obj = this.getProperty(soapMessage, refId);
                if (obj instanceof Properties) {
                    crypto = CryptoFactory.getInstance((Properties)((Properties)obj), (ClassLoader)this.getClassLoader(), (PasswordEncryptor)this.getPasswordEncryptor(soapMessage));
                    this.cryptos.put(refId, crypto);
                } else if (obj instanceof Crypto) {
                    crypto = (Crypto)obj;
                    this.cryptos.put(refId, crypto);
                }
            }
            if (crypto == null) {
                LOG.info("The Crypto reference " + refId + " specified by " + cryptoPropertyRefId + " could not be loaded");
            }
        }
        if (crypto == null && (propFile = (String)this.getProperty(soapMessage, cryptoPropertyFile)) != null) {
            crypto = this.cryptos.get(propFile);
            if (crypto == null) {
                crypto = this.loadCryptoFromPropertiesFile(soapMessage, propFile);
                this.cryptos.put(propFile, crypto);
            }
            if (crypto == null) {
                LOG.info("The Crypto properties file " + propFile + " specified by " + cryptoPropertyFile + " could not be loaded or found");
            }
        }
        return crypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Crypto loadCryptoFromPropertiesFile(SoapMessage soapMessage, String propFilename) throws WSSecurityException {
        Crypto crypto;
        ClassLoaderUtils.ClassLoaderHolder orig = null;
        try {
            URL url = ClassLoaderUtils.getResource((String)propFilename, this.getClass());
            if (url == null) {
                ResourceManager manager = (ResourceManager)soapMessage.getExchange().getBus().getExtension(ResourceManager.class);
                ClassLoader loader = (ClassLoader)manager.resolveResource("", ClassLoader.class);
                if (loader != null) {
                    orig = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)loader);
                }
                url = (URL)manager.resolveResource(propFilename, URL.class);
            }
            if (url == null) return CryptoFactory.getInstance((String)propFilename, (ClassLoader)this.getClassLoader());
            Properties props = new Properties();
            InputStream in = url.openStream();
            props.load(in);
            in.close();
            crypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)this.getClassLoader(), (PasswordEncryptor)this.getPasswordEncryptor(soapMessage));
            if (orig == null) return crypto;
        }
        catch (Exception e) {
            // empty catch block
            return CryptoFactory.getInstance((String)propFilename, (ClassLoader)this.getClassLoader());
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        orig.reset();
        return crypto;
    }

    protected PasswordEncryptor getPasswordEncryptor(SoapMessage soapMessage) {
        PasswordEncryptor passwordEncryptor = (PasswordEncryptor)soapMessage.getContextualProperty("ws-security.password.encryptor.instance");
        if (passwordEncryptor != null) {
            return passwordEncryptor;
        }
        CallbackHandler callbackHandler = null;
        callbackHandler = this.securityProperties != null ? this.securityProperties.getCallbackHandler() : (CallbackHandler)this.getProperties().get("passwordCallbackRef");
        if (callbackHandler != null) {
            return new JasyptPasswordEncryptor(callbackHandler);
        }
        return null;
    }

    private ClassLoader getClassLoader() {
        try {
            return Loader.getTCL();
        }
        catch (Exception ex) {
            return null;
        }
    }

    static {
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"));
        HEADERS.add(new QName("http://docs.oasis-open.org/wss/oasis-wss-wssecurity-secext-1.1.xsd", "Security"));
        HEADERS.add(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"));
        LOG = LogUtils.getL7dLogger(AbstractWSS4JStaxInterceptor.class);
    }
}

