/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JStaxInterceptor;
import org.apache.cxf.ws.security.wss4j.StaxActionInInterceptor;
import org.apache.cxf.ws.security.wss4j.StaxSecurityContextInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.cxf.wsdl.interceptors.URIMappingInterceptor;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.policy.WSSPolicyException;
import org.apache.wss4j.stax.ConfigurationConverter;
import org.apache.wss4j.stax.WSSec;
import org.apache.wss4j.stax.ext.InboundWSSec;
import org.apache.wss4j.stax.ext.WSSConstants;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.validate.Validator;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.XMLSecurityConstants;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;

public class WSS4JStaxInInterceptor
extends AbstractWSS4JStaxInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JStaxInInterceptor.class);
    private List<String> actions;

    public WSS4JStaxInInterceptor(WSSSecurityProperties securityProperties) {
        this.setPhase("post-stream");
        this.getAfter().add(StaxInInterceptor.class.getName());
        this.setSecurityProperties(securityProperties);
    }

    public WSS4JStaxInInterceptor(Map<String, Object> props) {
        super(props);
        Object actionObject;
        this.setPhase("post-stream");
        this.getAfter().add(StaxInInterceptor.class.getName());
        if (props != null && props.containsKey("action") && (actionObject = props.get("action")) instanceof String) {
            String[] actionArray = ((String)actionObject).split(" ");
            this.actions = Arrays.asList(actionArray);
        }
    }

    public final boolean isGET(SoapMessage message) {
        boolean isGet;
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        boolean bl = isGet = "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
        if (isGet) {
            message.put(URIMappingInterceptor.URIMAPPING_SKIP, (Object)Boolean.TRUE);
        }
        return isGet;
    }

    public void handleMessage(SoapMessage soapMessage) throws Fault {
        if (this.isGET(soapMessage)) {
            return;
        }
        XMLStreamReader originalXmlStreamReader = (XMLStreamReader)soapMessage.getContent(XMLStreamReader.class);
        soapMessage.getInterceptorChain().add((Interceptor)new StaxSecurityContextInInterceptor());
        if (this.actions != null && !this.actions.isEmpty()) {
            soapMessage.getInterceptorChain().add((Interceptor)new StaxActionInInterceptor(this.actions));
        }
        try {
            List requestSecurityEvents = (List)soapMessage.getExchange().get((Object)(SecurityEvent.class.getName() + ".out"));
            this.translateProperties(soapMessage);
            this.configureCallbackHandler(soapMessage);
            this.configureProperties(soapMessage);
            InboundWSSec inboundWSSec = null;
            WSSSecurityProperties secProps = null;
            secProps = this.getSecurityProperties() != null ? this.getSecurityProperties() : ConfigurationConverter.convert(this.getProperties());
            TokenStoreCallbackHandler callbackHandler = new TokenStoreCallbackHandler(secProps.getCallbackHandler(), WSS4JUtils.getTokenStore((Message)soapMessage));
            secProps.setCallbackHandler((CallbackHandler)callbackHandler);
            this.setTokenValidators(secProps, soapMessage);
            List<SecurityEventListener> securityEventListeners = this.configureSecurityEventListeners(soapMessage, secProps);
            inboundWSSec = WSSec.getInboundWSSec((WSSSecurityProperties)secProps);
            XMLStreamReader newXmlStreamReader = inboundWSSec.processInMessage(originalXmlStreamReader, requestSecurityEvents, securityEventListeners);
            soapMessage.setContent(XMLStreamReader.class, (Object)newXmlStreamReader);
        }
        catch (WSSecurityException e) {
            throw this.createSoapFault(soapMessage.getVersion(), e);
        }
        catch (XMLSecurityException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("STAX_EX", LOG, new Object[0]), (Throwable)e, soapMessage.getVersion().getSender());
        }
        catch (WSSPolicyException e) {
            throw new SoapFault(e.getMessage(), (Throwable)e, soapMessage.getVersion().getSender());
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("STAX_EX", LOG, new Object[0]), (Throwable)e, soapMessage.getVersion().getSender());
        }
    }

    protected List<SecurityEventListener> configureSecurityEventListeners(SoapMessage msg, WSSSecurityProperties securityProperties) throws WSSPolicyException {
        final LinkedList incomingSecurityEventList = new LinkedList();
        SecurityEventListener securityEventListener = new SecurityEventListener(){

            public void registerSecurityEvent(SecurityEvent securityEvent) throws WSSecurityException {
                incomingSecurityEventList.add(securityEvent);
            }
        };
        msg.getExchange().put((Object)(SecurityEvent.class.getName() + ".in"), incomingSecurityEventList);
        msg.put(SecurityEvent.class.getName() + ".in", incomingSecurityEventList);
        return Collections.singletonList(securityEventListener);
    }

    protected void configureProperties(SoapMessage msg) throws XMLSecurityException {
        WSSSecurityProperties securityProperties = this.getSecurityProperties();
        Map<String, Object> config = this.getProperties();
        ReplayCache nonceCache = null;
        if (this.isNonceCacheRequired(msg)) {
            nonceCache = WSS4JUtils.getReplayCache(msg, "ws-security.enable.nonce.cache", "ws-security.nonce.cache.instance");
        }
        if (nonceCache == null) {
            if (config != null) {
                config.put("enableNonceCache", "false");
                config.remove("nonceCacheInstance");
            } else {
                securityProperties.setEnableNonceReplayCache(false);
                securityProperties.setNonceReplayCache(null);
            }
        } else if (config != null) {
            config.put("enableNonceCache", "true");
            config.put("nonceCacheInstance", nonceCache);
        } else {
            securityProperties.setEnableNonceReplayCache(true);
            securityProperties.setNonceReplayCache(nonceCache);
        }
        ReplayCache timestampCache = null;
        if (this.isTimestampCacheRequired(msg)) {
            timestampCache = WSS4JUtils.getReplayCache(msg, "ws-security.enable.timestamp.cache", "ws-security.timestamp.cache.instance");
        }
        if (timestampCache == null) {
            if (config != null) {
                config.put("ws-security.enable.timestamp.cache", "false");
                config.remove("timestampCacheInstance");
            } else {
                securityProperties.setEnableTimestampReplayCache(false);
                securityProperties.setTimestampReplayCache(null);
            }
        } else if (config != null) {
            config.put("ws-security.enable.timestamp.cache", "true");
            config.put("timestampCacheInstance", timestampCache);
        } else {
            securityProperties.setEnableTimestampReplayCache(true);
            securityProperties.setTimestampReplayCache(timestampCache);
        }
        ReplayCache samlCache = null;
        if (this.isSamlCacheRequired(msg)) {
            samlCache = WSS4JUtils.getReplayCache(msg, "ws-security.enable.saml.cache", "ws-security.saml.cache.instance");
        }
        if (samlCache == null) {
            if (config != null) {
                config.put("enableSamlOneTimeUseCache", "false");
                config.remove("samlOneTimeUseCacheInstance");
            } else {
                securityProperties.setEnableSamlOneTimeUseReplayCache(false);
                securityProperties.setSamlOneTimeUseReplayCache(null);
            }
        } else if (config != null) {
            config.put("enableSamlOneTimeUseCache", "true");
            config.put("samlOneTimeUseCacheInstance", samlCache);
        } else {
            securityProperties.setEnableSamlOneTimeUseReplayCache(true);
            securityProperties.setSamlOneTimeUseReplayCache(samlCache);
        }
        boolean enableRevocation = MessageUtils.isTrue((Object)msg.getContextualProperty("ws-security.enableRevocation"));
        if (securityProperties != null) {
            securityProperties.setEnableRevocation(enableRevocation);
        } else {
            config.put("enableRevocation", Boolean.toString(enableRevocation));
        }
        if (config != null) {
            Crypto decCrypto;
            Crypto sigVerCrypto = this.loadCrypto(msg, "signatureVerificationPropFile", "signatureVerificationPropRefId");
            if (sigVerCrypto == null) {
                sigVerCrypto = this.loadCrypto(msg, "signaturePropFile", "signaturePropRefId");
            }
            if (sigVerCrypto != null) {
                config.put("signatureVerificationPropRefId", "RefId-" + sigVerCrypto.hashCode());
                config.put("RefId-" + sigVerCrypto.hashCode(), sigVerCrypto);
            }
            if ((decCrypto = this.loadCrypto(msg, "decryptionPropFile", "decryptionPropRefId")) != null) {
                config.put("decryptionPropRefId", "RefId-" + decCrypto.hashCode());
                config.put("RefId-" + decCrypto.hashCode(), decCrypto);
            }
        }
    }

    protected boolean isNonceCacheRequired(SoapMessage msg) {
        WSSSecurityProperties securityProperties = this.getSecurityProperties();
        if (securityProperties != null && securityProperties.getOutAction() != null) {
            for (XMLSecurityConstants.Action action : securityProperties.getOutAction()) {
                if (action != WSSConstants.USERNAMETOKEN) continue;
                return true;
            }
        } else if (this.actions != null && (this.actions.contains("UsernameToken") || this.actions.contains("UsernameTokenNoPassword"))) {
            return true;
        }
        return false;
    }

    protected boolean isTimestampCacheRequired(SoapMessage msg) {
        WSSSecurityProperties securityProperties = this.getSecurityProperties();
        if (securityProperties != null && securityProperties.getOutAction() != null) {
            for (XMLSecurityConstants.Action action : securityProperties.getOutAction()) {
                if (action != WSSConstants.TIMESTAMP) continue;
                return true;
            }
        } else if (this.actions != null && this.actions.contains("Timestamp")) {
            return true;
        }
        return false;
    }

    protected boolean isSamlCacheRequired(SoapMessage msg) {
        WSSSecurityProperties securityProperties = this.getSecurityProperties();
        if (securityProperties != null && securityProperties.getOutAction() != null) {
            for (XMLSecurityConstants.Action action : securityProperties.getOutAction()) {
                if (action != WSSConstants.SAML_TOKEN_UNSIGNED && action != WSSConstants.SAML_TOKEN_SIGNED) continue;
                return true;
            }
        } else if (this.actions != null && (this.actions.contains("SAMLTokenUnsigned") || this.actions.contains("SAMLTokenSigned"))) {
            return true;
        }
        return false;
    }

    private SoapFault createSoapFault(SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(e.getMessage(), (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(e.getMessage(), (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }

    private void setTokenValidators(WSSSecurityProperties properties, SoapMessage message) throws WSSecurityException {
        Validator validator = this.loadValidator("ws-security.saml1.validator", message);
        if (validator != null) {
            properties.addValidator(WSSConstants.TAG_saml_Assertion, validator);
        }
        if ((validator = this.loadValidator("ws-security.saml2.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_saml2_Assertion, validator);
        }
        if ((validator = this.loadValidator("ws-security.ut.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_wsse_UsernameToken, validator);
        }
        if ((validator = this.loadValidator("ws-security.signature.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_dsig_Signature, validator);
        }
        if ((validator = this.loadValidator("ws-security.timestamp.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_wsu_Timestamp, validator);
        }
        if ((validator = this.loadValidator("ws-security.bst.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_wsse_BinarySecurityToken, validator);
        }
        if ((validator = this.loadValidator("ws-security.sct.validator", message)) != null) {
            properties.addValidator(WSSConstants.TAG_wsc0502_SecurityContextToken, validator);
            properties.addValidator(WSSConstants.TAG_wsc0512_SecurityContextToken, validator);
        }
    }

    private Validator loadValidator(String validatorKey, SoapMessage message) throws WSSecurityException {
        Object o = message.getContextualProperty(validatorKey);
        try {
            if (o instanceof Validator) {
                return (Validator)o;
            }
            if (o instanceof Class) {
                return (Validator)((Class)o).newInstance();
            }
            if (o instanceof String) {
                return (Validator)ClassLoaderUtils.loadClass((String)o.toString(), WSS4JInInterceptor.class).newInstance();
            }
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
        }
        return null;
    }

    public List<String> getActions() {
        return this.actions;
    }

    public void setActions(List<String> actions) {
        this.actions = actions;
    }

    private class TokenStoreCallbackHandler
    implements CallbackHandler {
        private CallbackHandler internal;
        private TokenStore store;

        public TokenStoreCallbackHandler(CallbackHandler in, TokenStore st) {
            this.internal = in;
            this.store = st;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pc;
                String id;
                SecurityToken tok;
                if (!(callbacks[i] instanceof WSPasswordCallback) || (tok = this.store.getToken(id = (pc = (WSPasswordCallback)callbacks[i]).getIdentifier())) == null) continue;
                pc.setKey(tok.getSecret());
                pc.setKey(tok.getKey());
                pc.setCustomToken(tok.getToken());
                return;
            }
            if (this.internal != null) {
                this.internal.handle(callbacks);
            }
        }
    }
}

