/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyhandlers;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.soap.SOAPException;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.cxf.ws.security.wss4j.policyhandlers.AbstractStaxBindingHandler;
import org.apache.neethi.Assertion;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.AbstractBinding;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.AbstractTokenWrapper;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.model.Header;
import org.apache.wss4j.policy.model.IssuedToken;
import org.apache.wss4j.policy.model.KerberosToken;
import org.apache.wss4j.policy.model.KeyValueToken;
import org.apache.wss4j.policy.model.SamlToken;
import org.apache.wss4j.policy.model.SecureConversationToken;
import org.apache.wss4j.policy.model.SecurityContextToken;
import org.apache.wss4j.policy.model.SignedElements;
import org.apache.wss4j.policy.model.SignedParts;
import org.apache.wss4j.policy.model.SpnegoContextToken;
import org.apache.wss4j.policy.model.SupportingTokens;
import org.apache.wss4j.policy.model.TransportBinding;
import org.apache.wss4j.policy.model.TransportToken;
import org.apache.wss4j.policy.model.UsernameToken;
import org.apache.wss4j.policy.model.X509Token;
import org.apache.wss4j.policy.model.XPath;
import org.apache.wss4j.policy.stax.PolicyUtils;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class StaxTransportBindingHandler
extends AbstractStaxBindingHandler {
    private static final Logger LOG = LogUtils.getL7dLogger(StaxTransportBindingHandler.class);
    private TransportBinding tbinding;

    public StaxTransportBindingHandler(Map<String, Object> properties, SoapMessage msg, TransportBinding tbinding, Map<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens) {
        super(properties, msg, (AbstractBinding)tbinding, outboundTokens);
        this.tbinding = tbinding;
    }

    public void handleBinding() {
        AssertionInfoMap aim = (AssertionInfoMap)this.getMessage().get(AssertionInfoMap.class);
        this.configureTimestamp(aim);
        if (this.isRequestor()) {
            if (this.tbinding != null) {
                TransportToken token;
                this.assertPolicy(this.tbinding.getName());
                String asymSignatureAlgorithm = (String)this.getMessage().getContextualProperty("ws-security.asymmetric.signature.algorithm");
                if (asymSignatureAlgorithm != null && this.tbinding.getAlgorithmSuite() != null) {
                    this.tbinding.getAlgorithmSuite().setAsymmetricSignature(asymSignatureAlgorithm);
                }
                if ((token = this.tbinding.getTransportToken()).getToken() instanceof IssuedToken) {
                    SecurityToken secToken = this.getSecurityToken();
                    if (secToken == null) {
                        this.policyNotAsserted((Assertion)token.getToken(), "No transport token id");
                        return;
                    }
                    this.addIssuedToken((AbstractToken)((IssuedToken)token.getToken()), secToken, false, false);
                }
                this.assertToken(token.getToken());
                this.assertTokenWrapper((AbstractTokenWrapper)token);
            }
            try {
                this.handleNonEndorsingSupportingTokens(aim);
                this.handleEndorsingSupportingTokens(aim);
            }
            catch (Exception e) {
                LOG.log(Level.FINE, e.getMessage(), e);
                throw new Fault((Throwable)e);
            }
        } else {
            if (this.tbinding != null && this.tbinding.getTransportToken() != null) {
                this.assertTokenWrapper((AbstractTokenWrapper)this.tbinding.getTransportToken());
                this.assertToken(this.tbinding.getTransportToken().getToken());
            }
            this.addSignatureConfirmation(null);
        }
        this.configureLayout(aim);
        if (this.tbinding != null) {
            this.assertAlgorithmSuite(this.tbinding.getAlgorithmSuite());
            this.assertWSSProperties(this.tbinding.getName().getNamespaceURI());
            this.assertTrustProperties(this.tbinding.getName().getNamespaceURI());
        }
        this.assertPolicy(SP12Constants.SIGNED_PARTS);
        this.assertPolicy(SP11Constants.SIGNED_PARTS);
        this.assertPolicy(SP12Constants.ENCRYPTED_PARTS);
        this.assertPolicy(SP11Constants.ENCRYPTED_PARTS);
    }

    private void handleNonEndorsingSupportingTokens(AssertionInfoMap aim) throws Exception {
        SupportingTokens sgndSuppTokens;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SignedSupportingTokens");
        if (!ais.isEmpty()) {
            for (AssertionInfo ai : ais) {
                sgndSuppTokens = (SupportingTokens)ai.getAssertion();
                if (sgndSuppTokens != null) {
                    this.addSignedSupportingTokens(sgndSuppTokens);
                }
                ai.setAsserted(true);
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "SignedEncryptedSupportingTokens")).isEmpty()) {
            for (AssertionInfo ai : ais) {
                sgndSuppTokens = (SupportingTokens)ai.getAssertion();
                if (sgndSuppTokens != null) {
                    this.addSignedSupportingTokens(sgndSuppTokens);
                }
                ai.setAsserted(true);
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "EncryptedSupportingTokens")).isEmpty()) {
            for (AssertionInfo ai : ais) {
                SupportingTokens encrSuppTokens = (SupportingTokens)ai.getAssertion();
                if (encrSuppTokens != null) {
                    this.addSignedSupportingTokens(encrSuppTokens);
                }
                ai.setAsserted(true);
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "SupportingTokens")).isEmpty()) {
            for (AssertionInfo ai : ais) {
                SupportingTokens suppTokens = (SupportingTokens)ai.getAssertion();
                if (suppTokens != null && suppTokens.getTokens() != null && suppTokens.getTokens().size() > 0) {
                    this.handleSupportingTokens(suppTokens, false, false);
                }
                ai.setAsserted(true);
            }
        }
    }

    private void addSignedSupportingTokens(SupportingTokens sgndSuppTokens) throws Exception {
        for (AbstractToken token : sgndSuppTokens.getTokens()) {
            if (token instanceof UsernameToken) {
                this.addUsernameToken((UsernameToken)token);
                continue;
            }
            if (token instanceof IssuedToken) {
                this.addIssuedToken((AbstractToken)((IssuedToken)token), this.getSecurityToken(), false, false);
                continue;
            }
            if (token instanceof KerberosToken) {
                this.addKerberosToken((KerberosToken)token, false, false, false);
                continue;
            }
            if (token instanceof SamlToken) {
                this.addSamlToken((SamlToken)token, false, false);
                continue;
            }
            throw new Exception(token.getName() + " is not supported in the streaming code");
        }
    }

    private void handleEndorsingSupportingTokens(AssertionInfoMap aim) throws Exception {
        SupportingTokens endSuppTokens;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SignedEndorsingSupportingTokens");
        if (!ais.isEmpty()) {
            SupportingTokens sgndSuppTokens = null;
            for (AssertionInfo ai : ais) {
                sgndSuppTokens = (SupportingTokens)ai.getAssertion();
                ai.setAsserted(true);
            }
            if (sgndSuppTokens != null) {
                for (AbstractToken token : sgndSuppTokens.getTokens()) {
                    this.handleEndorsingToken(token, sgndSuppTokens);
                }
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "EndorsingSupportingTokens")).isEmpty()) {
            endSuppTokens = null;
            for (AssertionInfo ai : ais) {
                endSuppTokens = (SupportingTokens)ai.getAssertion();
                ai.setAsserted(true);
            }
            if (endSuppTokens != null) {
                for (AbstractToken token : endSuppTokens.getTokens()) {
                    this.handleEndorsingToken(token, endSuppTokens);
                }
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "EndorsingEncryptedSupportingTokens")).isEmpty()) {
            endSuppTokens = null;
            for (AssertionInfo ai : ais) {
                endSuppTokens = (SupportingTokens)ai.getAssertion();
                ai.setAsserted(true);
            }
            if (endSuppTokens != null) {
                for (AbstractToken token : endSuppTokens.getTokens()) {
                    this.handleEndorsingToken(token, endSuppTokens);
                }
            }
        }
        if (!(ais = this.getAllAssertionsByLocalname(aim, "SignedEndorsingEncryptedSupportingTokens")).isEmpty()) {
            endSuppTokens = null;
            for (AssertionInfo ai : ais) {
                endSuppTokens = (SupportingTokens)ai.getAssertion();
                ai.setAsserted(true);
            }
            if (endSuppTokens != null) {
                for (AbstractToken token : endSuppTokens.getTokens()) {
                    this.handleEndorsingToken(token, endSuppTokens);
                }
            }
        }
    }

    private void handleEndorsingToken(AbstractToken token, SupportingTokens wrapper) throws Exception {
        if (token instanceof IssuedToken) {
            SecurityToken securityToken = this.getSecurityToken();
            this.addIssuedToken(token, securityToken, false, true);
            this.signPartsAndElements(wrapper.getSignedParts(), wrapper.getSignedElements());
        } else if (token instanceof SecureConversationToken || token instanceof SecurityContextToken || token instanceof SpnegoContextToken) {
            SecurityToken securityToken = this.getSecurityToken();
            this.addIssuedToken(token, securityToken, false, true);
            Map<String, Object> config = this.getProperties();
            if (securityToken != null) {
                this.storeSecurityToken(securityToken);
                AbstractStaxBindingHandler.TokenStoreCallbackHandler callbackHandler = new AbstractStaxBindingHandler.TokenStoreCallbackHandler((CallbackHandler)config.get("passwordCallbackRef"), WSS4JUtils.getTokenStore((Message)this.message));
                config.put("passwordCallbackRef", callbackHandler);
            }
            this.doSignature(token, wrapper);
            config.put("includeSignatureToken", "true");
            config.put("signatureAlgorithm", this.tbinding.getAlgorithmSuite().getSymmetricSignature());
            AlgorithmSuite.AlgorithmSuiteType algType = this.tbinding.getAlgorithmSuite().getAlgorithmSuiteType();
            config.put("signatureDigestAlgorithm", algType.getDigest());
        } else if (token instanceof X509Token || token instanceof KeyValueToken) {
            this.doSignature(token, wrapper);
        } else if (token instanceof SamlToken) {
            this.addSamlToken((SamlToken)token, false, true);
            this.signPartsAndElements(wrapper.getSignedParts(), wrapper.getSignedElements());
            Map<String, Object> config = this.getProperties();
            config.put("signatureAlgorithm", this.tbinding.getAlgorithmSuite().getAsymmetricSignature());
            AlgorithmSuite.AlgorithmSuiteType algType = this.tbinding.getAlgorithmSuite().getAlgorithmSuiteType();
            config.put("signatureDigestAlgorithm", algType.getDigest());
        } else {
            if (token instanceof UsernameToken) {
                throw new Exception("Endorsing UsernameTokens are not supported in the streaming code");
            }
            if (token instanceof KerberosToken) {
                Map<String, Object> config = this.getProperties();
                String signatureAction = "Signature";
                if (config.containsKey("action")) {
                    String action = (String)config.get("action");
                    config.put("action", action + " " + signatureAction);
                } else {
                    config.put("action", signatureAction);
                }
                this.configureSignature((AbstractTokenWrapper)wrapper, token, false);
                this.addKerberosToken((KerberosToken)token, false, true, false);
                this.signPartsAndElements(wrapper.getSignedParts(), wrapper.getSignedElements());
                config.put("signatureAlgorithm", this.tbinding.getAlgorithmSuite().getSymmetricSignature());
                AlgorithmSuite.AlgorithmSuiteType algType = this.tbinding.getAlgorithmSuite().getAlgorithmSuiteType();
                config.put("signatureDigestAlgorithm", algType.getDigest());
            }
        }
    }

    private void doSignature(AbstractToken token, SupportingTokens wrapper) throws Exception {
        this.signPartsAndElements(wrapper.getSignedParts(), wrapper.getSignedElements());
        Map<String, Object> config = this.getProperties();
        String actionToPerform = "Signature";
        if (token.getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
            actionToPerform = "SignatureDerived";
        }
        if (config.containsKey("action")) {
            String action = (String)config.get("action");
            config.put("action", action + " " + actionToPerform);
        } else {
            config.put("action", actionToPerform);
        }
        this.configureSignature((AbstractTokenWrapper)wrapper, token, false);
        if (token.getDerivedKeys() == AbstractToken.DerivedKeys.RequireDerivedKeys) {
            config.put("signatureAlgorithm", this.tbinding.getAlgorithmSuite().getSymmetricSignature());
        }
    }

    private void signPartsAndElements(SignedParts signedParts, SignedElements signedElements) throws SOAPException {
        Map<String, Object> properties = this.getProperties();
        String parts = "";
        if (properties.containsKey("signatureParts") && !(parts = (String)properties.get("signatureParts")).endsWith(";")) {
            parts = parts + ";";
        }
        String optionalParts = "";
        if (properties.containsKey("optionalSignatureParts") && !(optionalParts = (String)properties.get("optionalSignatureParts")).endsWith(";")) {
            optionalParts = optionalParts + ";";
        }
        if (this.timestampAdded) {
            parts = parts + "{Element}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp;";
        }
        if (signedParts != null) {
            if (signedParts.isBody()) {
                parts = parts + "{Element}{http://schemas.xmlsoap.org/soap/envelope/}Body;";
            }
            for (Header head : signedParts.getHeaders()) {
                optionalParts = optionalParts + "{Element}{" + head.getNamespace() + "}" + head.getName() + ";";
            }
        }
        if (signedElements != null && signedElements.getXPaths() != null) {
            for (XPath xPath : signedElements.getXPaths()) {
                List qnames = PolicyUtils.getElementPath((XPath)xPath);
                if (qnames.isEmpty()) continue;
                parts = parts + "{Element}" + qnames.get(qnames.size() - 1) + ";";
            }
        }
        properties.put("signatureParts", parts);
        properties.put("optionalSignatureParts", optionalParts);
    }
}

