/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractBindingPolicyValidator;
import org.apache.neethi.Assertion;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.policy.model.AbstractSymmetricAsymmetricBinding;
import org.apache.wss4j.policy.model.AbstractTokenWrapper;
import org.apache.wss4j.policy.model.SymmetricBinding;
import org.w3c.dom.Element;

public class SymmetricBindingPolicyValidator
extends AbstractBindingPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SymmetricBinding");
        if (!ais.isEmpty()) {
            this.parsePolicies(aim, ais, message, soapBody, results, signedResults, encryptedResults);
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        boolean hasDerivedKeys = false;
        for (WSSecurityEngineResult result : results) {
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt != 2048) continue;
            hasDerivedKeys = true;
            break;
        }
        for (AssertionInfo ai : ais) {
            SymmetricBinding binding = (SymmetricBinding)ai.getAssertion();
            ai.setAsserted(true);
            if (this.checkProtectionOrder((AbstractSymmetricAsymmetricBinding)binding, aim, ai, results) && this.checkProperties((AbstractSymmetricAsymmetricBinding)binding, ai, aim, results, signedResults, message) && this.checkTokens(binding, ai, aim, hasDerivedKeys, signedResults, encryptedResults)) continue;
        }
    }

    private boolean checkTokens(SymmetricBinding binding, AssertionInfo ai, AssertionInfoMap aim, boolean hasDerivedKeys, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        if (binding.getEncryptionToken() != null) {
            this.assertPolicy(aim, (Assertion)binding.getEncryptionToken());
            if (!this.checkDerivedKeys((AbstractTokenWrapper)binding.getEncryptionToken(), hasDerivedKeys, signedResults, encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
            this.assertPolicy(aim, "RequireDerivedKeys");
            this.assertPolicy(aim, "RequireImpliedDerivedKeys");
            this.assertPolicy(aim, "RequireExplicitDerivedKeys");
        }
        if (binding.getSignatureToken() != null) {
            this.assertPolicy(aim, (Assertion)binding.getSignatureToken());
            if (!this.checkDerivedKeys((AbstractTokenWrapper)binding.getSignatureToken(), hasDerivedKeys, signedResults, encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
            this.assertPolicy(aim, "RequireDerivedKeys");
            this.assertPolicy(aim, "RequireImpliedDerivedKeys");
            this.assertPolicy(aim, "RequireExplicitDerivedKeys");
        }
        if (binding.getProtectionToken() != null) {
            this.assertPolicy(aim, (Assertion)binding.getProtectionToken());
            if (!this.checkDerivedKeys((AbstractTokenWrapper)binding.getProtectionToken(), hasDerivedKeys, signedResults, encryptedResults)) {
                ai.setNotAsserted("Message fails the DerivedKeys requirement");
                return false;
            }
            this.assertPolicy(aim, "RequireDerivedKeys");
            this.assertPolicy(aim, "RequireImpliedDerivedKeys");
            this.assertPolicy(aim, "RequireExplicitDerivedKeys");
        }
        return true;
    }
}

