/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractBindingPolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AlgorithmSuitePolicyValidator;
import org.apache.cxf.ws.security.wss4j.policyvalidators.LayoutPolicyValidator;
import org.apache.neethi.Assertion;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.Layout;
import org.apache.wss4j.policy.model.TransportBinding;
import org.w3c.dom.Element;

public class TransportBindingPolicyValidator
extends AbstractBindingPolicyValidator {
    @Override
    public boolean validatePolicy(AssertionInfoMap aim, Message message, Element soapBody, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults, List<WSSecurityEngineResult> encryptedResults) {
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "TransportBinding");
        if (!ais.isEmpty()) {
            this.parsePolicies(aim, ais, message, results, signedResults);
            this.assertPolicy(aim, SP12Constants.ENCRYPTED_PARTS);
            this.assertPolicy(aim, SP11Constants.ENCRYPTED_PARTS);
            this.assertPolicy(aim, SP12Constants.SIGNED_PARTS);
            this.assertPolicy(aim, SP11Constants.SIGNED_PARTS);
        }
        return true;
    }

    private void parsePolicies(AssertionInfoMap aim, Collection<AssertionInfo> ais, Message message, List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        for (AssertionInfo ai : ais) {
            AlgorithmSuitePolicyValidator algorithmValidator;
            TransportBinding binding = (TransportBinding)ai.getAssertion();
            ai.setAsserted(true);
            boolean initiator = MessageUtils.isRequestor((Message)message);
            TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
            if (!initiator && tlsInfo == null) {
                ai.setNotAsserted("TLS is not enabled");
                continue;
            }
            if (binding.getTransportToken() != null) {
                this.assertPolicy(aim, (Assertion)binding.getTransportToken());
            }
            if (!(algorithmValidator = new AlgorithmSuitePolicyValidator(results)).validatePolicy(ai, binding.getAlgorithmSuite())) continue;
            this.assertPolicy(aim, (Assertion)binding.getAlgorithmSuite());
            String namespace = binding.getAlgorithmSuite().getVersion().getNamespace();
            String name = binding.getAlgorithmSuite().getAlgorithmSuiteType().getName();
            Collection algSuiteAis = (Collection)aim.get((Object)new QName(namespace, name));
            if (algSuiteAis != null) {
                for (AssertionInfo algSuiteAi : algSuiteAis) {
                    algSuiteAi.setAsserted(true);
                }
            }
            if (!this.validateTimestamp(binding.isIncludeTimestamp(), true, results, signedResults, message)) {
                String error = "Received Timestamp does not match the requirements";
                ai.setNotAsserted(error);
                continue;
            }
            this.assertPolicy(aim, "IncludeTimestamp");
            Layout layout = binding.getLayout();
            LayoutPolicyValidator layoutValidator = new LayoutPolicyValidator(results, signedResults);
            if (!layoutValidator.validatePolicy(layout)) {
                String error = "Layout does not match the requirements";
                this.notAssertPolicy(aim, (Assertion)binding.getLayout(), error);
                ai.setNotAsserted(error);
                continue;
            }
            this.assertPolicy(aim, (Assertion)binding.getLayout());
            this.assertPolicy(aim, "Lax");
            this.assertPolicy(aim, "LaxTsFirst");
            this.assertPolicy(aim, "LaxTsLast");
            this.assertPolicy(aim, "Strict");
        }
    }
}

