/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.interceptor.SoapActionInInterceptor;
import org.apache.cxf.binding.soap.model.SoapBindingInfo;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.PolicyStaxActionInInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JStaxInInterceptor;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.policy.SP12Constants;
import org.apache.wss4j.policy.model.AlgorithmSuite;
import org.apache.wss4j.policy.stax.OperationPolicy;
import org.apache.wss4j.policy.stax.PolicyEnforcer;
import org.apache.wss4j.policy.stax.PolicyInputProcessor;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.impl.securityToken.HttpsSecurityTokenImpl;
import org.apache.wss4j.stax.securityEvent.HttpsTokenSecurityEvent;
import org.apache.wss4j.stax.securityToken.WSSecurityTokenConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.InputProcessor;
import org.apache.xml.security.stax.ext.XMLSecurityProperties;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;
import org.apache.xml.security.stax.securityToken.SecurityToken;

public class PolicyBasedWSS4JStaxInInterceptor
extends WSS4JStaxInInterceptor {
    public static final PolicyBasedWSS4JStaxInInterceptor INSTANCE = new PolicyBasedWSS4JStaxInInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyBasedWSS4JStaxInInterceptor.class);

    @Override
    public void handleMessage(SoapMessage msg) throws Fault {
        AssertionInfoMap aim = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
        boolean enableStax = MessageUtils.isTrue((Object)msg.getContextualProperty("ws-security.enable.streaming"));
        if (aim != null && enableStax) {
            super.handleMessage(msg);
            msg.getInterceptorChain().add((Interceptor)new PolicyStaxActionInInterceptor());
        }
    }

    private static Properties getProps(Object o, URL propsURL, SoapMessage message) {
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (propsURL != null) {
            try {
                properties = new Properties();
                InputStream ins = propsURL.openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                properties = null;
            }
        }
        return properties;
    }

    private URL getPropertiesFileURL(Object o, SoapMessage message) {
        if (o instanceof String) {
            URL url = null;
            ResourceManager rm = (ResourceManager)((Bus)message.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), AbstractWSS4JInterceptor.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException e) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    private Collection<AssertionInfo> getAllAssertionsByLocalname(AssertionInfoMap aim, String localname) {
        Collection sp11Ais = (Collection)aim.get((Object)new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
        Collection sp12Ais = (Collection)aim.get((Object)new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
        if (sp11Ais != null && !sp11Ais.isEmpty() || sp12Ais != null && !sp12Ais.isEmpty()) {
            HashSet<AssertionInfo> ais = new HashSet<AssertionInfo>();
            if (sp11Ais != null) {
                ais.addAll(sp11Ais);
            }
            if (sp12Ais != null) {
                ais.addAll(sp12Ais);
            }
            return ais;
        }
        return Collections.emptySet();
    }

    private void checkAsymmetricBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object e;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "AsymmetricBinding");
        if (ais.isEmpty()) {
            return;
        }
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (signCrypto != null) {
            message.put("decryptionPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        if (encrCrypto != null) {
            message.put("signatureVerificationPropRefId", (Object)("RefId-" + encrCrypto.hashCode()));
            message.put("RefId-" + encrCrypto.hashCode(), (Object)encrCrypto);
        } else if (signCrypto != null) {
            message.put("signatureVerificationPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
    }

    private void checkTransportBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws XMLSecurityException {
        Object e;
        Object s;
        boolean transportPolicyInEffect;
        boolean bl = transportPolicyInEffect = !this.getAllAssertionsByLocalname(aim, "TransportBinding").isEmpty();
        if (!(transportPolicyInEffect || this.getAllAssertionsByLocalname(aim, "SymmetricBinding").isEmpty() && this.getAllAssertionsByLocalname(aim, "AsymmetricBinding").isEmpty())) {
            return;
        }
        if (this.isRequestor(message)) {
            HttpsTokenSecurityEvent httpsTokenSecurityEvent = new HttpsTokenSecurityEvent();
            httpsTokenSecurityEvent.setAuthenticationType(HttpsTokenSecurityEvent.AuthenticationType.HttpsNoAuthentication);
            HttpsSecurityTokenImpl httpsSecurityToken = new HttpsSecurityTokenImpl();
            try {
                httpsSecurityToken.addTokenUsage(WSSecurityTokenConstants.TokenUsage_MainSignature);
            }
            catch (XMLSecurityException e2) {
                LOG.fine(e2.getMessage());
            }
            httpsTokenSecurityEvent.setSecurityToken((SecurityToken)httpsSecurityToken);
            List<SecurityEvent> securityEvents = this.getSecurityEventList((Message)message);
            securityEvents.add((SecurityEvent)httpsTokenSecurityEvent);
        }
        if ((s = message.getContextualProperty("ws-security.signature.crypto")) == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (signCrypto != null) {
            message.put("decryptionPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        if (encrCrypto != null) {
            message.put("signatureVerificationPropRefId", (Object)("RefId-" + encrCrypto.hashCode()));
            message.put("RefId-" + encrCrypto.hashCode(), (Object)encrCrypto);
        } else if (signCrypto != null) {
            message.put("signatureVerificationPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
    }

    private List<SecurityEvent> getSecurityEventList(Message message) {
        ArrayList securityEvents = (ArrayList)message.getExchange().get((Object)(SecurityEvent.class.getName() + ".out"));
        if (securityEvents == null) {
            securityEvents = new ArrayList();
            message.getExchange().put((Object)(SecurityEvent.class.getName() + ".out"), securityEvents);
        }
        return securityEvents;
    }

    private void checkSymmetricBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object e;
        Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SymmetricBinding");
        if (ais.isEmpty()) {
            return;
        }
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (this.isRequestor(message)) {
            Crypto crypto = encrCrypto;
            if (crypto == null) {
                crypto = signCrypto;
            }
            if (crypto != null) {
                message.put("signatureVerificationPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
            if ((crypto = signCrypto) == null) {
                crypto = encrCrypto;
            }
            if (crypto != null) {
                message.put("decryptionPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
        } else {
            Crypto crypto = signCrypto;
            if (crypto == null) {
                crypto = encrCrypto;
            }
            if (crypto != null) {
                message.put("signatureVerificationPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
            if ((crypto = encrCrypto) == null) {
                crypto = signCrypto;
            }
            if (crypto != null) {
                message.put("decryptionPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Crypto getEncryptionCrypto(Object e, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Crypto encrCrypto = null;
        if (e instanceof Crypto) {
            encrCrypto = (Crypto)e;
        } else if (e != null) {
            EndpointInfo info;
            URL propsURL = this.getPropertiesFileURL(e, message);
            Properties props = PolicyBasedWSS4JStaxInInterceptor.getProps(e, propsURL, message);
            if (props == null) {
                LOG.fine("Cannot find Crypto Encryption properties: " + e);
                Exception ex = new Exception("Cannot find Crypto Encryption properties: " + e);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
            }
            encrCrypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)this.getPasswordEncryptor(message, securityProperties));
            EndpointInfo endpointInfo = info = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
            synchronized (endpointInfo) {
                info.setProperty("ws-security.encryption.crypto", (Object)encrCrypto);
            }
        }
        return encrCrypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Crypto getSignatureCrypto(Object s, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Crypto signCrypto = null;
        if (s instanceof Crypto) {
            signCrypto = (Crypto)s;
        } else if (s != null) {
            EndpointInfo info;
            URL propsURL = this.getPropertiesFileURL(s, message);
            Properties props = PolicyBasedWSS4JStaxInInterceptor.getProps(s, propsURL, message);
            if (props == null) {
                LOG.fine("Cannot find Crypto Signature properties: " + s);
                Exception ex = new Exception("Cannot find Crypto Signature properties: " + s);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
            }
            signCrypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)this.getPasswordEncryptor(message, securityProperties));
            EndpointInfo endpointInfo = info = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
            synchronized (endpointInfo) {
                info.setProperty("ws-security.signature.crypto", (Object)signCrypto);
            }
        }
        return signCrypto;
    }

    @Override
    protected void configureProperties(SoapMessage msg, WSSSecurityProperties securityProperties) throws XMLSecurityException {
        Collection algorithmSuites;
        AssertionInfoMap aim = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
        this.checkAsymmetricBinding(aim, msg, securityProperties);
        this.checkSymmetricBinding(aim, msg, securityProperties);
        this.checkTransportBinding(aim, msg, securityProperties);
        String asymSignatureAlgorithm = (String)msg.getContextualProperty("ws-security.asymmetric.signature.algorithm");
        if (asymSignatureAlgorithm != null && (algorithmSuites = (Collection)aim.get((Object)SP12Constants.ALGORITHM_SUITE)) != null && !algorithmSuites.isEmpty()) {
            for (AssertionInfo algorithmSuite : algorithmSuites) {
                AlgorithmSuite algSuite = (AlgorithmSuite)algorithmSuite.getAssertion();
                algSuite.setAsymmetricSignature(asymSignatureAlgorithm);
            }
        }
        super.configureProperties(msg, securityProperties);
    }

    @Override
    protected boolean isNonceCacheRequired(SoapMessage msg, WSSSecurityProperties securityProperties) {
        Collection<AssertionInfo> ais;
        AssertionInfoMap aim = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
        return aim != null && !(ais = this.getAllAssertionsByLocalname(aim, "UsernameToken")).isEmpty();
    }

    @Override
    protected boolean isTimestampCacheRequired(SoapMessage msg, WSSSecurityProperties securityProperties) {
        Collection<AssertionInfo> ais;
        AssertionInfoMap aim = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
        return aim != null && !(ais = this.getAllAssertionsByLocalname(aim, "IncludeTimestamp")).isEmpty();
    }

    @Override
    protected boolean isSamlCacheRequired(SoapMessage msg, WSSSecurityProperties securityProperties) {
        Collection<AssertionInfo> ais;
        AssertionInfoMap aim = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
        return aim != null && !(ais = this.getAllAssertionsByLocalname(aim, "SamlToken")).isEmpty();
    }

    @Override
    protected List<SecurityEventListener> configureSecurityEventListeners(SoapMessage msg, WSSSecurityProperties securityProperties) throws WSSPolicyException {
        ArrayList<SecurityEventListener> securityEventListeners = new ArrayList<SecurityEventListener>(2);
        securityEventListeners.addAll(super.configureSecurityEventListeners(msg, securityProperties));
        Endpoint endoint = (Endpoint)msg.getExchange().get(Endpoint.class);
        PolicyEnforcer policyEnforcer = this.createPolicyEnforcer(endoint.getEndpointInfo(), msg);
        securityProperties.addInputProcessor((InputProcessor)new PolicyInputProcessor(policyEnforcer, (XMLSecurityProperties)securityProperties));
        securityEventListeners.add((SecurityEventListener)policyEnforcer);
        return securityEventListeners;
    }

    private PolicyEnforcer createPolicyEnforcer(EndpointInfo endpointInfo, SoapMessage msg) throws WSSPolicyException {
        EffectivePolicy dispatchPolicy = null;
        ArrayList<OperationPolicy> operationPolicies = new ArrayList<OperationPolicy>();
        Collection bindingOperationInfos = endpointInfo.getBinding().getOperations();
        for (BindingOperationInfo bindingOperationInfo : bindingOperationInfos) {
            SoapOperationInfo soapOperationInfo;
            QName operationName = bindingOperationInfo.getName();
            EffectivePolicy policy = (EffectivePolicy)bindingOperationInfo.getProperty("policy-engine-info-serve-request");
            String localName = operationName.getLocalPart();
            if (MessageUtils.isRequestor((Message)msg)) {
                policy = (EffectivePolicy)bindingOperationInfo.getProperty("policy-engine-info-client-response");
                if (policy != null && "http://cxf.apache.org/jaxws/dispatch".equals(operationName.getNamespaceURI())) {
                    dispatchPolicy = policy;
                }
                if (bindingOperationInfo.getOutput() != null) {
                    MessageInfo messageInfo = bindingOperationInfo.getOutput().getMessageInfo();
                    localName = messageInfo.getName().getLocalPart();
                    if (!messageInfo.getMessageParts().isEmpty() && messageInfo.getMessagePart(0).getConcreteName() != null) {
                        localName = messageInfo.getMessagePart(0).getConcreteName().getLocalPart();
                    }
                }
            }
            if ((soapOperationInfo = (SoapOperationInfo)bindingOperationInfo.getExtensor(SoapOperationInfo.class)) != null && policy == null && dispatchPolicy != null) {
                policy = dispatchPolicy;
            }
            if (policy == null || soapOperationInfo == null) continue;
            BindingInfo bindingInfo = bindingOperationInfo.getBinding();
            if (!(bindingInfo instanceof SoapBindingInfo)) {
                throw new IllegalArgumentException("BindingInfo is not an instance of SoapBindingInfo");
            }
            String soapNS = ((SoapBindingInfo)bindingInfo).getSoapVersion().getNamespace();
            OperationPolicy operationPolicy = new OperationPolicy(localName);
            operationPolicy.setPolicy(policy.getPolicy());
            operationPolicy.setOperationAction(soapOperationInfo.getAction());
            operationPolicy.setSoapMessageVersionNamespace(soapNS);
            operationPolicies.add(operationPolicy);
        }
        String soapAction = SoapActionInInterceptor.getSoapAction((Message)msg);
        if (soapAction == null) {
            soapAction = "";
        }
        String actor = (String)msg.getContextualProperty("ws-security.actor");
        Collection attachments = msg.getAttachments();
        int attachmentCount = 0;
        if (attachments != null && !attachments.isEmpty()) {
            attachmentCount = attachments.size();
        }
        return new PolicyEnforcer(operationPolicies, soapAction, this.isRequestor(msg), actor, attachmentCount);
    }
}

