/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.WSS4JStaxOutInterceptor;
import org.apache.cxf.ws.security.wss4j.policyhandlers.StaxAsymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.StaxSymmetricBindingHandler;
import org.apache.cxf.ws.security.wss4j.policyhandlers.StaxTransportBindingHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.policy.model.AsymmetricBinding;
import org.apache.wss4j.policy.model.SymmetricBinding;
import org.apache.wss4j.policy.model.TransportBinding;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class PolicyBasedWSS4JStaxOutInterceptor
extends WSS4JStaxOutInterceptor {
    public static final PolicyBasedWSS4JStaxOutInterceptor INSTANCE = new PolicyBasedWSS4JStaxOutInterceptor();
    private static final Logger LOG = LogUtils.getL7dLogger(PolicyBasedWSS4JStaxOutInterceptor.class);

    @Override
    public void handleMessage(SoapMessage msg) throws Fault {
        AssertionInfoMap aim = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
        boolean enableStax = MessageUtils.isTrue((Object)msg.getContextualProperty("ws-security.enable.streaming"));
        if (aim != null && enableStax) {
            this.getProperties().clear();
            super.handleMessage(msg);
        }
    }

    private static Properties getProps(Object o, URL propsURL, SoapMessage message) {
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (propsURL != null) {
            try {
                properties = new Properties();
                InputStream ins = propsURL.openStream();
                properties.load(ins);
                ins.close();
            }
            catch (IOException e) {
                properties = null;
            }
        }
        return properties;
    }

    private URL getPropertiesFileURL(Object o, SoapMessage message) {
        if (o instanceof String) {
            URL url = null;
            ResourceManager rm = (ResourceManager)((Bus)message.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
            url = (URL)rm.resolveResource((String)o, URL.class);
            try {
                if (url == null) {
                    url = ClassLoaderUtils.getResource((String)((String)o), AbstractWSS4JInterceptor.class);
                }
                if (url == null) {
                    url = new URL((String)o);
                }
                return url;
            }
            catch (IOException e) {}
        } else if (o instanceof URL) {
            return (URL)o;
        }
        return null;
    }

    private Collection<AssertionInfo> getAllAssertionsByLocalname(AssertionInfoMap aim, String localname) {
        Collection sp11Ais = (Collection)aim.get((Object)new QName("http://schemas.xmlsoap.org/ws/2005/07/securitypolicy", localname));
        Collection sp12Ais = (Collection)aim.get((Object)new QName("http://docs.oasis-open.org/ws-sx/ws-securitypolicy/200702", localname));
        if (sp11Ais != null && !sp11Ais.isEmpty() || sp12Ais != null && !sp12Ais.isEmpty()) {
            HashSet<AssertionInfo> ais = new HashSet<AssertionInfo>();
            if (sp11Ais != null) {
                ais.addAll(sp11Ais);
            }
            if (sp12Ais != null) {
                ais.addAll(sp12Ais);
            }
            return ais;
        }
        return Collections.emptySet();
    }

    private void checkAsymmetricBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object e;
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (signCrypto != null) {
            message.put("signaturePropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        if (encrCrypto != null) {
            message.put("encryptionPropRefId", (Object)("RefId-" + encrCrypto.hashCode()));
            message.put("RefId-" + encrCrypto.hashCode(), (Object)encrCrypto);
        } else if (signCrypto != null) {
            message.put("encryptionPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
    }

    private void checkTransportBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object e;
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (signCrypto != null) {
            message.put("signaturePropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
        if (encrCrypto != null) {
            message.put("encryptionPropRefId", (Object)("RefId-" + encrCrypto.hashCode()));
            message.put("RefId-" + encrCrypto.hashCode(), (Object)encrCrypto);
        } else if (signCrypto != null) {
            message.put("encryptionPropRefId", (Object)("RefId-" + signCrypto.hashCode()));
            message.put("RefId-" + signCrypto.hashCode(), (Object)signCrypto);
        }
    }

    private void checkSymmetricBinding(AssertionInfoMap aim, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Object e;
        Object s = message.getContextualProperty("ws-security.signature.crypto");
        if (s == null) {
            s = message.getContextualProperty("ws-security.signature.properties");
        }
        if ((e = message.getContextualProperty("ws-security.encryption.crypto")) == null) {
            e = message.getContextualProperty("ws-security.encryption.properties");
        }
        Crypto encrCrypto = this.getEncryptionCrypto(e, message, securityProperties);
        Crypto signCrypto = null;
        signCrypto = e != null && e.equals(s) ? encrCrypto : this.getSignatureCrypto(s, message, securityProperties);
        if (this.isRequestor(message)) {
            Crypto crypto = encrCrypto;
            if (crypto == null) {
                crypto = signCrypto;
            }
            if (crypto != null) {
                message.put("encryptionPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
            if ((crypto = signCrypto) == null) {
                crypto = encrCrypto;
            }
            if (crypto != null) {
                message.put("signaturePropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
        } else {
            Crypto crypto = signCrypto;
            if (crypto == null) {
                crypto = encrCrypto;
            }
            if (crypto != null) {
                message.put("encryptionPropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
            if ((crypto = encrCrypto) == null) {
                crypto = signCrypto;
            }
            if (crypto != null) {
                message.put("signaturePropRefId", (Object)("RefId-" + crypto.hashCode()));
                message.put("RefId-" + crypto.hashCode(), (Object)crypto);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Crypto getEncryptionCrypto(Object e, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Crypto encrCrypto = null;
        if (e instanceof Crypto) {
            encrCrypto = (Crypto)e;
        } else if (e != null) {
            EndpointInfo info;
            URL propsURL = this.getPropertiesFileURL(e, message);
            Properties props = PolicyBasedWSS4JStaxOutInterceptor.getProps(e, propsURL, message);
            if (props == null) {
                LOG.fine("Cannot find Crypto Encryption properties: " + e);
                Exception ex = new Exception("Cannot find Crypto Encryption properties: " + e);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
            }
            encrCrypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)this.getPasswordEncryptor(message, securityProperties));
            EndpointInfo endpointInfo = info = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
            synchronized (endpointInfo) {
                info.setProperty("ws-security.encryption.crypto", (Object)encrCrypto);
            }
        }
        return encrCrypto;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Crypto getSignatureCrypto(Object s, SoapMessage message, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Crypto signCrypto = null;
        if (s instanceof Crypto) {
            signCrypto = (Crypto)s;
        } else if (s != null) {
            EndpointInfo info;
            URL propsURL = this.getPropertiesFileURL(s, message);
            Properties props = PolicyBasedWSS4JStaxOutInterceptor.getProps(s, propsURL, message);
            if (props == null) {
                LOG.fine("Cannot find Crypto Signature properties: " + s);
                Exception ex = new Exception("Cannot find Crypto Signature properties: " + s);
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
            }
            signCrypto = CryptoFactory.getInstance((Properties)props, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)this.getPasswordEncryptor(message, securityProperties));
            EndpointInfo endpointInfo = info = ((Endpoint)message.getExchange().get(Endpoint.class)).getEndpointInfo();
            synchronized (endpointInfo) {
                info.setProperty("ws-security.signature.crypto", (Object)signCrypto);
            }
        }
        return signCrypto;
    }

    @Override
    protected void configureProperties(SoapMessage msg, Map<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Collection<AssertionInfo> transAis;
        Collection<AssertionInfo> symAis;
        AssertionInfoMap aim = (AssertionInfoMap)msg.get(AssertionInfoMap.class);
        Collection<AssertionInfo> asymAis = this.getAllAssertionsByLocalname(aim, "AsymmetricBinding");
        if (!asymAis.isEmpty()) {
            this.checkAsymmetricBinding(aim, msg, securityProperties);
        }
        if (!(symAis = this.getAllAssertionsByLocalname(aim, "SymmetricBinding")).isEmpty()) {
            this.checkSymmetricBinding(aim, msg, securityProperties);
        }
        if (!(transAis = this.getAllAssertionsByLocalname(aim, "TransportBinding")).isEmpty()) {
            this.checkTransportBinding(aim, msg, securityProperties);
        }
        super.configureProperties(msg, outboundTokens, securityProperties);
        if (!transAis.isEmpty()) {
            TransportBinding binding = (TransportBinding)transAis.iterator().next().getAssertion();
            new StaxTransportBindingHandler(securityProperties, msg, binding, outboundTokens).handleBinding();
        } else if (!asymAis.isEmpty()) {
            AsymmetricBinding binding = (AsymmetricBinding)asymAis.iterator().next().getAssertion();
            new StaxAsymmetricBindingHandler(securityProperties, msg, binding, outboundTokens).handleBinding();
        } else if (!symAis.isEmpty()) {
            SymmetricBinding binding = (SymmetricBinding)symAis.iterator().next().getAssertion();
            new StaxSymmetricBindingHandler(securityProperties, msg, binding, outboundTokens).handleBinding();
        } else {
            new StaxTransportBindingHandler(securityProperties, msg, null, outboundTokens).handleBinding();
        }
    }
}

