/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.security.SimplePrincipal;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.interceptor.security.RolePrefixSecurityContextImpl;
import org.apache.cxf.interceptor.security.SAMLSecurityContext;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.AttachmentCallbackHandler;
import org.apache.cxf.ws.security.wss4j.DelegatingCallbackHandler;
import org.apache.cxf.ws.security.wss4j.SAMLUtils;
import org.apache.cxf.ws.security.wss4j.WSS4JTokenConverter;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.CustomTokenPrincipal;
import org.apache.wss4j.common.principal.WSDerivedKeyTokenPrincipal;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.validate.NoOpValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSS4JInInterceptor
extends AbstractWSS4JInterceptor {
    public static final String SAML_ROLE_ATTRIBUTENAME_DEFAULT = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
    public static final String TIMESTAMP_RESULT = "wss4j.timestamp.result";
    public static final String SIGNATURE_RESULT = "wss4j.signature.result";
    public static final String PRINCIPAL_RESULT = "wss4j.principal.result";
    public static final String PROCESSOR_MAP = "wss4j.processor.map";
    public static final String VALIDATOR_MAP = "wss4j.validator.map";
    public static final String SECURITY_PROCESSED = WSS4JInInterceptor.class.getName() + ".DONE";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class);
    private boolean ignoreActions;
    private WSSecurityEngine secEngineOverride;

    public WSS4JInInterceptor() {
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJInInterceptor.class.getName());
    }

    public WSS4JInInterceptor(boolean ignore) {
        this();
        this.ignoreActions = ignore;
    }

    public WSS4JInInterceptor(Map<String, Object> properties) {
        this();
        this.setProperties(properties);
        Map processorMap = CastUtils.cast((Map)((Map)properties.get(PROCESSOR_MAP)));
        Map validatorMap = CastUtils.cast((Map)((Map)properties.get(VALIDATOR_MAP)));
        if (processorMap != null) {
            if (validatorMap != null) {
                processorMap.putAll(validatorMap);
            }
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(processorMap);
        } else if (validatorMap != null) {
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(validatorMap);
        }
    }

    public void setIgnoreActions(boolean i) {
        this.ignoreActions = i;
    }

    private SOAPMessage getSOAPMessage(SoapMessage msg) {
        SAAJInInterceptor.INSTANCE.handleMessage(msg);
        return (SOAPMessage)msg.getContent(SOAPMessage.class);
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        Object result = super.getProperty(msgContext, key);
        if (result == null && "_sendSignatureValues_".equals(key) && this.isRequestor((SoapMessage)msgContext)) {
            result = ((SoapMessage)msgContext).getExchange().getOutMessage().get((Object)key);
        }
        return result;
    }

    public final boolean isGET(SoapMessage message) {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        boolean isGet = "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
        return isGet;
    }

    public void handleMessage(SoapMessage msg) throws Fault {
        WSSecurityEngine engine;
        if (msg.containsKey((Object)SECURITY_PROCESSED) || this.isGET(msg)) {
            return;
        }
        boolean utWithCallbacks = MessageUtils.getContextualBoolean((Message)msg, (String)"ws-security.validate.token", (boolean)true);
        this.translateProperties(msg);
        CXFRequestData reqData = new CXFRequestData();
        WSSConfig config = (WSSConfig)msg.getContextualProperty(WSSConfig.class.getName());
        if (config != null) {
            engine = new WSSecurityEngine();
            engine.setWssConfig(config);
        } else {
            engine = this.getSecurityEngine(utWithCallbacks);
            if (engine == null) {
                engine = new WSSecurityEngine();
            }
            config = engine.getWssConfig();
        }
        reqData.setWssConfig(config);
        SOAPMessage doc = this.getSOAPMessage(msg);
        boolean doDebug = LOG.isLoggable(Level.FINE);
        SoapVersion version = msg.getVersion();
        if (doDebug) {
            LOG.fine("WSS4JInInterceptor: enter handleMessage()");
        }
        try {
            reqData.setMsgContext(msg);
            reqData.setAttachmentCallbackHandler(new AttachmentCallbackHandler(msg));
            this.setAlgorithmSuites(msg, reqData);
            reqData.setCallbackHandler(this.getCallback(reqData, utWithCallbacks));
            this.computeAction(msg, reqData);
            String action = this.getAction(msg, version);
            List actions = WSSecurityUtil.decodeAction((String)action);
            String actor = (String)this.getOption("actor");
            if (actor == null) {
                actor = (String)msg.getContextualProperty("ws-security.actor");
            }
            this.configureReplayCaches(reqData, actions, msg);
            TLSSessionInfo tlsInfo = (TLSSessionInfo)msg.get(TLSSessionInfo.class);
            if (tlsInfo != null) {
                Certificate[] tlsCerts = tlsInfo.getPeerCertificates();
                reqData.setTlsCerts(tlsCerts);
            }
            this.doReceiverAction(actions, reqData);
            boolean enableRevocation = reqData.isRevocationEnabled() || MessageUtils.isTrue((Object)msg.getContextualProperty("ws-security.enableRevocation"));
            reqData.setEnableRevocation(enableRevocation);
            Element elem = WSSecurityUtil.getSecurityHeader((Document)doc.getSOAPPart(), (String)actor);
            ArrayList<WSSecurityEngineResult> wsResult = engine.processSecurityHeader(elem, (RequestData)reqData);
            if (wsResult != null && !wsResult.isEmpty()) {
                if (reqData.getWssConfig().isEnableSignatureConfirmation()) {
                    this.checkSignatureConfirmation(reqData, wsResult);
                }
                this.storeSignature(msg, reqData, wsResult);
                this.storeTimestamp(msg, reqData, wsResult);
                this.checkActions(msg, reqData, wsResult, actions, (Element)SAAJUtils.getBody((SOAPMessage)doc));
                this.doResults(msg, actor, (Element)SAAJUtils.getHeader((SOAPMessage)doc), (Element)SAAJUtils.getBody((SOAPMessage)doc), wsResult, utWithCallbacks);
            } else {
                wsResult = new ArrayList<WSSecurityEngineResult>();
                if (doc.getSOAPPart().getEnvelope().getBody().hasFault() && this.isRequestor(msg)) {
                    LOG.warning("Request does not contain Security header, but it's a fault.");
                    this.doResults(msg, actor, (Element)SAAJUtils.getHeader((SOAPMessage)doc), (Element)SAAJUtils.getBody((SOAPMessage)doc), wsResult);
                } else {
                    this.checkActions(msg, reqData, wsResult, actions, (Element)SAAJUtils.getBody((SOAPMessage)doc));
                    this.doResults(msg, actor, (Element)SAAJUtils.getHeader((SOAPMessage)doc), (Element)SAAJUtils.getBody((SOAPMessage)doc), wsResult);
                }
            }
            this.advanceBody(msg, (Node)SAAJUtils.getBody((SOAPMessage)doc));
            SAAJInInterceptor.replaceHeaders((SOAPMessage)doc, (SoapMessage)msg);
            if (doDebug) {
                LOG.fine("WSS4JInInterceptor: exit handleMessage()");
            }
            msg.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
        }
        catch (WSSecurityException e) {
            throw this.createSoapFault(msg, version, e);
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("STAX_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        catch (SOAPException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("SAAJ_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        finally {
            reqData.clear();
            reqData = null;
        }
    }

    private void checkActions(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult, List<Integer> actions, Element body) throws WSSecurityException {
        if (this.ignoreActions) {
            return;
        }
        if (!this.checkReceiverResultsAnyOrder(wsResult, actions)) {
            LOG.warning("Security processing failed (actions mismatch)");
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
        }
        String signatureParts = (String)this.getProperty(msg, "signatureParts");
        if (signatureParts != null) {
            String warning = "To enforce that particular elements were signed you must either use WS-SecurityPolicy, or else use the CryptoCoverageChecker or SignatureCoverageChecker";
            LOG.warning(warning);
        }
    }

    private void storeSignature(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult) throws WSSecurityException {
        List signatureResults = WSSecurityUtil.fetchAllActionResults(wsResult, (int)2);
        if (!signatureResults.isEmpty()) {
            msg.put(SIGNATURE_RESULT, signatureResults.get(signatureResults.size() - 1));
        }
    }

    private void storeTimestamp(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult) throws WSSecurityException {
        List timestampResults = WSSecurityUtil.fetchAllActionResults(wsResult, (int)32);
        if (!timestampResults.isEmpty()) {
            msg.put(TIMESTAMP_RESULT, timestampResults.get(timestampResults.size() - 1));
        }
    }

    protected void computeAction(SoapMessage msg, RequestData reqData) throws WSSecurityException {
        Crypto sigCrypto;
        Crypto encCrypto = (Crypto)msg.getContextualProperty("ws-security.encryption.crypto");
        if (encCrypto != null) {
            reqData.setDecCrypto(encCrypto);
        }
        if ((sigCrypto = (Crypto)msg.getContextualProperty("ws-security.signature.crypto")) != null) {
            reqData.setSigVerCrypto(sigCrypto);
        }
    }

    protected void configureReplayCaches(RequestData reqData, List<Integer> actions, SoapMessage msg) throws WSSecurityException {
        reqData.setEnableNonceReplayCache(false);
        if (this.isNonceCacheRequired(actions, msg)) {
            ReplayCache nonceCache = this.getReplayCache(msg, "ws-security.enable.nonce.cache", "ws-security.nonce.cache.instance");
            reqData.setNonceReplayCache(nonceCache);
            if (nonceCache != null) {
                reqData.setEnableNonceReplayCache(true);
            }
        }
        reqData.setEnableTimestampReplayCache(false);
        if (this.isTimestampCacheRequired(actions, msg)) {
            ReplayCache timestampCache = this.getReplayCache(msg, "ws-security.enable.timestamp.cache", "ws-security.timestamp.cache.instance");
            reqData.setTimestampReplayCache(timestampCache);
            if (timestampCache != null) {
                reqData.setEnableTimestampReplayCache(true);
            }
        }
        reqData.setEnableSamlOneTimeUseReplayCache(false);
        if (this.isSamlCacheRequired(actions, msg)) {
            ReplayCache samlCache = this.getReplayCache(msg, "ws-security.enable.saml.cache", "ws-security.saml.cache.instance");
            reqData.setSamlOneTimeUseReplayCache(samlCache);
            if (samlCache != null) {
                reqData.setEnableSamlOneTimeUseReplayCache(true);
            }
        }
    }

    protected boolean isNonceCacheRequired(List<Integer> actions, SoapMessage msg) {
        return actions.contains(1) || actions.contains(8192);
    }

    protected boolean isTimestampCacheRequired(List<Integer> actions, SoapMessage msg) {
        return actions.contains(32);
    }

    protected boolean isSamlCacheRequired(List<Integer> actions, SoapMessage msg) {
        return actions.contains(8) || actions.contains(16);
    }

    protected void setAlgorithmSuites(SoapMessage message, RequestData data) throws WSSecurityException {
        super.decodeAlgorithmSuite(data);
    }

    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, List<WSSecurityEngineResult> wsResult) throws SOAPException, XMLStreamException, WSSecurityException {
        this.doResults(msg, actor, soapHeader, soapBody, wsResult, false);
    }

    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, List<WSSecurityEngineResult> wsResult, boolean utWithCallbacks) throws SOAPException, XMLStreamException, WSSecurityException {
        ArrayList<WSHandlerResult> results = CastUtils.cast((List)((List)msg.get((Object)"RECV_RESULTS")));
        if (results == null) {
            results = new ArrayList<WSHandlerResult>();
            msg.put("RECV_RESULTS", results);
        }
        WSHandlerResult rResult = new WSHandlerResult(actor, wsResult);
        results.add(0, rResult);
        for (int i = wsResult.size() - 1; i >= 0; --i) {
            Object receivedAssertion;
            WSSecurityEngineResult o = wsResult.get(i);
            Integer action = (Integer)o.get((Object)"action");
            if (action == 4) continue;
            Principal p = (Principal)o.get((Object)"principal");
            Subject subject = (Subject)o.get((Object)"subject");
            boolean useJAASSubject = MessageUtils.getContextualBoolean((Message)msg, (String)"ws-security.sc.jaas-subject", (boolean)true);
            if (subject != null && !(p instanceof KerberosPrincipal) && useJAASSubject) {
                String roleClassifier = (String)msg.getContextualProperty("ws-security.role.classifier");
                if (roleClassifier != null && !"".equals(roleClassifier)) {
                    String roleClassifierType = (String)msg.getContextualProperty("ws-security.role.classifier.type");
                    if (roleClassifierType == null || "".equals(roleClassifierType)) {
                        roleClassifierType = "prefix";
                    }
                    msg.put(SecurityContext.class, (Object)new RolePrefixSecurityContextImpl(subject, roleClassifier, roleClassifierType));
                    break;
                }
                msg.put(SecurityContext.class, (Object)new DefaultSecurityContext(p, subject));
                break;
            }
            if (p == null || !this.isSecurityContextPrincipal(p, wsResult)) continue;
            msg.put(PRINCIPAL_RESULT, (Object)p);
            if (!utWithCallbacks) {
                WSS4JTokenConverter.convertToken((Message)msg, p);
            }
            if ((receivedAssertion = o.get((Object)"saml-assertion")) == null) {
                receivedAssertion = o.get((Object)"transformed-token");
            }
            List<String> roles = null;
            if (receivedAssertion instanceof SamlAssertionWrapper) {
                String roleAttributeName = (String)msg.getContextualProperty("ws-security.saml-role-attributename");
                if (roleAttributeName == null || roleAttributeName.length() == 0) {
                    roleAttributeName = SAML_ROLE_ATTRIBUTENAME_DEFAULT;
                }
                roles = SAMLUtils.parseRolesInAssertion(receivedAssertion, roleAttributeName);
                SAMLSecurityContext context = this.createSecurityContext(p, roles);
                context.setIssuer(SAMLUtils.getIssuer(receivedAssertion));
                context.setAssertionElement(SAMLUtils.getAssertionElement(receivedAssertion));
                msg.put(SecurityContext.class, (Object)context);
                break;
            }
            msg.put(SecurityContext.class, (Object)this.createSecurityContext(p));
            break;
        }
    }

    protected boolean isSecurityContextPrincipal(Principal p, List<WSSecurityEngineResult> wsResult) {
        boolean derivedKeyPrincipal = p instanceof WSDerivedKeyTokenPrincipal;
        if (derivedKeyPrincipal || p instanceof CustomTokenPrincipal) {
            return wsResult.size() <= 1;
        }
        return true;
    }

    protected void advanceBody(SoapMessage msg, Node body) throws SOAPException, XMLStreamException, WSSecurityException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)new DOMSource(body));
        int evt = reader.next();
        for (int i = 0; reader.hasNext() && i < 1 && (evt != 2 || evt != 1); ++i) {
            reader.next();
        }
        msg.setContent(XMLStreamReader.class, (Object)reader);
    }

    protected SecurityContext createSecurityContext(final Principal p) {
        return new SecurityContext(){

            public Principal getUserPrincipal() {
                return p;
            }

            public boolean isUserInRole(String arg0) {
                return false;
            }
        };
    }

    protected SAMLSecurityContext createSecurityContext(Principal p, List<String> roles) {
        HashSet<SimplePrincipal> userRoles;
        if (roles != null) {
            userRoles = new HashSet<SimplePrincipal>();
            for (String role : roles) {
                userRoles.add(new SimplePrincipal(role));
            }
        } else {
            userRoles = null;
        }
        return new SAMLSecurityContext(p, userRoles);
    }

    private String getAction(SoapMessage msg, SoapVersion version) {
        String action = (String)this.getOption("action");
        if (action == null) {
            action = (String)msg.get((Object)"action");
        }
        if (action == null) {
            LOG.warning("No security action was defined!");
            throw new SoapFault("No security action was defined!", version.getReceiver());
        }
        return action;
    }

    protected CallbackHandler getCallback(RequestData reqData, boolean utWithCallbacks) throws WSSecurityException {
        if (!utWithCallbacks) {
            CallbackHandler pwdCallback = null;
            try {
                pwdCallback = this.getCallback(reqData);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return new DelegatingCallbackHandler(pwdCallback);
        }
        return this.getCallback(reqData);
    }

    protected CallbackHandler getCallback(RequestData reqData) throws WSSecurityException {
        TokenStore store;
        Endpoint ep;
        Object o = ((SoapMessage)reqData.getMsgContext()).getContextualProperty("ws-security.callback-handler");
        if (o instanceof String) {
            try {
                o = ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
            }
            catch (Exception e) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, e);
            }
        }
        CallbackHandler cbHandler = null;
        if (o instanceof CallbackHandler) {
            cbHandler = (CallbackHandler)o;
        }
        if (cbHandler == null) {
            try {
                cbHandler = this.getPasswordCallbackHandler(reqData);
            }
            catch (WSSecurityException sec) {
                TokenStore store2;
                Endpoint ep2 = (Endpoint)((SoapMessage)reqData.getMsgContext()).getExchange().get(Endpoint.class);
                if (ep2 != null && ep2.getEndpointInfo() != null && (store2 = WSS4JUtils.getTokenStore((Message)((SoapMessage)reqData.getMsgContext()), false)) != null) {
                    return new TokenStoreCallbackHandler(null, store2);
                }
                throw sec;
            }
        }
        if ((ep = (Endpoint)((SoapMessage)reqData.getMsgContext()).getExchange().get(Endpoint.class)) != null && ep.getEndpointInfo() != null && (store = WSS4JUtils.getTokenStore((Message)((SoapMessage)reqData.getMsgContext()), false)) != null) {
            return new TokenStoreCallbackHandler(cbHandler, store);
        }
        return cbHandler;
    }

    protected WSSecurityEngine getSecurityEngine(boolean utWithCallbacks) {
        if (this.secEngineOverride != null) {
            return this.secEngineOverride;
        }
        if (!utWithCallbacks) {
            HashMap<QName, Object> profiles = new HashMap<QName, Object>(1);
            NoOpValidator validator = new NoOpValidator();
            profiles.put(WSSecurityEngine.USERNAME_TOKEN, validator);
            return WSS4JInInterceptor.createSecurityEngine(profiles);
        }
        return null;
    }

    protected static WSSecurityEngine createSecurityEngine(Map<QName, Object> map) {
        assert (map != null);
        WSSConfig config = WSSConfig.getNewInstance();
        for (Map.Entry<QName, Object> entry : map.entrySet()) {
            QName key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Class) {
                config.setProcessor(key, (Class)val);
                continue;
            }
            if (val instanceof Processor) {
                config.setProcessor(key, (Processor)val);
                continue;
            }
            if (val instanceof Validator) {
                config.setValidator(key, (Validator)val);
                continue;
            }
            if (val != null) continue;
            config.setProcessor(key, (Class)null);
        }
        WSSecurityEngine ret = new WSSecurityEngine();
        ret.setWssConfig(config);
        return ret;
    }

    protected ReplayCache getReplayCache(SoapMessage message, String booleanKey, String instanceKey) {
        return WSS4JUtils.getReplayCache(message, booleanKey, instanceKey);
    }

    private SoapFault createSoapFault(SoapMessage message, SoapVersion version, WSSecurityException e) {
        SoapFault fault;
        String errorMessage = null;
        boolean returnSecurityError = MessageUtils.getContextualBoolean((Message)message, (String)"ws-security.return.security.error", (boolean)false);
        errorMessage = returnSecurityError ? e.getMessage() : e.getSafeExceptionMessage();
        QName faultCode = e.getFaultCode();
        if (version.getVersion() == 1.1 && faultCode != null) {
            fault = new SoapFault(errorMessage, (Throwable)e, faultCode);
        } else {
            fault = new SoapFault(errorMessage, (Throwable)e, version.getSender());
            if (version.getVersion() != 1.1 && faultCode != null) {
                fault.setSubCode(faultCode);
            }
        }
        return fault;
    }

    static class CXFRequestData
    extends RequestData {
        public Validator getValidator(QName qName) throws WSSecurityException {
            String key = null;
            if (WSSecurityEngine.SAML_TOKEN.equals(qName)) {
                key = "ws-security.saml1.validator";
            } else if (WSSecurityEngine.SAML2_TOKEN.equals(qName)) {
                key = "ws-security.saml2.validator";
            } else if (WSSecurityEngine.USERNAME_TOKEN.equals(qName)) {
                key = "ws-security.ut.validator";
            } else if (WSSecurityEngine.SIGNATURE.equals(qName)) {
                key = "ws-security.signature.validator";
            } else if (WSSecurityEngine.TIMESTAMP.equals(qName)) {
                key = "ws-security.timestamp.validator";
            } else if (WSSecurityEngine.BINARY_TOKEN.equals(qName)) {
                key = "ws-security.bst.validator";
            } else if (WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_02.equals(qName) || WSSecurityEngine.SECURITY_CONTEXT_TOKEN_05_12.equals(qName)) {
                key = "ws-security.sct.validator";
            }
            if (key != null) {
                Object o = ((SoapMessage)this.getMsgContext()).getContextualProperty(key);
                try {
                    if (o instanceof Validator) {
                        return (Validator)o;
                    }
                    if (o instanceof Class) {
                        return (Validator)((Class)o).newInstance();
                    }
                    if (o instanceof String) {
                        return (Validator)ClassLoaderUtils.loadClass((String)o.toString(), WSS4JInInterceptor.class).newInstance();
                    }
                    if (o != null) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "Cannot load Validator: " + o, new Object[0]);
                    }
                }
                catch (RuntimeException t) {
                    throw t;
                }
                catch (Exception ex) {
                    throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
                }
            }
            return super.getValidator(qName);
        }
    }

    private class TokenStoreCallbackHandler
    implements CallbackHandler {
        private CallbackHandler internal;
        private TokenStore store;

        public TokenStoreCallbackHandler(CallbackHandler in, TokenStore st) {
            this.internal = in;
            this.store = st;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (int i = 0; i < callbacks.length; ++i) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                String id = pc.getIdentifier();
                SecurityToken tok = this.store.getToken(id);
                if (tok == null) continue;
                pc.setKey(tok.getSecret());
                pc.setCustomToken(tok.getToken());
                return;
            }
            if (this.internal != null) {
                this.internal.handle(callbacks);
            }
        }
    }
}

