/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JStaxInterceptor;
import org.apache.cxf.ws.security.wss4j.AttachmentCallbackHandler;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ConfigurationConverter;
import org.apache.wss4j.stax.WSSec;
import org.apache.wss4j.stax.ext.OutboundWSSec;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.OutboundSecurityContext;
import org.apache.xml.security.stax.impl.OutboundSecurityContextImpl;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;
import org.apache.xml.security.stax.securityToken.OutboundSecurityToken;
import org.apache.xml.security.stax.securityToken.SecurityTokenProvider;

public class WSS4JStaxOutInterceptor
extends AbstractWSS4JStaxInterceptor {
    public static final String OUTPUT_STREAM_HOLDER = WSS4JStaxOutInterceptor.class.getName() + ".outputstream";
    private WSS4JStaxOutInterceptorInternal ending;
    private boolean mtomEnabled;

    public WSS4JStaxOutInterceptor(WSSSecurityProperties securityProperties) {
        super(securityProperties);
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public WSS4JStaxOutInterceptor(Map<String, Object> props) {
        super(props);
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public WSS4JStaxOutInterceptor() {
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public boolean isAllowMTOM() {
        return this.mtomEnabled;
    }

    public void setAllowMTOM(boolean allowMTOM) {
        this.mtomEnabled = allowMTOM;
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        return super.getProperty(msgContext, key);
    }

    public void handleMessage(SoapMessage mc) throws Fault {
        XMLStreamWriter newXMLStreamWriter;
        if (!this.mtomEnabled) {
            mc.put("mtom-enabled", (Object)false);
        }
        OutputStream os = (OutputStream)mc.getContent(OutputStream.class);
        String encoding = this.getEncoding((Message)mc);
        try {
            List requestSecurityEvents = (List)mc.getExchange().get((Object)(SecurityEvent.class.getName() + ".in"));
            WSSSecurityProperties secProps = this.createSecurityProperties();
            this.translateProperties(mc, secProps);
            HashMap<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens = new HashMap<String, SecurityTokenProvider<OutboundSecurityToken>>();
            this.configureCallbackHandler(mc, secProps);
            this.configureProperties(mc, outboundTokens, secProps);
            OutboundWSSec outboundWSSec = null;
            if ((secProps.getActions() == null || secProps.getActions().size() == 0) && mc.get(AssertionInfoMap.class) != null) {
                return;
            }
            if (secProps.getAttachmentCallbackHandler() == null) {
                secProps.setAttachmentCallbackHandler((CallbackHandler)new AttachmentCallbackHandler(mc));
            }
            SecurityEventListener securityEventListener = this.configureSecurityEventListener(mc, secProps);
            outboundWSSec = WSSec.getOutboundWSSec((WSSSecurityProperties)secProps);
            OutboundSecurityContextImpl outboundSecurityContext = new OutboundSecurityContextImpl();
            outboundSecurityContext.putList(SecurityEvent.class, requestSecurityEvents);
            outboundSecurityContext.addSecurityEventListener(securityEventListener);
            for (String key : outboundTokens.keySet()) {
                SecurityTokenProvider provider = (SecurityTokenProvider)outboundTokens.get(key);
                outboundSecurityContext.registerSecurityTokenProvider(provider.getId(), provider);
                outboundSecurityContext.put(key, (Object)provider.getId());
            }
            newXMLStreamWriter = outboundWSSec.processOutMessage((Object)os, encoding, (OutboundSecurityContext)outboundSecurityContext);
            mc.setContent(XMLStreamWriter.class, (Object)newXMLStreamWriter);
        }
        catch (WSSecurityException e) {
            throw new Fault((Throwable)e);
        }
        catch (WSSPolicyException e) {
            throw new Fault((Throwable)e);
        }
        mc.put("disable.outputstream.optimization", (Object)Boolean.TRUE);
        mc.put("org.apache.cxf.stax.force-start-document", (Object)Boolean.TRUE);
        if (MessageUtils.getContextualBoolean((Message)mc, (String)"org.apache.cxf.stax.force-start-document", (boolean)false)) {
            try {
                newXMLStreamWriter.writeStartDocument(encoding, "1.0");
            }
            catch (XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
            mc.removeContent(OutputStream.class);
            mc.put(OUTPUT_STREAM_HOLDER, (Object)os);
        }
        mc.getInterceptorChain().add((Interceptor)this.ending);
    }

    protected SecurityEventListener configureSecurityEventListener(final SoapMessage msg, WSSSecurityProperties securityProperties) throws WSSPolicyException {
        final LinkedList outgoingSecurityEventList = new LinkedList();
        SecurityEventListener securityEventListener = new SecurityEventListener(){

            public void registerSecurityEvent(SecurityEvent securityEvent) throws XMLSecurityException {
                if (securityEvent.getSecurityEventType() == WSSecurityEventConstants.SamlToken && securityEvent instanceof TokenSecurityEvent) {
                    TokenSecurityEvent tokenSecurityEvent = (TokenSecurityEvent)securityEvent;
                    WSS4JUtils.parseAndStoreStreamingSecurityToken(tokenSecurityEvent.getSecurityToken(), (Message)msg);
                } else {
                    outgoingSecurityEventList.add(securityEvent);
                }
            }
        };
        msg.getExchange().put((Object)(SecurityEvent.class.getName() + ".out"), outgoingSecurityEventList);
        msg.put(SecurityEvent.class.getName() + ".out", outgoingSecurityEventList);
        return securityEventListener;
    }

    protected void configureProperties(SoapMessage msg, Map<String, SecurityTokenProvider<OutboundSecurityToken>> outboundTokens, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Map<String, Object> config = this.getProperties();
        if (config != null) {
            Crypto encCrypto;
            Crypto sigCrypto;
            String encUser;
            String sigUser;
            String user = (String)msg.getContextualProperty("ws-security.username");
            if (user != null) {
                securityProperties.setTokenUser(user);
            }
            if ((sigUser = (String)msg.getContextualProperty("ws-security.signature.username")) != null) {
                securityProperties.setSignatureUser(sigUser);
            }
            if ((encUser = (String)msg.getContextualProperty("ws-security.encryption.username")) != null) {
                securityProperties.setEncryptionUser(encUser);
            }
            if ((sigCrypto = this.loadCrypto(msg, "signaturePropFile", "signaturePropRefId", securityProperties)) != null) {
                config.put("signaturePropRefId", "RefId-" + sigCrypto.hashCode());
                config.put("RefId-" + sigCrypto.hashCode(), sigCrypto);
                if (sigUser == null && sigCrypto.getDefaultX509Identifier() != null) {
                    securityProperties.setSignatureUser(sigCrypto.getDefaultX509Identifier());
                }
            }
            if ((encCrypto = this.loadCrypto(msg, "encryptionPropFile", "encryptionPropRefId", securityProperties)) != null) {
                config.put("encryptionPropRefId", "RefId-" + encCrypto.hashCode());
                config.put("RefId-" + encCrypto.hashCode(), encCrypto);
                if (encUser == null && encCrypto.getDefaultX509Identifier() != null) {
                    securityProperties.setEncryptionUser(encCrypto.getDefaultX509Identifier());
                }
            }
            ConfigurationConverter.parseCrypto(config, (WSSSecurityProperties)securityProperties);
            if (securityProperties.getSignatureUser() == null && user != null) {
                securityProperties.setSignatureUser(user);
            }
            if (securityProperties.getEncryptionUser() == null && user != null) {
                securityProperties.setEncryptionUser(user);
            }
        }
    }

    public final WSS4JStaxOutInterceptorInternal createEndingInterceptor() {
        return new WSS4JStaxOutInterceptorInternal();
    }

    private String getEncoding(Message message) {
        Exchange ex = message.getExchange();
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding == null && ex.getInMessage() != null) {
            encoding = (String)ex.getInMessage().get((Object)Message.ENCODING);
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        return encoding;
    }

    final class WSS4JStaxOutInterceptorInternal
    extends AbstractPhaseInterceptor<Message> {
        public WSS4JStaxOutInterceptorInternal() {
            super("pre-stream-ending");
            this.getBefore().add(AttachmentOutInterceptor.AttachmentOutEndingInterceptor.class.getName());
        }

        public void handleMessage(Message mc) throws Fault {
            try {
                OutputStream os;
                XMLStreamWriter xtw = (XMLStreamWriter)mc.getContent(XMLStreamWriter.class);
                if (xtw != null) {
                    xtw.writeEndDocument();
                    xtw.flush();
                    xtw.close();
                }
                if ((os = (OutputStream)mc.get((Object)OUTPUT_STREAM_HOLDER)) != null) {
                    mc.setContent(OutputStream.class, (Object)os);
                }
                mc.removeContent(XMLStreamWriter.class);
            }
            catch (XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
        }
    }
}

