/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.message.token.BinarySecurity;
import org.apache.wss4j.dom.message.token.PKIPathSecurity;
import org.apache.wss4j.dom.message.token.X509Security;
import org.apache.wss4j.policy.model.Layout;
import org.w3c.dom.Element;

public class LayoutPolicyValidator {
    private List<WSSecurityEngineResult> results;
    private List<WSSecurityEngineResult> signedResults;

    public LayoutPolicyValidator(List<WSSecurityEngineResult> results, List<WSSecurityEngineResult> signedResults) {
        this.results = results;
        this.signedResults = signedResults;
    }

    public boolean validatePolicy(Layout layout) {
        boolean strict;
        boolean timestampFirst = layout.getLayoutType() == Layout.LayoutType.LaxTsFirst;
        boolean timestampLast = layout.getLayoutType() == Layout.LayoutType.LaxTsLast;
        boolean bl = strict = layout.getLayoutType() == Layout.LayoutType.Strict;
        if (timestampFirst) {
            if (this.results.isEmpty()) {
                return false;
            }
            Integer firstAction = (Integer)this.results.get(this.results.size() - 1).get((Object)"action");
            if (firstAction != 32) {
                return false;
            }
        } else if (timestampLast) {
            if (this.results.isEmpty()) {
                return false;
            }
            Integer lastAction = (Integer)this.results.get(0).get((Object)"action");
            if (lastAction != 32) {
                return false;
            }
        } else if (!(!strict || this.validateStrictSignaturePlacement() && this.validateStrictSignatureTokenPlacement() && this.checkSignatureIsSignedPlacement())) {
            return false;
        }
        return true;
    }

    private boolean validateStrictSignaturePlacement() {
        for (WSSecurityEngineResult signedResult : this.signedResults) {
            List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (sl == null) continue;
            block1: for (WSDataRef r : sl) {
                String[] nodes;
                String xpath = r.getXpath();
                if (xpath == null || (nodes = StringUtils.split((String)xpath, (String)"/")).length != 5) continue;
                Element protectedElement = r.getProtectedElement();
                boolean tokenFound = false;
                for (WSSecurityEngineResult result : this.results) {
                    Element resultElement = (Element)result.get((Object)"token-element");
                    if (resultElement == protectedElement) {
                        tokenFound = true;
                    }
                    if (tokenFound && result == signedResult) {
                        return false;
                    }
                    if (resultElement == null || result != signedResult) continue;
                    continue block1;
                }
            }
        }
        return true;
    }

    private boolean validateStrictSignatureTokenPlacement() {
        for (int i = 0; i < this.results.size(); ++i) {
            int correspondingIndex;
            WSSecurityEngineResult result = this.results.get(i);
            Integer actInt = (Integer)result.get((Object)"action");
            if (actInt != 2 || (correspondingIndex = this.findCorrespondingTokenIndex(result)) <= 0 || correspondingIndex >= i) continue;
            return false;
        }
        return true;
    }

    private boolean checkSignatureIsSignedPlacement() {
        for (int i = 0; i < this.signedResults.size(); ++i) {
            WSSecurityEngineResult signedResult = this.signedResults.get(i);
            List sl = CastUtils.cast((List)((List)signedResult.get((Object)"data-ref-uris")));
            if (sl == null || sl.size() < 1) continue;
            block1: for (WSDataRef dataRef : sl) {
                QName signedQName = dataRef.getName();
                if (!WSSecurityEngine.SIGNATURE.equals(signedQName)) continue;
                Element protectedElement = dataRef.getProtectedElement();
                boolean endorsingSigFound = false;
                for (WSSecurityEngineResult result : this.signedResults) {
                    Element resultElement;
                    if (result == signedResult) {
                        endorsingSigFound = true;
                    }
                    if ((resultElement = (Element)result.get((Object)"token-element")) != protectedElement) continue;
                    if (endorsingSigFound) continue block1;
                    return false;
                }
            }
        }
        return true;
    }

    private int findCorrespondingTokenIndex(WSSecurityEngineResult signatureResult) {
        X509Certificate cert = (X509Certificate)signatureResult.get((Object)"x509-certificate");
        PublicKey publicKey = (PublicKey)signatureResult.get((Object)"public-key");
        for (int i = 0; i < this.results.size(); ++i) {
            WSSecurityEngineResult token = this.results.get(i);
            Integer actInt = (Integer)token.get((Object)"action");
            if (actInt == 2) continue;
            BinarySecurity binarySecurity = (BinarySecurity)token.get((Object)"binary-security-token");
            PublicKey foundPublicKey = (PublicKey)token.get((Object)"public-key");
            if (binarySecurity instanceof X509Security || binarySecurity instanceof PKIPathSecurity) {
                X509Certificate foundCert = (X509Certificate)token.get((Object)"x509-certificate");
                if (!foundCert.equals(cert)) continue;
                return i;
            }
            if (actInt == 16 || actInt == 8) {
                SamlAssertionWrapper assertionWrapper = (SamlAssertionWrapper)token.get((Object)"saml-assertion");
                SAMLKeyInfo samlKeyInfo = assertionWrapper.getSubjectKeyInfo();
                if (samlKeyInfo == null) continue;
                X509Certificate[] subjectCerts = samlKeyInfo.getCerts();
                PublicKey subjectPublicKey = samlKeyInfo.getPublicKey();
                if ((cert == null || subjectCerts == null || !cert.equals(subjectCerts[0])) && (subjectPublicKey == null || !subjectPublicKey.equals(publicKey))) continue;
                return i;
            }
            if (publicKey == null || !publicKey.equals(foundPublicKey)) continue;
            return i;
        }
        return -1;
    }
}

