/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.OutputStream;
import java.security.Provider;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.AttachmentOutInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.LoggingOutInterceptor;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JStaxInterceptor;
import org.apache.cxf.ws.security.wss4j.AttachmentCallbackHandler;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.WSSPolicyException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.ThreadLocalSecurityProvider;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.stax.ConfigurationConverter;
import org.apache.wss4j.stax.WSSec;
import org.apache.wss4j.stax.ext.OutboundWSSec;
import org.apache.wss4j.stax.ext.WSSSecurityProperties;
import org.apache.wss4j.stax.securityEvent.WSSecurityEventConstants;
import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.stax.ext.OutboundSecurityContext;
import org.apache.xml.security.stax.impl.OutboundSecurityContextImpl;
import org.apache.xml.security.stax.securityEvent.SecurityEvent;
import org.apache.xml.security.stax.securityEvent.SecurityEventListener;
import org.apache.xml.security.stax.securityEvent.TokenSecurityEvent;

public class WSS4JStaxOutInterceptor
extends AbstractWSS4JStaxInterceptor {
    public static final String OUTPUT_STREAM_HOLDER = WSS4JStaxOutInterceptor.class.getName() + ".outputstream";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JStaxOutInterceptor.class);
    private WSS4JStaxOutInterceptorInternal ending;
    private boolean mtomEnabled;

    public WSS4JStaxOutInterceptor(WSSSecurityProperties securityProperties) {
        super(securityProperties);
        WSSec.init();
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public WSS4JStaxOutInterceptor(Map<String, Object> props) {
        super(props);
        WSSec.init();
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.getAfter().add(LoggingOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public WSS4JStaxOutInterceptor() {
        WSSec.init();
        this.setPhase("pre-stream");
        this.getBefore().add(StaxOutInterceptor.class.getName());
        this.getAfter().add(LoggingOutInterceptor.class.getName());
        this.ending = this.createEndingInterceptor();
    }

    public boolean isAllowMTOM() {
        return this.mtomEnabled;
    }

    public void setAllowMTOM(boolean allowMTOM) {
        this.mtomEnabled = allowMTOM;
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        return super.getProperty(msgContext, key);
    }

    protected void handleSecureMTOM(SoapMessage mc, WSSSecurityProperties secProps) {
        if (this.mtomEnabled) {
            return;
        }
        String mtomKey = "mtom-enabled";
        if (mc.get((Object)mtomKey) == Boolean.TRUE) {
            LOG.warning("MTOM will be disabled as the WSS4JOutInterceptor.mtomEnabled property is set to false");
        }
        mc.put(mtomKey, (Object)Boolean.FALSE);
    }

    public void handleMessage(SoapMessage mc) throws Fault {
        XMLStreamWriter newXMLStreamWriter;
        OutputStream os = (OutputStream)mc.getContent(OutputStream.class);
        String encoding = this.getEncoding((Message)mc);
        try {
            WSSSecurityProperties secProps = this.createSecurityProperties();
            this.translateProperties(mc, secProps);
            this.configureCallbackHandler(mc, secProps);
            OutboundSecurityContextImpl outboundSecurityContext = new OutboundSecurityContextImpl();
            this.configureProperties(mc, (OutboundSecurityContext)outboundSecurityContext, secProps);
            if (secProps.getActions() == null || secProps.getActions().size() == 0) {
                return;
            }
            this.handleSecureMTOM(mc, secProps);
            if (secProps.getAttachmentCallbackHandler() == null) {
                secProps.setAttachmentCallbackHandler((CallbackHandler)new AttachmentCallbackHandler(mc));
            }
            SecurityEventListener securityEventListener = this.configureSecurityEventListener(mc, secProps);
            OutboundWSSec outboundWSSec = WSSec.getOutboundWSSec((WSSSecurityProperties)secProps);
            List requestSecurityEvents = (List)mc.getExchange().get((Object)(SecurityEvent.class.getName() + ".in"));
            outboundSecurityContext.putList(SecurityEvent.class, requestSecurityEvents);
            outboundSecurityContext.addSecurityEventListener(securityEventListener);
            newXMLStreamWriter = outboundWSSec.processOutMessage((Object)os, encoding, (OutboundSecurityContext)outboundSecurityContext);
            mc.setContent(XMLStreamWriter.class, (Object)newXMLStreamWriter);
        }
        catch (WSSecurityException e) {
            throw new Fault((Throwable)e);
        }
        catch (WSSPolicyException e) {
            throw new Fault((Throwable)e);
        }
        mc.put("disable.outputstream.optimization", (Object)Boolean.TRUE);
        try {
            newXMLStreamWriter.writeStartDocument(encoding, "1.0");
        }
        catch (XMLStreamException e) {
            throw new Fault((Throwable)e);
        }
        mc.removeContent(OutputStream.class);
        mc.put(OUTPUT_STREAM_HOLDER, (Object)os);
        mc.getInterceptorChain().add((Interceptor)this.ending);
    }

    protected SecurityEventListener configureSecurityEventListener(final SoapMessage msg, WSSSecurityProperties securityProperties) throws WSSPolicyException {
        final LinkedList outgoingSecurityEventList = new LinkedList();
        msg.getExchange().put((Object)(SecurityEvent.class.getName() + ".out"), outgoingSecurityEventList);
        msg.put(SecurityEvent.class.getName() + ".out", outgoingSecurityEventList);
        SecurityEventListener securityEventListener = new SecurityEventListener(){

            public void registerSecurityEvent(SecurityEvent securityEvent) throws XMLSecurityException {
                if (securityEvent.getSecurityEventType() == WSSecurityEventConstants.SamlToken) {
                    TokenSecurityEvent tokenSecurityEvent = (TokenSecurityEvent)securityEvent;
                    WSS4JUtils.parseAndStoreStreamingSecurityToken(tokenSecurityEvent.getSecurityToken(), (Message)msg);
                } else if (securityEvent.getSecurityEventType() == WSSecurityEventConstants.SignatureValue) {
                    outgoingSecurityEventList.add(securityEvent);
                }
            }
        };
        return securityEventListener;
    }

    protected void configureProperties(SoapMessage msg, OutboundSecurityContext outboundSecurityContext, WSSSecurityProperties securityProperties) throws WSSecurityException {
        Map<String, Object> config;
        String encUser;
        String sigUser;
        String user = (String)msg.getContextualProperty("ws-security.username");
        if (user != null) {
            securityProperties.setTokenUser(user);
        }
        if ((sigUser = (String)msg.getContextualProperty("ws-security.signature.username")) != null) {
            securityProperties.setSignatureUser(sigUser);
        }
        if ((encUser = (String)msg.getContextualProperty("ws-security.encryption.username")) != null) {
            securityProperties.setEncryptionUser(encUser);
        }
        if ((config = this.getProperties()) != null && !config.isEmpty()) {
            Crypto encCrypto;
            Crypto sigCrypto = this.loadCrypto(msg, "signaturePropFile", "signaturePropRefId", securityProperties);
            if (sigCrypto != null) {
                config.put("signaturePropRefId", "RefId-" + sigCrypto.hashCode());
                config.put("RefId-" + sigCrypto.hashCode(), sigCrypto);
                if (sigUser == null && sigCrypto.getDefaultX509Identifier() != null) {
                    securityProperties.setSignatureUser(sigCrypto.getDefaultX509Identifier());
                }
            }
            if ((encCrypto = this.loadCrypto(msg, "encryptionPropFile", "encryptionPropRefId", securityProperties)) != null) {
                config.put("encryptionPropRefId", "RefId-" + encCrypto.hashCode());
                config.put("RefId-" + encCrypto.hashCode(), encCrypto);
                if (encUser == null && encCrypto.getDefaultX509Identifier() != null) {
                    securityProperties.setEncryptionUser(encCrypto.getDefaultX509Identifier());
                }
            }
            ConfigurationConverter.parseCrypto(config, (WSSSecurityProperties)securityProperties);
        } else {
            Crypto encrCrypto;
            Crypto sigCrypto = securityProperties.getSignatureCrypto();
            if (sigCrypto != null && sigUser == null && sigCrypto.getDefaultX509Identifier() != null) {
                securityProperties.setSignatureUser(sigCrypto.getDefaultX509Identifier());
            }
            if ((encrCrypto = securityProperties.getEncryptionCrypto()) != null && encUser == null && encrCrypto.getDefaultX509Identifier() != null) {
                securityProperties.setEncryptionUser(encrCrypto.getDefaultX509Identifier());
            }
        }
        if (securityProperties.getSignatureUser() == null && user != null) {
            securityProperties.setSignatureUser(user);
        }
        if (securityProperties.getEncryptionUser() == null && user != null) {
            securityProperties.setEncryptionUser(user);
        }
    }

    public final WSS4JStaxOutInterceptorInternal createEndingInterceptor() {
        return new WSS4JStaxOutInterceptorInternal();
    }

    private String getEncoding(Message message) {
        Exchange ex = message.getExchange();
        String encoding = (String)message.get((Object)Message.ENCODING);
        if (encoding == null && ex.getInMessage() != null) {
            encoding = (String)ex.getInMessage().get((Object)Message.ENCODING);
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        if (encoding == null) {
            encoding = "UTF-8";
            message.put((Object)Message.ENCODING, (Object)encoding);
        }
        return encoding;
    }

    final class WSS4JStaxOutInterceptorInternal
    extends AbstractPhaseInterceptor<Message> {
        public WSS4JStaxOutInterceptorInternal() {
            super("pre-stream-ending");
            this.getBefore().add(AttachmentOutInterceptor.AttachmentOutEndingInterceptor.class.getName());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message message) throws Fault {
            Object provider = message.getExchange().get(Provider.class);
            boolean useCustomProvider = provider != null && ThreadLocalSecurityProvider.isInstalled();
            try {
                if (useCustomProvider) {
                    ThreadLocalSecurityProvider.setProvider((Provider)((Provider)provider));
                }
                this.handleMessageInternal(message);
            }
            finally {
                if (useCustomProvider) {
                    ThreadLocalSecurityProvider.unsetProvider();
                }
            }
        }

        private void handleMessageInternal(Message mc) throws Fault {
            try {
                OutputStream os;
                XMLStreamWriter xtw = (XMLStreamWriter)mc.getContent(XMLStreamWriter.class);
                if (xtw != null) {
                    xtw.writeEndDocument();
                    xtw.flush();
                    xtw.close();
                }
                if ((os = (OutputStream)mc.get((Object)OUTPUT_STREAM_HOLDER)) != null) {
                    mc.setContent(OutputStream.class, (Object)os);
                }
                mc.removeContent(XMLStreamWriter.class);
            }
            catch (XMLStreamException e) {
                throw new Fault((Throwable)e);
            }
        }
    }
}

