/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.headers.Header;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.security.DefaultSecurityContext;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.wss4j.AbstractTokenInterceptor;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.WSSConfig;
import org.apache.wss4j.dom.WSSecurityEngine;
import org.apache.wss4j.dom.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.processor.SAMLTokenProcessor;
import org.apache.wss4j.dom.saml.DOMSAMLUtil;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.wss4j.policy.model.AbstractToken;
import org.apache.wss4j.policy.model.SamlToken;
import org.opensaml.common.SAMLVersion;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlTokenInterceptor
extends AbstractTokenInterceptor {
    @Override
    protected void processToken(SoapMessage message) {
        Header h = this.findSecurityHeader(message, false);
        if (h == null) {
            return;
        }
        Element el = (Element)h.getObject();
        Element child = DOMUtils.getFirstElement((Node)el);
        while (child != null) {
            if ("Assertion".equals(child.getLocalName()) && ("urn:oasis:names:tc:SAML:1.0:assertion".equals(child.getNamespaceURI()) || "urn:oasis:names:tc:SAML:2.0:assertion".equals(child.getNamespaceURI()))) {
                try {
                    List<WSSecurityEngineResult> samlResults = this.processToken(child, message);
                    if (samlResults != null) {
                        ArrayList<WSHandlerResult> results = CastUtils.cast((List)((List)message.get((Object)"RECV_RESULTS")));
                        if (results == null) {
                            results = new ArrayList<WSHandlerResult>();
                            message.put("RECV_RESULTS", results);
                        }
                        WSHandlerResult rResult = new WSHandlerResult(null, samlResults);
                        results.add(0, rResult);
                        boolean signed = false;
                        for (WSSecurityEngineResult result : samlResults) {
                            SamlAssertionWrapper wrapper = (SamlAssertionWrapper)result.get((Object)"saml-assertion");
                            if (!wrapper.isSigned()) continue;
                            signed = true;
                            break;
                        }
                        this.assertTokens(message, "SamlToken", signed);
                        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
                        for (AssertionInfo ai : this.getAllAssertionsByLocalname(aim, "SamlToken")) {
                            SamlToken samlToken = (SamlToken)ai.getAssertion();
                            for (WSSecurityEngineResult result : samlResults) {
                                SamlAssertionWrapper assertionWrapper = (SamlAssertionWrapper)result.get((Object)"saml-assertion");
                                if (!this.checkVersion(aim, samlToken, assertionWrapper)) {
                                    ai.setNotAsserted("Wrong SAML Version");
                                }
                                TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
                                Certificate[] tlsCerts = null;
                                if (tlsInfo != null) {
                                    tlsCerts = tlsInfo.getPeerCertificates();
                                }
                                if (!DOMSAMLUtil.checkHolderOfKey((SamlAssertionWrapper)assertionWrapper, null, (Certificate[])tlsCerts)) {
                                    ai.setNotAsserted("Assertion fails holder-of-key requirements");
                                    continue;
                                }
                                if (DOMSAMLUtil.checkSenderVouches((SamlAssertionWrapper)assertionWrapper, (Certificate[])tlsCerts, null, null)) continue;
                                ai.setNotAsserted("Assertion fails sender-vouches requirements");
                            }
                        }
                        if (signed) {
                            Principal principal = (Principal)samlResults.get(0).get((Object)"principal");
                            message.put("wss4j.principal.result", (Object)principal);
                            SecurityContext sc = (SecurityContext)message.get(SecurityContext.class);
                            if (sc == null || sc.getUserPrincipal() == null) {
                                message.put(SecurityContext.class, (Object)new DefaultSecurityContext(principal, null));
                            }
                        }
                    }
                }
                catch (WSSecurityException ex) {
                    throw new Fault((Throwable)ex);
                }
            }
            child = DOMUtils.getNextElement((Element)child);
        }
    }

    private List<WSSecurityEngineResult> processToken(Element tokenElement, final SoapMessage message) throws WSSecurityException {
        WSDocInfo wsDocInfo = new WSDocInfo(tokenElement.getOwnerDocument());
        RequestData data = new RequestData(){

            public CallbackHandler getCallbackHandler() {
                return SamlTokenInterceptor.this.getCallback(message);
            }

            public Validator getValidator(QName qName) throws WSSecurityException {
                String key = null;
                if (WSSecurityEngine.SAML_TOKEN.equals(qName)) {
                    key = "ws-security.saml1.validator";
                } else if (WSSecurityEngine.SAML2_TOKEN.equals(qName)) {
                    key = "ws-security.saml2.validator";
                }
                if (key != null) {
                    Object o = message.getContextualProperty(key);
                    try {
                        if (o instanceof Validator) {
                            return (Validator)o;
                        }
                        if (o instanceof Class) {
                            return (Validator)((Class)o).newInstance();
                        }
                        if (o instanceof String) {
                            return (Validator)ClassLoaderUtils.loadClass((String)o.toString(), SamlTokenInterceptor.class).newInstance();
                        }
                    }
                    catch (RuntimeException t) {
                        throw t;
                    }
                    catch (Exception ex) {
                        throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
                    }
                }
                return super.getValidator(qName);
            }
        };
        data.setWssConfig(WSSConfig.getNewInstance());
        data.setSigVerCrypto(this.getCrypto(null, "ws-security.signature.crypto", "ws-security.signature.properties", message));
        SAMLTokenProcessor p = new SAMLTokenProcessor();
        List results = p.handleToken(tokenElement, data, wsDocInfo);
        return results;
    }

    @Override
    protected AbstractToken assertTokens(SoapMessage message) {
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        this.assertPolicy(aim, "WssSamlV11Token10");
        this.assertPolicy(aim, "WssSamlV11Token11");
        this.assertPolicy(aim, "WssSamlV20Token11");
        return this.assertTokens(message, "SamlToken", true);
    }

    @Override
    protected void addToken(SoapMessage message) {
        WSSConfig.init();
        SamlToken tok = (SamlToken)this.assertTokens(message);
        Header h = this.findSecurityHeader(message, true);
        try {
            SamlAssertionWrapper wrapper = this.addSamlToken(tok, message);
            if (wrapper == null) {
                AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
                Collection<AssertionInfo> ais = this.getAllAssertionsByLocalname(aim, "SamlToken");
                for (AssertionInfo ai : ais) {
                    if (!ai.isAsserted()) continue;
                    ai.setAsserted(false);
                }
                return;
            }
            Element el = (Element)h.getObject();
            el.appendChild(wrapper.toDOM(el.getOwnerDocument()));
        }
        catch (WSSecurityException ex) {
            this.policyNotAsserted((AbstractToken)tok, ex.getMessage(), message);
        }
    }

    private SamlAssertionWrapper addSamlToken(SamlToken token, SoapMessage message) throws WSSecurityException {
        Object o = message.getContextualProperty("ws-security.saml-callback-handler");
        CallbackHandler handler = null;
        if (o instanceof CallbackHandler) {
            handler = (CallbackHandler)o;
        } else if (o instanceof String) {
            try {
                handler = (CallbackHandler)ClassLoaderUtils.loadClass((String)((String)o), ((Object)((Object)this)).getClass()).newInstance();
            }
            catch (Exception e) {
                handler = null;
            }
        }
        if (handler == null) {
            return null;
        }
        AssertionInfoMap aim = (AssertionInfoMap)message.get(AssertionInfoMap.class);
        SAMLCallback samlCallback = new SAMLCallback();
        SamlToken.SamlTokenType tokenType = token.getSamlTokenType();
        if (tokenType == SamlToken.SamlTokenType.WssSamlV11Token10 || tokenType == SamlToken.SamlTokenType.WssSamlV11Token11) {
            samlCallback.setSamlVersion(SAMLVersion.VERSION_11);
            this.assertPolicy(aim, "WssSamlV11Token10");
            this.assertPolicy(aim, "WssSamlV11Token11");
        } else if (tokenType == SamlToken.SamlTokenType.WssSamlV20Token11) {
            samlCallback.setSamlVersion(SAMLVersion.VERSION_20);
            this.assertPolicy(aim, "WssSamlV20Token11");
        }
        SAMLUtil.doSAMLCallback((CallbackHandler)handler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper assertion = new SamlAssertionWrapper(samlCallback);
        if (samlCallback.isSignAssertion()) {
            Crypto crypto;
            String password;
            String issuerName = samlCallback.getIssuerKeyName();
            if (issuerName == null) {
                String userNameKey = "ws-security.signature.username";
                issuerName = (String)message.getContextualProperty(userNameKey);
            }
            if ((password = samlCallback.getIssuerKeyPassword()) == null && StringUtils.isEmpty((String)(password = (String)message.getContextualProperty("ws-security.password")))) {
                password = this.getPassword(issuerName, (AbstractToken)token, 3, message);
            }
            if ((crypto = samlCallback.getIssuerCrypto()) == null) {
                crypto = this.getCrypto(token, "ws-security.signature.crypto", "ws-security.signature.properties", message);
            }
            assertion.signAssertion(issuerName, password, crypto, samlCallback.isSendKeyValue(), samlCallback.getCanonicalizationAlgorithm(), samlCallback.getSignatureAlgorithm());
        }
        return assertion;
    }

    private Crypto getCrypto(SamlToken samlToken, String cryptoKey, String propKey, SoapMessage message) throws WSSecurityException {
        Properties properties;
        Crypto crypto;
        block19: {
            crypto = (Crypto)message.getContextualProperty(cryptoKey);
            if (crypto != null) {
                return crypto;
            }
            Object o = message.getContextualProperty(propKey);
            if (o == null) {
                return null;
            }
            properties = null;
            if (o instanceof Properties) {
                properties = (Properties)o;
            } else {
                if (o instanceof String) {
                    ResourceManager rm = (ResourceManager)((Bus)message.getExchange().get(Bus.class)).getExtension(ResourceManager.class);
                    URL url = (URL)rm.resolveResource((String)o, URL.class);
                    try {
                        if (url == null) {
                            url = ClassLoaderUtils.getResource((String)((String)o), ((Object)((Object)this)).getClass());
                        }
                        if (url == null) {
                            try {
                                url = new URL((String)o);
                            }
                            catch (Exception ex) {
                                // empty catch block
                            }
                        }
                        if (url != null) {
                            InputStream ins = url.openStream();
                            properties = new Properties();
                            properties.load(ins);
                            ins.close();
                        } else if (samlToken != null) {
                            this.policyNotAsserted((AbstractToken)samlToken, "Could not find properties file " + o, message);
                        }
                        break block19;
                    }
                    catch (IOException e) {
                        if (samlToken != null) {
                            this.policyNotAsserted((AbstractToken)samlToken, e.getMessage(), message);
                        }
                        break block19;
                    }
                }
                if (o instanceof URL) {
                    properties = new Properties();
                    try {
                        InputStream ins = ((URL)o).openStream();
                        properties.load(ins);
                        ins.close();
                    }
                    catch (IOException e) {
                        if (samlToken == null) break block19;
                        this.policyNotAsserted((AbstractToken)samlToken, e.getMessage(), message);
                    }
                }
            }
        }
        if (properties != null) {
            crypto = CryptoFactory.getInstance((Properties)properties);
        }
        return crypto;
    }

    private boolean checkVersion(AssertionInfoMap aim, SamlToken samlToken, SamlAssertionWrapper assertionWrapper) {
        SamlToken.SamlTokenType tokenType = samlToken.getSamlTokenType();
        if ((tokenType == SamlToken.SamlTokenType.WssSamlV11Token10 || tokenType == SamlToken.SamlTokenType.WssSamlV11Token11) && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_11) {
            return false;
        }
        if (tokenType == SamlToken.SamlTokenType.WssSamlV20Token11 && assertionWrapper.getSamlVersion() != SAMLVersion.VERSION_20) {
            return false;
        }
        this.assertPolicy(aim, new QName(samlToken.getVersion().getNamespace(), tokenType.name()));
        return true;
    }
}

