/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j;

import java.security.Provider;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.saaj.SAAJInInterceptor;
import org.apache.cxf.binding.soap.saaj.SAAJUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.security.tokenstore.TokenStore;
import org.apache.cxf.ws.security.tokenstore.TokenStoreUtils;
import org.apache.cxf.ws.security.wss4j.AbstractWSS4JInterceptor;
import org.apache.cxf.ws.security.wss4j.AttachmentCallbackHandler;
import org.apache.cxf.ws.security.wss4j.CXFCallbackLookup;
import org.apache.cxf.ws.security.wss4j.CXFRequestData;
import org.apache.cxf.ws.security.wss4j.DefaultWSS4JSecurityContextCreator;
import org.apache.cxf.ws.security.wss4j.DelegatingCallbackHandler;
import org.apache.cxf.ws.security.wss4j.StaxSerializer;
import org.apache.cxf.ws.security.wss4j.TokenStoreCallbackHandler;
import org.apache.cxf.ws.security.wss4j.WSS4JSecurityContextCreator;
import org.apache.cxf.ws.security.wss4j.WSS4JUtils;
import org.apache.wss4j.common.cache.ReplayCache;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.ThreadLocalSecurityProvider;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.callback.CallbackLookup;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.processor.Processor;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.wss4j.dom.validate.NoOpValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.apache.xml.security.encryption.Serializer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSS4JInInterceptor
extends AbstractWSS4JInterceptor {
    public static final String SAML_ROLE_ATTRIBUTENAME_DEFAULT = "http://schemas.xmlsoap.org/ws/2005/05/identity/claims/role";
    public static final String PROCESSOR_MAP = "wss4j.processor.map";
    public static final String VALIDATOR_MAP = "wss4j.validator.map";
    public static final String SECURITY_PROCESSED = WSS4JInInterceptor.class.getName() + ".DONE";
    private static final Logger LOG = LogUtils.getL7dLogger(WSS4JInInterceptor.class);
    private boolean ignoreActions;
    private WSSecurityEngine secEngineOverride;

    public WSS4JInInterceptor() {
        this.setPhase("pre-protocol");
        this.getAfter().add(SAAJInInterceptor.class.getName());
        this.getAfter().add("org.apache.cxf.ws.addressing.soap.MAPCodec");
    }

    public WSS4JInInterceptor(boolean ignore) {
        this();
        this.ignoreActions = ignore;
    }

    public WSS4JInInterceptor(Map<String, Object> properties) {
        this();
        this.setProperties(properties);
        Map processorMap = CastUtils.cast((Map)((Map)properties.get(PROCESSOR_MAP)));
        Map validatorMap = CastUtils.cast((Map)((Map)properties.get(VALIDATOR_MAP)));
        if (processorMap != null) {
            if (validatorMap != null) {
                processorMap.putAll(validatorMap);
            }
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(processorMap);
        } else if (validatorMap != null) {
            this.secEngineOverride = WSS4JInInterceptor.createSecurityEngine(validatorMap);
        }
    }

    public void setIgnoreActions(boolean i) {
        this.ignoreActions = i;
    }

    private SOAPMessage getSOAPMessage(SoapMessage msg) {
        SAAJInInterceptor.INSTANCE.handleMessage(msg);
        return (SOAPMessage)msg.getContent(SOAPMessage.class);
    }

    @Override
    public Object getProperty(Object msgContext, String key) {
        Object result = super.getProperty(msgContext, key);
        if (result == null && "_sendSignatureValues_".equals(key) && this.isRequestor((SoapMessage)msgContext)) {
            result = ((SoapMessage)msgContext).getExchange().getOutMessage().get((Object)key);
        }
        return result;
    }

    public final boolean isGET(SoapMessage message) {
        String method = (String)message.get((Object)"org.apache.cxf.request.method");
        boolean isGet = "GET".equals(method) && message.getContent(XMLStreamReader.class) == null;
        return isGet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(SoapMessage msg) throws Fault {
        if (msg.containsKey((Object)SECURITY_PROCESSED) || this.isGET(msg)) {
            return;
        }
        Object provider = msg.getExchange().get(Provider.class);
        boolean useCustomProvider = provider != null && ThreadLocalSecurityProvider.isInstalled();
        try {
            if (useCustomProvider) {
                ThreadLocalSecurityProvider.setProvider((Provider)((Provider)provider));
            }
            this.handleMessageInternal(msg);
        }
        finally {
            if (useCustomProvider) {
                ThreadLocalSecurityProvider.unsetProvider();
            }
        }
    }

    private void handleMessageInternal(SoapMessage msg) throws Fault {
        WSSecurityEngine engine;
        boolean utWithCallbacks = MessageUtils.getContextualBoolean((Message)msg, (String)"ws-security.validate.token", (boolean)true);
        this.translateProperties(msg);
        CXFRequestData reqData = new CXFRequestData();
        WSSConfig config = (WSSConfig)msg.getContextualProperty(WSSConfig.class.getName());
        if (config != null) {
            engine = new WSSecurityEngine();
            engine.setWssConfig(config);
        } else {
            engine = this.getSecurityEngine(utWithCallbacks);
            if (engine == null) {
                engine = new WSSecurityEngine();
            }
            config = engine.getWssConfig();
        }
        reqData.setWssConfig(config);
        reqData.setEncryptionSerializer((Serializer)new StaxSerializer());
        this.configureAudienceRestriction(msg, reqData);
        SOAPMessage doc = this.getSOAPMessage(msg);
        boolean doDebug = LOG.isLoggable(Level.FINE);
        SoapVersion version = msg.getVersion();
        if (doDebug) {
            LOG.fine("WSS4JInInterceptor: enter handleMessage()");
        }
        try {
            Element elem;
            WSHandlerResult wsResult;
            reqData.setMsgContext(msg);
            reqData.setAttachmentCallbackHandler(new AttachmentCallbackHandler(msg));
            this.setAlgorithmSuites(msg, reqData);
            reqData.setCallbackHandler(this.getCallback(reqData, utWithCallbacks));
            this.computeAction(msg, reqData);
            String action = this.getAction(msg, version);
            List actions = WSSecurityUtil.decodeAction((String)action);
            String actor = (String)this.getOption("actor");
            if (actor == null) {
                actor = (String)msg.getContextualProperty("ws-security.actor");
            }
            reqData.setActor(actor);
            this.configureReplayCaches(reqData, actions, msg);
            TLSSessionInfo tlsInfo = (TLSSessionInfo)msg.get(TLSSessionInfo.class);
            if (tlsInfo != null) {
                Certificate[] tlsCerts = tlsInfo.getPeerCertificates();
                reqData.setTlsCerts(tlsCerts);
            }
            this.doReceiverAction(actions, reqData);
            boolean enableRevocation = reqData.isRevocationEnabled() || MessageUtils.isTrue((Object)SecurityUtils.getSecurityPropertyValue((String)"security.enableRevocation", (Message)msg));
            reqData.setEnableRevocation(enableRevocation);
            SOAPBody soapBody = SAAJUtils.getBody((SOAPMessage)doc);
            if (soapBody != null) {
                engine.setCallbackLookup((CallbackLookup)new CXFCallbackLookup(soapBody.getOwnerDocument(), (Element)soapBody));
            }
            if ((wsResult = engine.processSecurityHeader(elem = WSSecurityUtil.getSecurityHeader((Element)doc.getSOAPHeader(), (String)actor, (version.getVersion() != 1.1 ? 1 : 0) != 0), (RequestData)reqData)).getResults() != null && !wsResult.getResults().isEmpty()) {
                if (reqData.isEnableSignatureConfirmation()) {
                    this.checkSignatureConfirmation(reqData, wsResult);
                }
                this.checkActions(msg, reqData, wsResult.getResults(), actions, (Element)SAAJUtils.getBody((SOAPMessage)doc));
                this.doResults(msg, actor, (Element)SAAJUtils.getHeader((SOAPMessage)doc), (Element)SAAJUtils.getBody((SOAPMessage)doc), wsResult, utWithCallbacks);
            } else if (doc.getSOAPPart().getEnvelope().getBody().hasFault() && this.isRequestor(msg)) {
                LOG.warning("The request is a SOAP Fault, but it is not secured");
                this.doResults(msg, actor, (Element)SAAJUtils.getHeader((SOAPMessage)doc), (Element)SAAJUtils.getBody((SOAPMessage)doc), wsResult, utWithCallbacks);
            } else {
                this.checkActions(msg, reqData, wsResult.getResults(), actions, (Element)SAAJUtils.getBody((SOAPMessage)doc));
                this.doResults(msg, actor, (Element)SAAJUtils.getHeader((SOAPMessage)doc), (Element)SAAJUtils.getBody((SOAPMessage)doc), wsResult, utWithCallbacks);
            }
            this.advanceBody(msg, (Node)SAAJUtils.getBody((SOAPMessage)doc));
            SAAJInInterceptor.replaceHeaders((SOAPMessage)doc, (SoapMessage)msg);
            if (doDebug) {
                LOG.fine("WSS4JInInterceptor: exit handleMessage()");
            }
            msg.put(SECURITY_PROCESSED, (Object)Boolean.TRUE);
        }
        catch (WSSecurityException e) {
            throw WSS4JUtils.createSoapFault(msg, version, e);
        }
        catch (XMLStreamException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("STAX_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        catch (SOAPException e) {
            throw new SoapFault(new org.apache.cxf.common.i18n.Message("SAAJ_EX", LOG, new Object[0]), (Throwable)e, version.getSender());
        }
        finally {
            reqData = null;
        }
    }

    private void configureAudienceRestriction(SoapMessage msg, RequestData reqData) {
        boolean enableAudienceRestriction = SecurityUtils.getSecurityPropertyBoolean((String)"security.validate.audience-restriction", (Message)msg, (boolean)true);
        if (enableAudienceRestriction) {
            ArrayList<String> audiences = new ArrayList<String>();
            if (msg.get((Object)"org.apache.cxf.request.url") != null) {
                audiences.add((String)msg.get((Object)"org.apache.cxf.request.url"));
            } else if (msg.get((Object)"org.apache.cxf.request.uri") != null) {
                audiences.add((String)msg.get((Object)"org.apache.cxf.request.uri"));
            }
            if (msg.getContextualProperty("javax.xml.ws.wsdl.service") != null) {
                audiences.add(msg.getContextualProperty("javax.xml.ws.wsdl.service").toString());
            }
            reqData.setAudienceRestrictions(audiences);
        }
    }

    private void checkActions(SoapMessage msg, RequestData reqData, List<WSSecurityEngineResult> wsResult, List<Integer> actions, Element body) throws WSSecurityException {
        if (this.ignoreActions) {
            return;
        }
        if (!this.checkReceiverResultsAnyOrder(wsResult, actions)) {
            LOG.warning("Security processing failed (actions mismatch)");
            throw new WSSecurityException(WSSecurityException.ErrorCode.INVALID_SECURITY);
        }
        String signatureParts = (String)this.getProperty(msg, "signatureParts");
        if (signatureParts != null) {
            String warning = "To enforce that particular elements were signed you must either use WS-SecurityPolicy, or else use the CryptoCoverageChecker or SignatureCoverageChecker";
            LOG.warning(warning);
        }
    }

    protected void computeAction(SoapMessage msg, RequestData reqData) throws WSSecurityException {
        Crypto sigCrypto;
        Crypto encCrypto = (Crypto)SecurityUtils.getSecurityPropertyValue((String)"security.encryption.crypto", (Message)msg);
        if (encCrypto != null) {
            reqData.setDecCrypto(encCrypto);
        }
        if ((sigCrypto = (Crypto)SecurityUtils.getSecurityPropertyValue((String)"security.signature.crypto", (Message)msg)) != null) {
            reqData.setSigVerCrypto(sigCrypto);
        }
    }

    protected void configureReplayCaches(RequestData reqData, List<Integer> actions, SoapMessage msg) throws WSSecurityException {
        reqData.setEnableNonceReplayCache(false);
        if (this.isNonceCacheRequired(actions, msg)) {
            ReplayCache nonceCache = this.getReplayCache(msg, "ws-security.enable.nonce.cache", "ws-security.nonce.cache.instance");
            reqData.setNonceReplayCache(nonceCache);
            if (nonceCache != null) {
                reqData.setEnableNonceReplayCache(true);
            }
        }
        reqData.setEnableTimestampReplayCache(false);
        if (this.isTimestampCacheRequired(actions, msg)) {
            ReplayCache timestampCache = this.getReplayCache(msg, "ws-security.enable.timestamp.cache", "ws-security.timestamp.cache.instance");
            reqData.setTimestampReplayCache(timestampCache);
            if (timestampCache != null) {
                reqData.setEnableTimestampReplayCache(true);
            }
        }
        reqData.setEnableSamlOneTimeUseReplayCache(false);
        if (this.isSamlCacheRequired(actions, msg)) {
            ReplayCache samlCache = this.getReplayCache(msg, "ws-security.enable.saml.cache", "ws-security.saml.cache.instance");
            reqData.setSamlOneTimeUseReplayCache(samlCache);
            if (samlCache != null) {
                reqData.setEnableSamlOneTimeUseReplayCache(true);
            }
        }
    }

    protected boolean isNonceCacheRequired(List<Integer> actions, SoapMessage msg) {
        return actions.contains(1) || actions.contains(8192);
    }

    protected boolean isTimestampCacheRequired(List<Integer> actions, SoapMessage msg) {
        return actions.contains(32);
    }

    protected boolean isSamlCacheRequired(List<Integer> actions, SoapMessage msg) {
        return actions.contains(8) || actions.contains(16);
    }

    protected void setAlgorithmSuites(SoapMessage message, RequestData data) throws WSSecurityException {
        super.decodeAlgorithmSuite(data);
    }

    protected void doResults(SoapMessage msg, String actor, Element soapHeader, Element soapBody, WSHandlerResult wsResult, boolean utWithCallbacks) throws SOAPException, XMLStreamException, WSSecurityException {
        LinkedList<WSHandlerResult> results = CastUtils.cast((List)((List)msg.get((Object)"RECV_RESULTS")));
        if (results == null) {
            results = new LinkedList<WSHandlerResult>();
            msg.put("RECV_RESULTS", results);
        }
        results.add(0, wsResult);
        WSS4JSecurityContextCreator contextCreator = (WSS4JSecurityContextCreator)SecurityUtils.getSecurityPropertyValue((String)"ws-security.security.context.creator", (Message)msg);
        if (contextCreator != null) {
            contextCreator.createSecurityContext(msg, wsResult);
        } else {
            new DefaultWSS4JSecurityContextCreator().createSecurityContext(msg, wsResult);
        }
    }

    protected void advanceBody(SoapMessage msg, Node body) throws SOAPException, XMLStreamException, WSSecurityException {
        XMLStreamReader reader = StaxUtils.createXMLStreamReader((Source)new DOMSource(body));
        int evt = reader.next();
        if (reader.hasNext() && (evt != 2 || evt != 1)) {
            reader.next();
        }
        msg.setContent(XMLStreamReader.class, (Object)reader);
    }

    private String getAction(SoapMessage msg, SoapVersion version) {
        String action = (String)this.getOption("action");
        if (action == null) {
            action = (String)msg.get((Object)"action");
        }
        if (action == null) {
            LOG.warning("No security action was defined!");
            throw new SoapFault("No security action was defined!", version.getReceiver());
        }
        return action;
    }

    protected CallbackHandler getCallback(RequestData reqData, boolean utWithCallbacks) throws WSSecurityException {
        if (!utWithCallbacks) {
            CallbackHandler pwdCallback = null;
            try {
                pwdCallback = this.getCallback(reqData);
            }
            catch (Exception ex) {
                // empty catch block
            }
            return new DelegatingCallbackHandler(pwdCallback);
        }
        return this.getCallback(reqData);
    }

    protected CallbackHandler getCallback(RequestData reqData) throws WSSecurityException {
        Endpoint ep;
        Object o = SecurityUtils.getSecurityPropertyValue((String)"security.callback-handler", (Message)((SoapMessage)reqData.getMsgContext()));
        CallbackHandler cbHandler = null;
        try {
            cbHandler = SecurityUtils.getCallbackHandler((Object)o);
        }
        catch (Exception ex) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, ex);
        }
        if (cbHandler == null) {
            try {
                cbHandler = this.getPasswordCallbackHandler(reqData);
            }
            catch (WSSecurityException sec) {
                Endpoint ep2 = ((SoapMessage)reqData.getMsgContext()).getExchange().getEndpoint();
                if (ep2 != null && ep2.getEndpointInfo() != null) {
                    TokenStore store = TokenStoreUtils.getTokenStore((Message)((SoapMessage)reqData.getMsgContext()));
                    return new TokenStoreCallbackHandler(null, store);
                }
                throw sec;
            }
        }
        if ((ep = ((SoapMessage)reqData.getMsgContext()).getExchange().getEndpoint()) != null && ep.getEndpointInfo() != null) {
            TokenStore store = TokenStoreUtils.getTokenStore((Message)((SoapMessage)reqData.getMsgContext()));
            return new TokenStoreCallbackHandler(cbHandler, store);
        }
        return cbHandler;
    }

    protected WSSecurityEngine getSecurityEngine(boolean utWithCallbacks) {
        if (this.secEngineOverride != null) {
            return this.secEngineOverride;
        }
        if (!utWithCallbacks) {
            HashMap<QName, Object> profiles = new HashMap<QName, Object>(1);
            NoOpValidator validator = new NoOpValidator();
            profiles.put(WSConstants.USERNAME_TOKEN, validator);
            return WSS4JInInterceptor.createSecurityEngine(profiles);
        }
        return null;
    }

    protected static WSSecurityEngine createSecurityEngine(Map<QName, Object> map) {
        assert (map != null);
        WSSConfig config = WSSConfig.getNewInstance();
        for (Map.Entry<QName, Object> entry : map.entrySet()) {
            QName key = entry.getKey();
            Object val = entry.getValue();
            if (val instanceof Class) {
                config.setProcessor(key, (Class)val);
                continue;
            }
            if (val instanceof Processor) {
                config.setProcessor(key, (Processor)val);
                continue;
            }
            if (val instanceof Validator) {
                config.setValidator(key, (Validator)val);
                continue;
            }
            if (val != null) continue;
            config.setProcessor(key, (Class)null);
        }
        WSSecurityEngine ret = new WSSecurityEngine();
        ret.setWssConfig(config);
        return ret;
    }

    protected ReplayCache getReplayCache(SoapMessage message, String booleanKey, String instanceKey) {
        return WSS4JUtils.getReplayCache(message, booleanKey, instanceKey);
    }
}

