/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.transfer.manager;

import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.ws.WebServiceContext;
import org.apache.cxf.binding.soap.SoapFault;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.jaxws.context.WrappedMessageContext;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.apache.cxf.ws.transfer.Representation;
import org.apache.cxf.ws.transfer.manager.ResourceManager;
import org.apache.cxf.ws.transfer.shared.faults.UnknownResource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MemoryResourceManager
implements ResourceManager {
    public static final String REF_NAMESPACE = "http://cxf.apache.org/rt/ws/transfer/MemoryResourceManager";
    public static final String REF_LOCAL_NAME = "uuid";
    private static final Logger LOG = LogUtils.getL7dLogger(MemoryResourceManager.class);
    protected Map<String, String> storage = new HashMap<String, String>();
    @Resource
    private WebServiceContext context;

    @Override
    public Representation get(ReferenceParametersType ref) {
        String uuid = this.getUUID(ref);
        if (!this.storage.containsKey(uuid)) {
            throw new UnknownResource();
        }
        String resource = this.storage.get(uuid);
        if (resource.isEmpty()) {
            return new Representation();
        }
        Document doc = null;
        try {
            doc = StaxUtils.read((Reader)new StringReader(this.storage.get(uuid)));
        }
        catch (XMLStreamException e) {
            LOG.severe(e.getLocalizedMessage());
            throw new SoapFault("Internal Error", this.getSoapVersion().getReceiver());
        }
        Representation representation = new Representation();
        representation.setAny(doc.getDocumentElement());
        return representation;
    }

    @Override
    public void delete(ReferenceParametersType ref) {
        String uuid = this.getUUID(ref);
        if (!this.storage.containsKey(uuid)) {
            throw new UnknownResource();
        }
        this.storage.remove(uuid);
    }

    @Override
    public void put(ReferenceParametersType ref, Representation newRepresentation) {
        String uuid = this.getUUID(ref);
        if (!this.storage.containsKey(uuid)) {
            throw new UnknownResource();
        }
        Element representationEl = (Element)newRepresentation.getAny();
        if (representationEl == null) {
            this.storage.put(uuid, "");
        } else {
            this.storage.put(uuid, StaxUtils.toString((Element)representationEl));
        }
    }

    @Override
    public ReferenceParametersType create(Representation initRepresentation) {
        String uuid = UUID.randomUUID().toString();
        Element representationEl = (Element)initRepresentation.getAny();
        if (representationEl == null) {
            this.storage.put(uuid, "");
        } else {
            this.storage.put(uuid, StaxUtils.toString((Element)representationEl));
        }
        Element uuidEl = DOMUtils.createDocument().createElementNS(REF_NAMESPACE, REF_LOCAL_NAME);
        uuidEl.setTextContent(uuid);
        ReferenceParametersType refParam = new ReferenceParametersType();
        refParam.getAny().add(uuidEl);
        return refParam;
    }

    private String getUUID(ReferenceParametersType ref) {
        for (Object object : ref.getAny()) {
            Object element;
            if (object instanceof JAXBElement) {
                element = (JAXBElement)object;
                QName qName = element.getName();
                if (!REF_NAMESPACE.equals(qName.getNamespaceURI()) || !REF_LOCAL_NAME.equals(qName.getLocalPart())) continue;
                return (String)element.getValue();
            }
            if (!(object instanceof Element) || !REF_NAMESPACE.equals((element = (Element)object).getNamespaceURI()) || !REF_LOCAL_NAME.equals(element.getLocalName())) continue;
            return element.getTextContent();
        }
        throw new UnknownResource();
    }

    private SoapVersion getSoapVersion() {
        WrappedMessageContext wmc = (WrappedMessageContext)this.context.getMessageContext();
        SoapMessage message = (SoapMessage)wmc.getWrappedMessage();
        return message.getVersion();
    }
}

