
package org.apache.type_test.types1;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;


/**
 * <p>Java class for NumberEnum.
 * 
 * <p>The following schema fragment specifies the expected content contained within this class.
 * <p>
 * <pre>
 * &lt;simpleType name="NumberEnum">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}int">
 *     &lt;enumeration value="1"/>
 *     &lt;enumeration value="2"/>
 *     &lt;enumeration value="3"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlEnum(Integer.class)
public enum NumberEnum {

    @XmlEnumValue("1")
    ONE(1),
    @XmlEnumValue("3")
    THREE(3),
    @XmlEnumValue("2")
    TWO(2);
    private final int value;

    NumberEnum(int v) {
        value = v;
    }

    public int value() {
        return value;
    }

    public static NumberEnum fromValue(int v) {
        for (NumberEnum c: NumberEnum.values()) {
            if (c.value == v) {
                return c;
            }
        }
        throw new IllegalArgumentException(String.valueOf(v));
    }

}
