/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.testutil.common.ServerLauncher;
import org.junit.AfterClass;
import org.junit.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClientServerTestBase
extends Assert {
    private static List<ServerLauncher> launchers = new ArrayList<ServerLauncher>();

    @AfterClass
    public static void stopAllServers() throws Exception {
        boolean passed = true;
        for (ServerLauncher sl : launchers) {
            try {
                sl.signalStop();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        for (ServerLauncher sl : launchers) {
            try {
                passed = passed && sl.stopServer();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        launchers.clear();
        System.gc();
        AbstractClientServerTestBase.assertTrue((String)"server failed", (boolean)passed);
    }

    public static boolean launchServer(Class<?> clz) {
        boolean ok = false;
        try {
            ServerLauncher sl = new ServerLauncher(clz.getName());
            ok = sl.launchServer();
            AbstractClientServerTestBase.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            AbstractClientServerTestBase.fail((String)("failed to launch server " + clz));
        }
        return ok;
    }

    public static boolean launchServer(Class<?> clz, boolean inProcess) {
        boolean ok = false;
        try {
            ServerLauncher sl = new ServerLauncher(clz.getName(), inProcess);
            ok = sl.launchServer();
            AbstractClientServerTestBase.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            AbstractClientServerTestBase.fail((String)("failed to launch server " + clz));
        }
        return ok;
    }

    public static boolean launchServer(Class<?> clz, Map<String, String> props, String[] args) {
        return AbstractClientServerTestBase.launchServer(clz, props, args, false);
    }

    public static boolean launchServer(Class<?> clz, Map<String, String> props, String[] args, boolean inProcess) {
        boolean ok = false;
        try {
            ServerLauncher sl = new ServerLauncher(clz.getName(), props, args, inProcess);
            ok = sl.launchServer();
            AbstractClientServerTestBase.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            AbstractClientServerTestBase.fail((String)("failed to launch server " + clz));
        }
        return ok;
    }
}

