/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hello_world_soap_http;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.logging.Logger;
import javax.annotation.Resource;
import javax.jws.WebMethod;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.Response;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.hello_world_soap_http.BadRecordLitFault;
import org.apache.hello_world_soap_http.Greeter;
import org.apache.hello_world_soap_http.GreeterImpl;
import org.apache.hello_world_soap_http.NoSuchCodeLitFault;
import org.apache.hello_world_soap_http.types.BareDocumentResponse;
import org.apache.hello_world_soap_http.types.ErrorCode;
import org.apache.hello_world_soap_http.types.GreetMeLaterResponse;
import org.apache.hello_world_soap_http.types.GreetMeResponse;
import org.apache.hello_world_soap_http.types.GreetMeSometimeResponse;
import org.apache.hello_world_soap_http.types.NoSuchCodeLit;
import org.apache.hello_world_soap_http.types.SayHiResponse;
import org.apache.hello_world_soap_http.types.TestDocLitFaultResponse;
import org.apache.hello_world_soap_http.types.TestNillableResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseGreeterImpl
implements Greeter {
    private static final Logger LOG = Logger.getLogger(GreeterImpl.class.getName());
    @Resource
    private WebServiceContext context;
    private String prefix = "";
    private int invocationCount;

    public WebServiceContext getContext() {
        return this.context;
    }

    public void setPrefix(String p) {
        this.prefix = p;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String greetMe(String me) {
        if ("secure".equals(me)) {
            MessageContext ctx = this.getContext().getMessageContext();
            return "Hello " + ctx.get((Object)"javax.xml.ws.security.auth.username");
        }
        if ("principal".equals(me)) {
            return "Hello " + this.getContext().getUserPrincipal().getName();
        }
        LOG.info("Invoking greetMe " + this.prefix + me);
        ++this.invocationCount;
        return "Hello " + me;
    }

    @Override
    public String greetMeLater(long delay) {
        LOG.info("Invoking greetMeLater " + delay);
        if (delay > 0L) {
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return "Hello, finally!";
    }

    @Override
    public String sayHi() {
        LOG.info("Invoking sayHi");
        ++this.invocationCount;
        return "Bonjour";
    }

    @Override
    public void testDocLitFault(String faultType) throws BadRecordLitFault, NoSuchCodeLitFault {
        LOG.info("Invoking testDocLitFault");
        ++this.invocationCount;
        if (faultType.equals(BadRecordLitFault.class.getSimpleName())) {
            throw new BadRecordLitFault("TestBadRecordLit", "BadRecordLitFault");
        }
        if (faultType.equals(NoSuchCodeLitFault.class.getSimpleName())) {
            ErrorCode ec = new ErrorCode();
            ec.setMajor((short)1);
            ec.setMinor((short)1);
            NoSuchCodeLit nscl = new NoSuchCodeLit();
            nscl.setCode(ec);
            throw new NoSuchCodeLitFault("TestNoSuchCodeLit", nscl);
        }
        throw new RuntimeException("Unknown source", new IOException("dummy io exception"));
    }

    @Override
    public void greetMeOneWay(String requestType) {
        ++this.invocationCount;
    }

    @Override
    public String greetMeSometime(String me) {
        ++this.invocationCount;
        return "How are you " + me;
    }

    @WebMethod
    public BareDocumentResponse testDocLitBare(String in) {
        ++this.invocationCount;
        BareDocumentResponse res = new BareDocumentResponse();
        res.setCompany("CXF");
        res.setId(1);
        return res;
    }

    @Override
    public Future<?> greetMeSometimeAsync(String requestType, AsyncHandler<GreetMeSometimeResponse> asyncHandler) {
        ++this.invocationCount;
        System.err.println("In greetMeSometimeAsync 1");
        return null;
    }

    @Override
    public Response<GreetMeSometimeResponse> greetMeSometimeAsync(String requestType) {
        ++this.invocationCount;
        System.err.println("In greetMeSometimeAsync 2");
        return null;
    }

    @Override
    public Response<TestDocLitFaultResponse> testDocLitFaultAsync(String faultType) {
        ++this.invocationCount;
        System.err.println("In testDocLitFaultAsync 1");
        return null;
    }

    public Future<?> testDocLitFaultAsync(String faultType, AsyncHandler ah) {
        ++this.invocationCount;
        System.err.println("In testDocLitFaultAsync 2");
        return null;
    }

    public Future<?> testDocLitBareAsync(String bare, AsyncHandler ah) {
        ++this.invocationCount;
        return null;
    }

    public Response<BareDocumentResponse> testDocLitBareAsync(String bare) {
        ++this.invocationCount;
        return null;
    }

    @Override
    public Future<?> greetMeAsync(String requestType, AsyncHandler<GreetMeResponse> asyncHandler) {
        ++this.invocationCount;
        return null;
    }

    @Override
    public Response<GreetMeResponse> greetMeAsync(String requestType) {
        ++this.invocationCount;
        return null;
    }

    @Override
    public Future<?> greetMeLaterAsync(long requestType, AsyncHandler<GreetMeLaterResponse> asyncHandler) {
        return null;
    }

    @Override
    public Response<GreetMeLaterResponse> greetMeLaterAsync(long requestType) {
        return null;
    }

    @Override
    public Future<?> sayHiAsync(AsyncHandler<SayHiResponse> asyncHandler) {
        ++this.invocationCount;
        return null;
    }

    @Override
    public Response<SayHiResponse> sayHiAsync() {
        ++this.invocationCount;
        return null;
    }

    public int getInvocationCount() {
        return this.invocationCount;
    }

    @Override
    public String testNillable(String nillElem, int intElem) {
        System.out.println("the testNillable is invoked");
        return nillElem;
    }

    @Override
    public Response<TestNillableResponse> testNillableAsync(String nillElem, int intElem) {
        return null;
    }

    @Override
    public Future<?> testNillableAsync(String nillElem, int intElem, AsyncHandler<TestNillableResponse> asyncHandler) {
        return null;
    }
}

