/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Properties;
import java.util.Random;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUtil {
    private static final Logger LOG = LogUtils.getL7dLogger(TestUtil.class);
    private static int portNum = -1;
    private static Properties ports = new Properties();
    private static ServerSocket lock;

    private TestUtil() {
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = TestUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static String getClassPath(ClassLoader loader) throws URISyntaxException {
        StringBuffer classPath = new StringBuffer();
        if (loader instanceof URLClassLoader) {
            URLClassLoader urlLoader = (URLClassLoader)loader;
            for (URL url : urlLoader.getURLs()) {
                String file = url.getFile();
                if (file.indexOf("junit") != -1) continue;
                classPath.append(url.toURI().getPort());
                classPath.append(System.getProperty("path.separator"));
            }
        }
        return classPath.toString();
    }

    public static Method getMethod(Class<?> clazz, String methodName) {
        Method[] declMethods;
        for (Method method : declMethods = clazz.getDeclaredMethods()) {
            if (!method.getName().equals(methodName)) continue;
            return method;
        }
        return null;
    }

    public static Properties getAllPorts() {
        return ports;
    }

    public static String getPortNumber(Class<?> cls) {
        return TestUtil.getPortNumber(cls.getName(), cls.getSimpleName());
    }

    public static String getPortNumber(Class<?> cls, int count) {
        return TestUtil.getPortNumber(cls.getName() + "." + count, cls.getSimpleName() + "." + count);
    }

    public static String getPortNumber(String name) {
        return TestUtil.getPortNumber(name, name);
    }

    public static String getNewPortNumber(Class<?> cls) {
        return TestUtil.getNewPortNumber(cls.getName(), cls.getSimpleName());
    }

    public static String getNewPortNumber(Class<?> cls, int count) {
        return TestUtil.getNewPortNumber(cls.getName() + "." + count, cls.getSimpleName() + "." + count);
    }

    public static String getNewPortNumber(String name) {
        return TestUtil.getNewPortNumber(name, name);
    }

    public static String getNewPortNumber(String fullName, String simpleName) {
        ports.remove("testutil.ports." + fullName);
        ports.remove("testutil.ports." + simpleName);
        System.clearProperty("testutil.ports." + fullName);
        System.clearProperty("testutil.ports." + simpleName);
        return TestUtil.getPortNumber(fullName, simpleName);
    }

    public static String getPortNumber(String fullName, String simpleName) {
        String p = ports.getProperty("testutil.ports." + fullName);
        if (p == null && (p = System.getProperty("testutil.ports." + fullName)) != null) {
            ports.setProperty("testutil.ports." + fullName, p);
            ports.setProperty("testutil.ports." + simpleName, p);
        }
        while (p == null) {
            ++portNum;
            try {
                int pn;
                ServerSocket sock = new ServerSocket(pn);
                sock.close();
                p = Integer.toString(pn);
                LOG.fine("Setting port for " + fullName + " to " + p);
            }
            catch (IOException iOException) {}
        }
        ports.put("testutil.ports." + fullName, p);
        ports.put("testutil.ports." + simpleName, p);
        System.setProperty("testutil.ports." + fullName, p);
        System.setProperty("testutil.ports." + simpleName, p);
        return p;
    }

    static {
        int pn = 9000;
        if (Boolean.getBoolean("cxf.useRandomFirstPort")) {
            pn += new Random().nextInt(500) * 100;
        }
        while (portNum == -1) {
            try {
                ServerSocket sock;
                lock = sock = new ServerSocket(pn);
                portNum = pn + 1;
            }
            catch (IOException ex) {
                pn += 100;
            }
        }
    }
}

