/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.File;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.extensions.soap.SOAPAddress;
import org.apache.activemq.broker.BrokerService;
import org.apache.activemq.store.PersistenceAdapter;
import org.apache.activemq.store.memory.MemoryPersistenceAdapter;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.testutil.common.AbstractBusTestServerBase;
import org.apache.cxf.wsdl.WSDLManager;

public class EmbeddedJMSBrokerLauncher
extends AbstractBusTestServerBase {
    public static final String PORT = EmbeddedJMSBrokerLauncher.allocatePort(EmbeddedJMSBrokerLauncher.class);
    String brokerUrl1;
    BrokerService broker;
    String brokerName;

    public EmbeddedJMSBrokerLauncher() {
        this(null);
    }

    public EmbeddedJMSBrokerLauncher(String url) {
        if (url == null) {
            url = "tcp://localhost:" + PORT;
        }
        this.brokerUrl1 = url;
    }

    public String getBrokerURL() {
        return this.brokerUrl1;
    }

    public void updateWsdl(Bus b, String wsdlLocation) {
        EmbeddedJMSBrokerLauncher.updateWsdlExtensors(b, wsdlLocation, this.brokerUrl1);
    }

    public static void updateWsdlExtensors(Bus bus, String wsdlLocation) {
        EmbeddedJMSBrokerLauncher.updateWsdlExtensors(bus, wsdlLocation, "tcp://localhost:" + PORT);
    }

    public static void updateWsdlExtensors(Bus bus, String wsdlLocation, String url) {
        try {
            if (bus == null) {
                bus = BusFactory.getThreadDefaultBus();
            }
            Definition def = ((WSDLManager)bus.getExtension(WSDLManager.class)).getDefinition(wsdlLocation);
            Map map = def.getAllServices();
            for (Object o : map.values()) {
                Service service = (Service)o;
                Map ports = service.getPorts();
                for (Object p : ports.values()) {
                    Port port = (Port)p;
                    List l = port.getExtensibilityElements();
                    for (Object e : l) {
                        if (e instanceof SOAPAddress) {
                            String add = ((SOAPAddress)e).getLocationURI();
                            int idx = add.indexOf("jndiURL=");
                            if (idx == -1) continue;
                            int idx2 = add.indexOf("&", idx);
                            add = add.substring(0, idx) + "jndiURL=" + url + (idx2 == -1 ? "" : add.substring(idx2));
                            ((SOAPAddress)e).setLocationURI(add);
                            continue;
                        }
                        try {
                            Field f = e.getClass().getDeclaredField("jmsNamingProperty");
                            f.setAccessible(true);
                            List props = (List)f.get(e);
                            for (Object prop : props) {
                                f = prop.getClass().getDeclaredField("name");
                                f.setAccessible(true);
                                if (!"java.naming.provider.url".equals(f.get(prop))) continue;
                                f = prop.getClass().getDeclaredField("value");
                                f.setAccessible(true);
                                f.set(prop, url);
                            }
                        }
                        catch (Exception ex) {
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() throws Exception {
        this.tearDown();
    }

    public void tearDown() throws Exception {
        if (this.broker != null) {
            this.broker.stop();
        }
    }

    public final void run() {
        try {
            this.broker = new BrokerService();
            this.broker.setPersistenceAdapter((PersistenceAdapter)new MemoryPersistenceAdapter());
            this.broker.setTmpDataDirectory(new File("./target"));
            this.broker.setUseJmx(false);
            if (this.brokerName != null) {
                this.broker.setBrokerName(this.brokerName);
            }
            this.broker.addConnector(this.brokerUrl1 + "?daemon=true");
            this.broker.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            String url = null;
            if (args.length > 0) {
                url = args[0];
            }
            EmbeddedJMSBrokerLauncher s = new EmbeddedJMSBrokerLauncher(url);
            s.start();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.exit(-1);
        }
        finally {
            System.out.println("done!");
        }
    }
}

