/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.testutil.common.AbstractTestServerBase;
import org.apache.cxf.testutil.common.TestUtil;

public class ServerLauncher {
    public static final int DEFAULT_TIMEOUT = 180000;
    protected static final String SERVER_FAILED = "server startup failed (not a log message)";
    private static final boolean DEFAULT_IN_PROCESS = false;
    private static final Logger LOG = LogUtils.getLogger(ServerLauncher.class);
    boolean serverPassed;
    final String className;
    private final boolean debug = false;
    private boolean inProcess = false;
    private AbstractTestServerBase inProcessServer;
    private final String javaExe;
    private Process process;
    private boolean serverIsReady;
    private boolean serverIsStopped;
    private boolean serverLaunchFailed;
    private Map<String, String> properties;
    private String[] serverArgs;
    private final Mutex mutex = new Mutex();

    public ServerLauncher(String theClassName) {
        this(theClassName, false);
    }

    public ServerLauncher(AbstractTestServerBase b) {
        this.inProcess = true;
        this.inProcessServer = b;
        this.javaExe = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
        this.className = null;
    }

    public ServerLauncher(String theClassName, boolean inprocess) {
        this.inProcess = inprocess;
        this.className = theClassName;
        this.javaExe = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    public ServerLauncher(String theClassName, Map<String, String> p, String[] args) {
        this(theClassName, p, args, false);
    }

    public ServerLauncher(String theClassName, Map<String, String> p, String[] args, boolean inprocess) {
        this.className = theClassName;
        this.properties = p;
        this.serverArgs = args;
        this.inProcess = inprocess;
        this.javaExe = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitForServerToStop() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            TimeoutCounter tc = new TimeoutCounter(180000L);
            while (!this.serverIsStopped) {
                try {
                    this.mutex.wait(1000L);
                    if (!tc.isTimeoutExpired()) continue;
                    System.out.println("destroying server process");
                    this.process.destroy();
                    break;
                }
                catch (InterruptedException interruptedException) {
                }
            }
            if (!this.inProcess) {
                tc = new TimeoutCounter(180000L);
                while (!tc.isTimeoutExpired()) {
                    try {
                        this.process.exitValue();
                        break;
                    }
                    catch (IllegalThreadStateException ex) {
                        try {
                            this.mutex.wait(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                if (tc.isTimeoutExpired()) {
                    this.process.destroy();
                }
            }
        }
        return this.serverIsStopped;
    }

    public void signalStop() throws IOException {
        if (this.process != null) {
            this.process.getOutputStream().write(113);
            this.process.getOutputStream().write(10);
            this.process.getOutputStream().flush();
        }
    }

    public boolean stopServer() throws IOException {
        if (this.inProcess) {
            try {
                return this.inProcessServer.stopInProcess();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                throw new IOException(ex.getMessage());
            }
        }
        if (this.process != null) {
            if (!this.serverIsStopped) {
                try {
                    this.signalStop();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.waitForServerToStop();
            this.process.destroy();
        }
        return this.serverPassed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean launchServer() throws IOException {
        block24: {
            List<String> cmd;
            block25: {
                this.serverIsReady = false;
                this.serverLaunchFailed = false;
                if (!this.inProcess) break block25;
                HashMap<String, String> old = new HashMap<String, String>();
                try {
                    if (null != this.properties) {
                        for (Map.Entry<String, String> entry : this.properties.entrySet()) {
                            old.put(entry.getKey(), System.getProperty(entry.getKey()));
                            if (entry.getValue() == null) {
                                System.clearProperty(entry.getKey());
                                continue;
                            }
                            System.setProperty(entry.getKey(), entry.getValue());
                        }
                    }
                    if (this.inProcessServer == null) {
                        Class<?> cls = Class.forName(this.className);
                        Class<AbstractTestServerBase> svcls = cls.asSubclass(AbstractTestServerBase.class);
                        if (null == this.serverArgs) {
                            this.inProcessServer = (AbstractTestServerBase)((Object)svcls.newInstance());
                        } else {
                            Constructor constructor = svcls.getConstructor(this.serverArgs.getClass());
                            this.inProcessServer = (AbstractTestServerBase)((Object)constructor.newInstance(new Object[]{this.serverArgs}));
                        }
                    }
                    this.inProcessServer.startInProcess();
                    this.serverIsReady = true;
                }
                catch (Throwable ex) {
                    try {
                        ex.printStackTrace();
                        this.serverLaunchFailed = true;
                        return this.serverLaunchFailed;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        for (Map.Entry entry : old.entrySet()) {
                            if (entry.getValue() == null) {
                                System.clearProperty((String)entry.getKey());
                                continue;
                            }
                            System.setProperty((String)entry.getKey(), (String)entry.getValue());
                        }
                        break block24;
                    }
                }
                for (Map.Entry entry : old.entrySet()) {
                    if (entry.getValue() == null) {
                        System.clearProperty((String)entry.getKey());
                        continue;
                    }
                    System.setProperty((String)entry.getKey(), (String)entry.getValue());
                }
                break block24;
            }
            try {
                cmd = this.getCommand();
            }
            catch (URISyntaxException e1) {
                IOException ex = new IOException();
                ex.initCause(e1);
                throw ex;
            }
            LOG.fine("CMD: " + cmd);
            ProcessBuilder pb = new ProcessBuilder(cmd);
            pb.redirectErrorStream(true);
            this.process = pb.start();
            OutputMonitorThread out = this.launchOutputMonitorThread(this.process.getInputStream(), System.out);
            Mutex mutex = this.mutex;
            synchronized (mutex) {
                TimeoutCounter tc = new TimeoutCounter(180000L);
                while (!this.serverIsReady && !this.serverLaunchFailed) {
                    try {
                        this.mutex.wait(1000L);
                        if (!tc.isTimeoutExpired()) continue;
                        break;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.serverLaunchFailed || !this.serverIsReady) {
                System.err.println(out.getServerOutput());
            }
        }
        return this.serverIsReady && !this.serverLaunchFailed;
    }

    public int waitForServer() {
        int ret = -1;
        try {
            this.process.waitFor();
            ret = this.process.exitValue();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return ret;
    }

    private OutputMonitorThread launchOutputMonitorThread(InputStream in, PrintStream out) {
        OutputMonitorThread t = new OutputMonitorThread(in, out);
        t.start();
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyServerIsReady() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            this.serverIsReady = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyServerIsStopped() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            LOG.info("notify server stopped");
            this.serverIsStopped = true;
            this.mutex.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifyServerFailed() {
        Mutex mutex = this.mutex;
        synchronized (mutex) {
            this.serverIsStopped = true;
            this.serverLaunchFailed = true;
            this.mutex.notifyAll();
        }
    }

    private List<String> getCommand() throws URISyntaxException {
        String tmp;
        String derbyHome;
        String validationMode;
        String loggingPropertiesFile;
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(this.javaExe);
        if (null != this.properties) {
            for (Map.Entry<Object, Object> entry : this.properties.entrySet()) {
                cmd.add("-D" + (String)entry.getKey() + "=" + (String)entry.getValue());
            }
        }
        for (Map.Entry<Object, Object> entry : TestUtil.getAllPorts().entrySet()) {
            cmd.add("-D" + entry.getKey() + "=" + entry.getValue());
        }
        String vmargs = System.getProperty("server.launcher.vmargs");
        if (StringUtils.isEmpty((String)vmargs)) {
            cmd.add("-ea");
        } else {
            int n;
            vmargs = vmargs.trim();
            int n2 = vmargs.indexOf(32);
            while (n != -1) {
                cmd.add(vmargs.substring(0, n));
                vmargs = vmargs.substring((int)(n + true));
                n = vmargs.indexOf(32);
            }
            cmd.add(vmargs);
        }
        String string = System.getProperty("org.apache.cxf.transports.http_jetty.DontClosePort");
        if (string != null) {
            cmd.add("-Dorg.apache.cxf.transports.http_jetty.DontClosePort=" + string);
        }
        if (null != (loggingPropertiesFile = System.getProperty("java.util.logging.config.file"))) {
            cmd.add("-Djava.util.logging.config.file=" + loggingPropertiesFile);
        }
        cmd.add("-classpath");
        ClassLoader loader = this.getClass().getClassLoader();
        StringBuilder classpath = new StringBuilder(System.getProperty("java.class.path"));
        if (classpath.indexOf("/.compatibility/") != -1) {
            classpath.append(":");
            int idx = classpath.indexOf("/.compatibility/");
            int idx1 = classpath.lastIndexOf(":", idx);
            int idx2 = classpath.indexOf(":", idx);
            classpath.replace(idx1, idx2, ":");
        }
        if (loader instanceof URLClassLoader) {
            for (URL url : ((URLClassLoader)loader).getURLs()) {
                classpath.append(File.pathSeparatorChar);
                classpath.append(url.toURI().getPath());
            }
        }
        cmd.add(classpath.toString());
        String transformerProperty = System.getProperty("javax.xml.transform.TransformerFactory");
        if (null != transformerProperty) {
            cmd.add("-Djavax.xml.transform.TransformerFactory=" + transformerProperty);
        }
        if (null != (validationMode = System.getProperty("spring.validation.mode"))) {
            cmd.add("-Dspring.validation.mode=" + validationMode);
        }
        if (null != (derbyHome = System.getProperty("derby.system.home"))) {
            cmd.add("-Dderby.system.home=" + derbyHome);
        }
        if (null != (tmp = System.getProperty("java.io.tmpdir"))) {
            cmd.add("-Djava.io.tmpdir=" + tmp);
        }
        cmd.add(this.className);
        if (null != this.serverArgs) {
            for (String s : this.serverArgs) {
                cmd.add(s);
            }
        }
        return cmd;
    }

    static class TimeoutCounter {
        private final long expectedEndTime;

        TimeoutCounter(long theExpectedTimeout) {
            this.expectedEndTime = System.currentTimeMillis() + theExpectedTimeout;
        }

        public boolean isTimeoutExpired() {
            return System.currentTimeMillis() > this.expectedEndTime;
        }
    }

    static class Mutex {
        Mutex() {
        }
    }

    private class OutputMonitorThread
    extends Thread {
        InputStream in;
        PrintStream out;
        StringBuilder serverOutputAll = new StringBuilder();

        OutputMonitorThread(InputStream i, PrintStream o) {
            this.in = i;
            this.out = o;
        }

        public String getServerOutput() {
            return this.serverOutputAll.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block32: {
                FileOutputStream fos;
                block31: {
                    String outputDir = System.getProperty("server.output.dir", "target/surefire-reports/");
                    fos = null;
                    try {
                        try {
                            fos = new FileOutputStream(outputDir + ServerLauncher.this.className + ".out");
                        }
                        catch (FileNotFoundException fex) {
                            outputDir = System.getProperty("basedir");
                            outputDir = outputDir == null ? "target/surefire-reports/" : outputDir + "/target/surefire-reports/";
                            File file = new File(outputDir);
                            file.mkdirs();
                            fos = new FileOutputStream(outputDir + ServerLauncher.this.className + ".out");
                        }
                    }
                    catch (IOException ex) {
                        if (ex.getMessage().contains("Stream closed")) break block31;
                        ex.printStackTrace();
                    }
                }
                try (PrintStream ps = new PrintStream(fos);){
                    boolean running = true;
                    StringBuilder serverOutput = new StringBuilder();
                    int ch = this.in.read();
                    while (ch != -1) {
                        serverOutput.append((char)ch);
                        this.serverOutputAll.append((char)ch);
                        String s = serverOutput.toString();
                        if (s.contains("server ready")) {
                            ServerLauncher.this.notifyServerIsReady();
                        } else if (s.contains("server passed")) {
                            ServerLauncher.this.serverPassed = true;
                        } else if (s.contains("server stopped")) {
                            ServerLauncher.this.notifyServerIsStopped();
                            running = false;
                        } else if (s.contains(ServerLauncher.SERVER_FAILED)) {
                            ServerLauncher.this.notifyServerFailed();
                            running = false;
                        }
                        if (ch == 10 || !running) {
                            PrintStream printStream = this.out;
                            synchronized (printStream) {
                                ps.print(serverOutput.toString());
                                serverOutput.setLength(0);
                                ps.flush();
                            }
                        }
                        if (this.serverOutputAll.length() > 64000) {
                            this.serverOutputAll.delete(0, 10000);
                        }
                        ch = this.in.read();
                    }
                }
                catch (IOException ex) {
                    if (ex.getMessage().contains("Stream closed")) break block32;
                    ex.printStackTrace();
                }
            }
        }
    }
}

