/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.test;

import java.io.InputStream;
import java.util.HashMap;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.test.XPathAssert;
import org.junit.Assert;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class XPathAssertTest
extends Assert {
    @Test
    public void testAssert() throws Exception {
        Document document = StaxUtils.read((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test.xml"));
        XPathAssert.assertValid((String)"//a", (Node)document, null);
        XPathAssert.assertInvalid((String)"//aasd", (Node)document, null);
        boolean f = false;
        try {
            XPathAssert.assertInvalid((String)"//a", (Node)document, null);
            f = true;
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        if (f) {
            XPathAssertTest.fail((String)"Expression is valid!");
        }
        try {
            XPathAssert.assertValid((String)"//aa", (Node)document, null);
            f = true;
        }
        catch (AssertionError assertionError) {
            // empty catch block
        }
        if (f) {
            XPathAssertTest.fail((String)"Expression is valid!");
        }
        XPathAssert.assertXPathEquals((String)"//b", (String)"foo", (Node)document, null);
    }

    @Test
    public void testAssertNamespace() throws Exception {
        Document document = StaxUtils.read((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("test2.xml"));
        HashMap<String, String> namespaces = new HashMap<String, String>();
        namespaces.put("a", "urn:foo");
        namespaces.put("z", "urn:z");
        XPathAssert.assertValid((String)"//a:a", (Node)document, namespaces);
        XPathAssert.assertValid((String)"//z:b", (Node)document, namespaces);
    }
}

