/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerRegistry;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.test.XPathAssert;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.transport.ConduitInitiator;
import org.apache.cxf.transport.ConduitInitiatorManager;
import org.apache.cxf.transport.MessageObserver;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestUtilities {
    private static String preKeepAlive;
    private static String basedirPath;
    protected Bus bus;
    protected Class<?> classpathAnchor;
    private Map<String, String> namespaces = new HashMap<String, String>();

    public TestUtilities(Class<?> classpathReference) {
        this.classpathAnchor = classpathReference;
    }

    public static void setKeepAliveSystemProperty(boolean setAlive) {
        preKeepAlive = System.getProperty("http.keepAlive");
        System.setProperty("http.keepAlive", Boolean.toString(setAlive));
    }

    public static void recoverKeepAliveSystemProperty() {
        if (preKeepAlive != null) {
            System.setProperty("http.keepAlive", preKeepAlive);
        } else {
            System.clearProperty("http.keepAlive");
        }
    }

    public void addDefaultNamespaces() {
        this.addNamespace("s", "http://schemas.xmlsoap.org/soap/envelope/");
        this.addNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        this.addNamespace("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        this.addNamespace("wsdlsoap", "http://schemas.xmlsoap.org/wsdl/soap/");
        this.addNamespace("soap", "http://schemas.xmlsoap.org/soap/");
        this.addNamespace("soap12env", "http://www.w3.org/2003/05/soap-envelope");
        this.addNamespace("xml", "http://www.w3.org/XML/1998/namespace");
    }

    public String resolveNamespacePrefix(String prefix, Node node) throws Exception {
        String url = null;
        NodeList nodeNamespaces = this.assertValid("namespace::*", node);
        for (int x = 0; x < nodeNamespaces.getLength(); ++x) {
            Attr nsAttr = (Attr)nodeNamespaces.item(x);
            String localName = nsAttr.getLocalName();
            if (!localName.equals(prefix)) continue;
            url = nsAttr.getValue();
            break;
        }
        return url;
    }

    public NodeList assertValid(String xpath, Node node) throws Exception {
        return XPathAssert.assertValid(xpath, node, this.namespaces);
    }

    public void assertValidBoolean(String xpath, Node node) throws Exception {
        XPathAssert.assertValidBoolean(xpath, node, this.namespaces);
    }

    public NodeList assertInvalid(String xpath, Node node) throws Exception {
        return XPathAssert.assertInvalid(xpath, node, this.namespaces);
    }

    public void assertXPathEquals(String xpath, String value, Node node) throws Exception {
        XPathAssert.assertXPathEquals(xpath, value, node, this.namespaces);
    }

    public void assertXPathEquals(String xpath, QName value, Node node) throws Exception {
        XPathAssert.assertXPathEquals(xpath, value, node, this.namespaces);
    }

    public void assertNoFault(Node node) throws Exception {
        XPathAssert.assertNoFault(node);
    }

    public byte[] invokeBytes(String address, String transport, String message) throws Exception {
        EndpointInfo ei = new EndpointInfo(null, "http://schemas.xmlsoap.org/soap/http");
        ei.setAddress(address);
        ConduitInitiatorManager conduitMgr = (ConduitInitiatorManager)this.getBus().getExtension(ConduitInitiatorManager.class);
        ConduitInitiator conduitInit = conduitMgr.getConduitInitiator(transport);
        Conduit conduit = conduitInit.getConduit(ei, this.getBus());
        TestMessageObserver obs = new TestMessageObserver();
        conduit.setMessageObserver((MessageObserver)obs);
        MessageImpl m = new MessageImpl();
        conduit.prepare((Message)m);
        OutputStream os = (OutputStream)m.getContent(OutputStream.class);
        InputStream is = this.getResourceAsStream(message);
        if (is == null) {
            throw new RuntimeException("Could not find resource " + message);
        }
        IOUtils.copy((InputStream)is, (OutputStream)os);
        os.flush();
        is.close();
        os.close();
        return obs.getResponseStream().toByteArray();
    }

    public Node invoke(String address, String transport, String message) throws Exception {
        byte[] bs = this.invokeBytes(address, transport, message);
        ByteArrayInputStream input = new ByteArrayInputStream(bs);
        return StaxUtils.read((InputStream)input);
    }

    public InputStream getResourceAsStream(String resource) {
        return this.classpathAnchor.getResourceAsStream(resource);
    }

    public Reader getResourceAsReader(String resource) {
        return new InputStreamReader(this.getResourceAsStream(resource), StandardCharsets.UTF_8);
    }

    public File getTestFile(String relativePath) {
        return new File(TestUtilities.getBasedir(), relativePath);
    }

    public static String getBasedir() {
        if (basedirPath != null) {
            return basedirPath;
        }
        basedirPath = System.getProperty("basedir");
        if (basedirPath == null) {
            basedirPath = new File("").getAbsolutePath();
        }
        return basedirPath;
    }

    public Document getWSDLDocument(Server server) throws WSDLException {
        Definition definition = this.getWSDLDefinition(server);
        WSDLWriter writer = WSDLFactory.newInstance().newWSDLWriter();
        return writer.getDocument(definition);
    }

    public Definition getWSDLDefinition(Server server) throws WSDLException {
        Service service = server.getEndpoint().getService();
        ServiceWSDLBuilder wsdlBuilder = new ServiceWSDLBuilder(this.bus, new ServiceInfo[]{(ServiceInfo)service.getServiceInfos().get(0)});
        wsdlBuilder.setUseSchemaImports(false);
        return wsdlBuilder.build();
    }

    public Server getServerForService(QName serviceName) throws WSDLException {
        ServerRegistry svrMan = (ServerRegistry)this.bus.getExtension(ServerRegistry.class);
        for (Server s : svrMan.getServers()) {
            Service svc = s.getEndpoint().getService();
            if (!svc.getName().equals(serviceName)) continue;
            return s;
        }
        return null;
    }

    public Server getServerForAddress(String address) throws WSDLException {
        ServerRegistry svrMan = (ServerRegistry)this.bus.getExtension(ServerRegistry.class);
        for (Server s : svrMan.getServers()) {
            if (!address.equals(s.getEndpoint().getEndpointInfo().getAddress())) continue;
            return s;
        }
        return null;
    }

    public void addNamespace(String ns, String uri) {
        this.namespaces.put(ns, uri);
    }

    public Map<String, String> getNamespaces() {
        return this.namespaces;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    public static boolean checkUnrestrictedPoliciesInstalled() {
        boolean unrestrictedPoliciesInstalled = false;
        try {
            byte[] data = new byte[]{0, 1, 2, 3, 4, 5, 6, 7};
            SecretKeySpec key192 = new SecretKeySpec(new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23}, "AES");
            Cipher c = Cipher.getInstance("AES");
            c.init(1, key192);
            c.doFinal(data);
            unrestrictedPoliciesInstalled = true;
        }
        catch (Exception e) {
            return unrestrictedPoliciesInstalled;
        }
        return unrestrictedPoliciesInstalled;
    }

    public static class TestMessageObserver
    implements MessageObserver {
        ByteArrayOutputStream response = new ByteArrayOutputStream();
        boolean written;
        String contentType;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ByteArrayOutputStream getResponseStream() throws Exception {
            TestMessageObserver testMessageObserver = this;
            synchronized (testMessageObserver) {
                while (!this.written) {
                    this.wait(10000L);
                }
            }
            return this.response;
        }

        public String getResponseContentType() {
            return this.contentType;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onMessage(Message message) {
            try {
                this.contentType = (String)message.get((Object)"Content-Type");
                InputStream is = (InputStream)message.getContent(InputStream.class);
                try {
                    IOUtils.copy((InputStream)is, (OutputStream)this.response);
                    is.close();
                    this.response.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            finally {
                TestMessageObserver testMessageObserver = this;
                synchronized (testMessageObserver) {
                    this.written = true;
                    this.notifyAll();
                }
            }
        }
    }
}

