/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.LogManager;
import org.apache.cxf.testutil.common.AbstractTestServerBase;
import org.apache.cxf.testutil.common.ServerLauncher;
import org.apache.cxf.testutil.common.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;

public abstract class AbstractClientServerTestBase {
    private static List<ServerLauncher> launchers = new ArrayList<ServerLauncher>();
    private static boolean firstLaunch = true;

    private static synchronized void checkFirstLaunch(Class<?> cls) {
        if (firstLaunch) {
            InputStream in;
            firstLaunch = false;
            String jdkl = System.getProperty("java.util.logging.config.file");
            if (jdkl == null && (in = cls.getResourceAsStream("/logging.properties")) != null) {
                try {
                    LogManager.getLogManager().readConfiguration(in);
                }
                catch (IOException | SecurityException exception) {
                    // empty catch block
                }
            }
        }
    }

    @AfterClass
    public static void stopAllServers() throws Exception {
        boolean passed = true;
        for (ServerLauncher sl : launchers) {
            try {
                sl.signalStop();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        for (ServerLauncher sl : launchers) {
            try {
                passed = passed && sl.stopServer();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        launchers.clear();
        System.gc();
        Assert.assertTrue((String)"server failed", (boolean)passed);
    }

    public static boolean launchServer(AbstractTestServerBase base) {
        boolean ok = false;
        try {
            AbstractClientServerTestBase.checkFirstLaunch(base.getClass());
            ServerLauncher sl = new ServerLauncher(base);
            ok = sl.launchServer();
            Assert.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(0, sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Assert.fail((String)("failed to launch server " + String.valueOf(base)));
        }
        return ok;
    }

    public static boolean launchServer(Class<?> clz) {
        return AbstractClientServerTestBase.launchServer(clz, true);
    }

    public static boolean launchServer(Class<?> clz, boolean inProcess) {
        boolean ok = false;
        try {
            AbstractClientServerTestBase.checkFirstLaunch(clz);
            ServerLauncher sl = new ServerLauncher(clz.getName(), inProcess);
            ok = sl.launchServer();
            Assert.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(0, sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Assert.fail((String)("failed to launch server " + String.valueOf(clz)));
        }
        return ok;
    }

    public static boolean launchServer(Class<?> clz, Map<String, String> props, String[] args) {
        return AbstractClientServerTestBase.launchServer(clz, props, args, true);
    }

    public static boolean launchServer(Class<?> clz, Map<String, String> props, String[] args, boolean inProcess) {
        boolean ok = false;
        try {
            AbstractClientServerTestBase.checkFirstLaunch(clz);
            ServerLauncher sl = new ServerLauncher(clz.getName(), props, args, inProcess);
            ok = sl.launchServer();
            Assert.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(0, sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            Assert.fail((String)("failed to launch server " + String.valueOf(clz)));
        }
        return ok;
    }

    protected void setAddress(Object o, String address) {
        TestUtil.setAddress(o, address);
    }

    protected void updateAddressPort(Object o, String port) throws NumberFormatException, MalformedURLException {
        TestUtil.updateAddressPort(o, port);
    }

    protected static String allocatePort(String s) {
        return TestUtil.getPortNumber(s);
    }

    protected static String allocatePort(Class<?> cls) {
        AbstractClientServerTestBase.checkFirstLaunch(cls);
        return TestUtil.getPortNumber(cls);
    }

    protected static String allocatePort(Class<?> cls, int count) {
        AbstractClientServerTestBase.checkFirstLaunch(cls);
        return TestUtil.getPortNumber(cls, count);
    }
}

