/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.Compiler;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.util.ClassCollector;

public class ClassUtils {
    protected static final Logger LOG = LogUtils.getL7dLogger(ClassUtils.class);

    public void compile(ToolContext context) throws ToolException {
        String javaClasspath;
        Compiler compiler = new Compiler();
        if (context.isVerbose()) {
            compiler.setVerbose(true);
        }
        compiler.setEncoding((String)context.get("encoding"));
        if (context.get("classdir") != null) {
            compiler.setOutputDir((String)context.get("classdir"));
        }
        if ((javaClasspath = System.getProperty("java.class.path")) != null) {
            if (context.get("outputdir") != null) {
                compiler.setClassPath(javaClasspath + File.pathSeparatorChar + context.get("outputdir"));
            } else {
                compiler.setClassPath(javaClasspath);
            }
        }
        String outPutDir = (String)context.get("outputdir");
        HashSet<String> dirSet = new HashSet<String>();
        ClassCollector classCollector = context.get(ClassCollector.class);
        ArrayList<String> fileList = new ArrayList<String>();
        for (String fileName : classCollector.getGeneratedFileInfo()) {
            fileName = fileName.replace('.', File.separatorChar);
            String dirName = fileName.substring(0, fileName.lastIndexOf(File.separator) + 1);
            String path = outPutDir + File.separator + dirName;
            if (dirSet.contains(path)) continue;
            dirSet.add(path);
            File file = new File(path);
            if (!file.isDirectory()) continue;
            for (String str : file.list()) {
                if (str.endsWith("java")) {
                    fileList.add(path + str);
                    continue;
                }
                File otherFile = new File(path + File.separator + str);
                if (!otherFile.isFile() || !str.toLowerCase().endsWith("xml") || context.get("classdir") == null) continue;
                String targetDir = (String)context.get("classdir");
                File targetFile = new File(targetDir + File.separator + dirName + File.separator + str);
                try {
                    this.copyXmlFile(otherFile, targetFile);
                }
                catch (IOException e) {
                    Message msg = new Message("FAIL_TO_COPY_GENERATED_RESOURCE_FILE", LOG, new Object[0]);
                    throw new ToolException(msg, (Throwable)e);
                }
            }
            File jaxbRuntime = new File(path, "runtime");
            if (!jaxbRuntime.isDirectory() || !jaxbRuntime.exists()) continue;
            List files = FileUtils.getFiles((File)jaxbRuntime, (String)".+\\.java$");
            for (File f : files) {
                fileList.add(f.toString());
            }
        }
        if (!compiler.compileFiles(fileList.toArray(new String[fileList.size()]))) {
            Message msg = new Message("FAIL_TO_COMPILE_GENERATE_CODES", LOG, new Object[0]);
            throw new ToolException(msg);
        }
    }

    private void copyXmlFile(File from, File to) throws ToolException, IOException {
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            String dir = to.getCanonicalPath().substring(0, to.getCanonicalPath().lastIndexOf(File.separator));
            File dirFile = new File(dir);
            dirFile.mkdirs();
            input = new FileInputStream(from);
            output = new FileOutputStream(to);
            byte[] b = new byte[3072];
            int len = 0;
            while (len != -1) {
                len = input.read(b);
                if (len == -1) continue;
                output.write(b, 0, len);
            }
            output.flush();
        }
        catch (Exception e) {
            Message msg = new Message("FAIL_TO_COPY_GENERATED_RESOURCE_FILE", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)e);
        }
        finally {
            if (output != null) {
                output.close();
            }
            if (input != null) {
                input.close();
            }
        }
    }
}

