/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl.generator.wsdl11;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.WSDLException;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLWriter;
import javax.xml.stream.XMLStreamException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.java2wsdl.generator.AbstractGenerator;
import org.apache.cxf.tools.java2wsdl.generator.wsdl11.DateTypeCustomGenerator;
import org.apache.cxf.tools.util.FileWriterUtil;
import org.apache.cxf.tools.util.OutputStreamCreator;
import org.apache.cxf.tools.wsdlto.core.WSDLDefinitionBuilder;
import org.apache.cxf.wsdl11.ServiceWSDLBuilder;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class WSDL11Generator
extends AbstractGenerator<Definition> {
    @Override
    public Definition generate(File dir) {
        File file = this.getOutputBase();
        if (file == null && dir != null) {
            file = dir.isDirectory() ? new File(dir, this.getServiceModel().getName().getLocalPart() + ".wsdl") : dir;
        } else if (dir == null) {
            file = new File(this.getServiceModel().getName().getLocalPart() + ".wsdl");
        }
        File outputdir = this.createOutputDir(file);
        Definition def = null;
        try {
            Writer os = new FileWriterUtil(file.getParent(), this.getOutputStreamCreator()).getWriter(file, StandardCharsets.UTF_8.name());
            WSDLWriter wsdlWriter = WSDLFactory.newInstance().newWSDLWriter();
            ServiceWSDLBuilder builder = new ServiceWSDLBuilder(this.getBus(), new ServiceInfo[]{this.getServiceModel()});
            builder.setUseSchemaImports(this.allowImports());
            String name = file.getName();
            if (name.endsWith(".wsdl")) {
                name = name.substring(0, name.lastIndexOf(".wsdl"));
            }
            builder.setBaseFileName(name);
            HashMap<String, SchemaInfo> imports = new HashMap<String, SchemaInfo>();
            def = builder.build(imports);
            wsdlWriter.writeWSDL(def, os);
            os.close();
            if (!def.getImports().isEmpty()) {
                for (Import import_ : WSDLDefinitionBuilder.getImports((Definition)def)) {
                    Definition wsdlDef = import_.getDefinition();
                    File wsdlFile = !StringUtils.isEmpty((String)import_.getLocationURI()) ? new File(outputdir, import_.getLocationURI()) : new File(outputdir, wsdlDef.getQName().getLocalPart() + ".wsdl");
                    try (BufferedOutputStream wsdlOs = new BufferedOutputStream(Files.newOutputStream(wsdlFile.toPath(), new OpenOption[0]));){
                        wsdlWriter.writeWSDL(wsdlDef, (OutputStream)wsdlOs);
                    }
                }
            }
            for (Map.Entry entry : imports.entrySet()) {
                File impfile = new File(file.getParentFile(), (String)entry.getKey());
                Element el = ((SchemaInfo)entry.getValue()).getElement();
                this.updateImports(el, imports);
                FileWriterUtil fileWriterUtil = new FileWriterUtil(impfile.getParent(), (OutputStreamCreator)this.getToolContext().get(OutputStreamCreator.class));
                os = fileWriterUtil.getWriter(impfile, StandardCharsets.UTF_8.name());
                StaxUtils.writeTo((Node)el, (Writer)os, (int)2);
                os.close();
            }
            this.customizing(outputdir, name, imports.keySet());
        }
        catch (WSDLException wex) {
            wex.printStackTrace();
        }
        catch (FileNotFoundException fnfe) {
            throw new ToolException("Output file " + String.valueOf(file) + " not found", (Throwable)fnfe);
        }
        catch (IOException | XMLStreamException e) {
            e.printStackTrace();
        }
        return def;
    }

    private void updateImports(Element el, Map<String, SchemaInfo> imports) {
        List imps = DOMUtils.getChildrenWithName((Element)el, (String)"http://www.w3.org/2001/XMLSchema", (String)"import");
        for (Element e : imps) {
            String ns = e.getAttribute("namespace");
            for (Map.Entry<String, SchemaInfo> ent : imports.entrySet()) {
                if (!ent.getValue().getNamespaceURI().equals(ns)) continue;
                e.setAttribute("schemaLocation", ent.getKey());
            }
        }
    }

    private void customizing(File outputdir, String wsdlName, Set<String> imports) {
        DateTypeCustomGenerator generator = new DateTypeCustomGenerator();
        generator.setWSDLName(wsdlName);
        generator.setServiceModel(this.getServiceModel());
        generator.setAllowImports(this.allowImports());
        generator.addSchemaFiles(imports);
        generator.setToolContext(this.getToolContext());
        generator.generate(outputdir);
    }
}

