/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.tools.common.ToolException;
import org.w3c.dom.Document;

public class Stax2DOM {
    static final String XML_NS = "http://www.w3.org/2000/xmlns/";

    public Document getDocument(String wsdl) throws ToolException {
        try {
            URI wsdlURI = new URI(URIParserUtil.getAbsoluteURI((String)wsdl));
            if (wsdlURI.toString().startsWith("http")) {
                return this.getDocument(wsdlURI.toURL());
            }
            return this.getDocument(wsdlURI.toURL());
        }
        catch (ToolException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
    }

    public Document getDocument(URL url) throws ToolException {
        Document document;
        InputStream input = null;
        XMLStreamReader reader = null;
        try {
            input = url.openStream();
            StreamSource src = new StreamSource(input, url.toExternalForm());
            reader = StaxUtils.createXMLStreamReader((Source)src);
            document = StaxUtils.read((XMLStreamReader)reader, (boolean)true);
        }
        catch (Exception e) {
            try {
                throw new ToolException((Throwable)e);
            }
            catch (Throwable throwable) {
                StaxUtils.close(reader);
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        throw new ToolException((Throwable)e2);
                    }
                }
                throw throwable;
            }
        }
        StaxUtils.close((XMLStreamReader)reader);
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException e) {
                throw new ToolException((Throwable)e);
            }
        }
        return document;
    }

    public Document getDocument(File wsdl) throws ToolException {
        XMLStreamReader reader = null;
        try {
            StreamSource source = new StreamSource(wsdl);
            reader = StaxUtils.createXMLStreamReader((Source)source);
            Document document = StaxUtils.read((XMLStreamReader)reader, (boolean)true);
            return document;
        }
        catch (Exception e) {
            throw new ToolException((Throwable)e);
        }
        finally {
            block13: {
                try {
                    if (reader == null) break block13;
                    try {
                        reader.getClass().getMethod("closeCompletely", new Class[0]).invoke((Object)reader, new Object[0]);
                    }
                    catch (Throwable t) {}
                    reader.close();
                }
                catch (XMLStreamException e) {
                    throw new ToolException((Throwable)e);
                }
            }
        }
    }
}

