/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Part;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPHeader;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.validator.internal.AbstractDefinitionValidator;

public class UniqueBodyPartsValidator
extends AbstractDefinitionValidator {
    private Map<QName, String> uniqueBodyPartsMap;

    public UniqueBodyPartsValidator(Definition def) {
        super(def);
    }

    @Override
    public boolean isValid() {
        Collection bindings = CastUtils.cast(this.def.getAllBindings().values());
        for (Binding binding : bindings) {
            this.uniqueBodyPartsMap = new HashMap<QName, String>();
            List ops = CastUtils.cast((List)binding.getBindingOperations());
            for (BindingOperation op : ops) {
                Operation operation = op.getOperation();
                if (operation == null || operation.getInput() == null) continue;
                Message inMessage = operation.getInput().getMessage();
                BindingInput bin = op.getBindingInput();
                HashSet<String> headers = new HashSet<String>();
                if (bin != null) {
                    List lst = CastUtils.cast((List)bin.getExtensibilityElements());
                    for (ExtensibilityElement ext : lst) {
                        SOAPHeader header;
                        if (!(ext instanceof SOAPHeader) || !(header = (SOAPHeader)ext).getMessage().equals(inMessage.getQName())) continue;
                        headers.add(header.getPart());
                    }
                }
                if (inMessage == null || this.isUniqueBodyPart(operation.getName(), inMessage, headers, binding.getQName())) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isUniqueBodyPart(String operationName, Message msg, Collection<String> headers, QName bindingName) {
        List partList = CastUtils.cast((List)msg.getOrderedParts(null));
        for (Part part : partList) {
            if (headers.contains(part.getName())) continue;
            if (part.getElementName() == null) {
                return true;
            }
            String opName = this.getOperationNameWithSamePart(operationName, part);
            if (opName != null) {
                this.addErrorMessage("Non unique body parts, operation [ " + opName + " ] " + "and  operation [ " + operationName + " ] in binding " + bindingName.toString() + " have the same body block: " + part.getElementName());
                return false;
            }
            return true;
        }
        return true;
    }

    private String getOperationNameWithSamePart(String operationName, Part part) {
        QName partQN = part.getElementName();
        String opName = this.uniqueBodyPartsMap.get(partQN);
        if (opName == null) {
            this.uniqueBodyPartsMap.put(partQN, operationName);
            return null;
        }
        return opName;
    }
}

