/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.validator.internal;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.URIParserUtil;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.validator.internal.AbstractDefinitionValidator;
import org.apache.cxf.tools.validator.internal.NewStackTraceErrorHandler;
import org.apache.cxf.tools.validator.internal.SchemaResourceResolver;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaValidator
extends AbstractDefinitionValidator {
    protected static final Logger LOG = LogUtils.getL7dLogger(SchemaValidator.class);
    private static final String ACCESS_EXTERNAL_SCHEMA = "http://javax.xml.XMLConstants/property/accessExternalSchema";
    protected String[] defaultSchemas;
    protected String schemaLocation = "./";
    private String wsdlsrc;
    private String[] xsds;
    private List<InputSource> schemaFromJar;
    private DocumentBuilder docBuilder;
    private SAXParser saxParser;

    public SchemaValidator(String schemaDir) throws ToolException {
        this.schemaLocation = schemaDir;
        this.defaultSchemas = this.getDefaultSchemas();
    }

    public SchemaValidator(String schemaDir, String wsdl, String[] schemas) throws ToolException {
        this.schemaLocation = schemaDir;
        this.defaultSchemas = this.getDefaultSchemas();
        this.wsdlsrc = wsdl;
        this.xsds = schemas;
    }

    public SchemaValidator(List<InputSource> defaultSchemas, String wsdl, String[] schemas) {
        this.schemaLocation = null;
        this.schemaFromJar = defaultSchemas;
        this.wsdlsrc = wsdl;
        this.xsds = schemas;
    }

    @Override
    public boolean isValid() {
        return this.validate(this.wsdlsrc, this.xsds);
    }

    public boolean validate(String wsdlsource, String[] schemas) throws ToolException {
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docFactory.setNamespaceAware(true);
            docFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            this.docBuilder = docFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new ToolException((Throwable)e);
        }
        String systemId = null;
        systemId = URIParserUtil.getAbsoluteURI((String)wsdlsource);
        InputSource is = new InputSource(systemId);
        return this.validate(is, schemas);
    }

    private Schema createSchema(List<InputSource> xsdsInJar, String[] schemas) throws SAXException, IOException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        try {
            sf.setProperty(ACCESS_EXTERNAL_SCHEMA, "file");
        }
        catch (SAXException ex) {
            LOG.fine("Error setting the ACCESS_EXTERNAL_SCHEMA property");
        }
        SchemaResourceResolver resourceResolver = new SchemaResourceResolver();
        sf.setResourceResolver(resourceResolver);
        ArrayList<DOMSource> sources = new ArrayList<DOMSource>();
        for (InputSource is : xsdsInJar) {
            Message msg = new Message("CREATE_SCHEMA_LOADED_FROM_JAR", LOG, new Object[]{is.getSystemId()});
            LOG.log(Level.FINE, msg.toString());
            Document doc = this.docBuilder.parse(is.getByteStream());
            DOMSource stream = new DOMSource(doc, is.getSystemId());
            stream.setSystemId(is.getSystemId());
            sources.add(stream);
        }
        if (schemas != null) {
            for (int i = 0; i < schemas.length; ++i) {
                Document doc = this.docBuilder.parse(schemas[i]);
                DOMSource stream = new DOMSource(doc, schemas[i]);
                sources.add(stream);
            }
        }
        Source[] args = new Source[sources.size()];
        sources.toArray(args);
        return sf.newSchema(args);
    }

    private Schema createSchema(String[] schemas) throws SAXException, IOException {
        SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        sf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
        SchemaResourceResolver resourceResolver = new SchemaResourceResolver();
        sf.setResourceResolver(resourceResolver);
        Source[] sources = new Source[schemas.length];
        for (int i = 0; i < schemas.length; ++i) {
            Document doc = this.docBuilder.parse(schemas[i]);
            DOMSource stream = new DOMSource(doc, schemas[i]);
            sources[i] = stream;
        }
        return sf.newSchema(sources);
    }

    public boolean validate(InputSource wsdlsource, String[] schemas) throws ToolException {
        boolean isValid = false;
        try {
            Schema schema;
            SAXParserFactory saxFactory = SAXParserFactory.newInstance();
            saxFactory.setFeature("http://xml.org/sax/features/namespaces", true);
            saxFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", Boolean.TRUE);
            this.saxParser = saxFactory.newSAXParser();
            if (this.defaultSchemas != null) {
                schemas = this.addSchemas(this.defaultSchemas, schemas);
                schema = this.createSchema(schemas);
            } else {
                schema = this.createSchema(this.schemaFromJar, schemas);
            }
            Validator validator = schema.newValidator();
            NewStackTraceErrorHandler errHandler = new NewStackTraceErrorHandler();
            validator.setErrorHandler(errHandler);
            SAXSource saxSource = new SAXSource(this.saxParser.getXMLReader(), wsdlsource);
            validator.validate(saxSource);
            if (!errHandler.isValid()) {
                throw new ToolException(errHandler.getErrorMessages());
            }
            isValid = true;
        }
        catch (IOException ioe) {
            throw new ToolException("Cannot get the wsdl " + wsdlsource.getSystemId(), (Throwable)ioe);
        }
        catch (SAXException saxEx) {
            throw new ToolException((Throwable)saxEx);
        }
        catch (ParserConfigurationException e) {
            throw new ToolException((Throwable)e);
        }
        return isValid;
    }

    private String[] addSchemas(String[] defaults, String[] schemas) {
        if (schemas == null || schemas.length == 0) {
            return this.defaultSchemas;
        }
        String[] ss = new String[schemas.length + defaults.length];
        System.arraycopy(defaults, 0, ss, 0, defaults.length);
        System.arraycopy(schemas, 0, ss, defaults.length, schemas.length);
        return ss;
    }

    private String[] getDefaultSchemas() throws ToolException {
        File f;
        String loc = this.schemaLocation;
        if (loc == null || "".equals(loc.trim())) {
            loc = "./";
        }
        if ((f = new File(loc)).exists() && f.isDirectory()) {
            FilenameFilter filter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(".xsd") && !new File(dir.getPath() + File.separator + name).isDirectory();
                }
            };
            File[] files = f.listFiles(filter);
            ArrayList<String> xsdUrls = new ArrayList<String>(files.length);
            for (File file : files) {
                try {
                    String s = file.toURI().toURL().toString();
                    xsdUrls.add(s);
                    if (!s.contains("http-conf")) continue;
                    xsdUrls.add(0, s);
                }
                catch (MalformedURLException e) {
                    throw new ToolException((Throwable)e);
                }
            }
            return xsdUrls.toArray(new String[xsdUrls.size()]);
        }
        return null;
    }
}

