/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.databinding.jaxb;

import com.sun.tools.xjc.api.ErrorListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.cxf.tools.common.ToolErrorListener;
import org.xml.sax.SAXParseException;

public class JAXBBindErrorListener
implements ErrorListener {
    private boolean isVerbose;
    private ToolErrorListener listener;

    public JAXBBindErrorListener(boolean verbose, ToolErrorListener l) {
        this.isVerbose = verbose;
        this.listener = l;
    }

    public boolean hasErrors() {
        return this.listener.getErrorCount() > 0;
    }

    public void error(SAXParseException exception) {
        String s = exception.getSystemId();
        File file = null;
        if (s != null && s.startsWith("file:")) {
            if (s.contains("#")) {
                s = s.substring(0, s.indexOf(35));
            }
            try {
                URI uri = new URI(s);
                file = new File(uri);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        this.listener.addError(file, exception.getLineNumber(), exception.getColumnNumber(), this.mapMessage(exception.getLocalizedMessage()), (Throwable)exception);
    }

    public void fatalError(SAXParseException exception) {
        this.error(exception);
    }

    public void info(SAXParseException exception) {
        if (this.isVerbose) {
            System.out.println("JAXB Info: " + exception.toString() + " in schema " + exception.getSystemId());
        }
    }

    public void warning(SAXParseException exception) {
        if (this.isVerbose) {
            System.out.println("JAXB parsing schema warning " + exception.toString() + " in schema " + exception.getSystemId());
        }
        String s = exception.getSystemId();
        File file = null;
        if (s != null && s.startsWith("file:")) {
            if (s.contains("#")) {
                s = s.substring(0, s.indexOf(35));
            }
            try {
                URI uri = new URI(s);
                file = new File(uri);
            }
            catch (URISyntaxException e) {
                // empty catch block
            }
        }
        this.listener.addWarning(file, exception.getLineNumber(), exception.getColumnNumber(), this.mapMessage(exception.getLocalizedMessage()), (Throwable)exception);
    }

    private String mapMessage(String msg) {
        if (msg.contains("Use a class customization to resolve") && msg.contains("with the same name")) {
            int idx = msg.lastIndexOf("class customization") + 19;
            msg = msg.substring(0, idx) + " or the -autoNameResolution option" + msg.substring(idx);
        }
        return msg;
    }
}

