/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.javascript;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.javascript.BasicNameManager;
import org.apache.cxf.javascript.JavascriptGetInterceptor;
import org.apache.cxf.javascript.NameManager;
import org.apache.cxf.javascript.NamespacePrefixAccumulator;
import org.apache.cxf.javascript.service.ServiceJavascriptBuilder;
import org.apache.cxf.javascript.types.SchemaJavascriptBuilder;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.wsdlto.core.WSDLToProcessor;
import org.apache.ws.commons.schema.XmlSchemaCollection;

public class WSDLToJavaScriptProcessor
extends WSDLToProcessor {
    private static final Logger LOG = LogUtils.getL7dLogger(WSDLToJavaScriptProcessor.class);
    private static final Charset UTF8 = Charset.forName("utf-8");

    public void process() throws ToolException {
        super.process();
        ServiceInfo serviceInfo = (ServiceInfo)this.context.get(ServiceInfo.class);
        File jsFile = this.getOutputFile(serviceInfo.getName().getLocalPart() + ".js");
        BasicNameManager nameManager = BasicNameManager.newNameManager((ServiceInfo)serviceInfo, null);
        NamespacePrefixAccumulator prefixManager = new NamespacePrefixAccumulator(serviceInfo.getXmlSchemaCollection());
        Map nsPrefixMap = CastUtils.cast((Map)((Map)this.context.get("javascriptPrefixMap", Map.class)), String.class, String.class);
        if (nsPrefixMap != null) {
            for (Map.Entry prefixEntry : nsPrefixMap.entrySet()) {
                prefixManager.collect((String)prefixEntry.getValue(), (String)prefixEntry.getKey());
            }
        }
        BufferedWriter writer = null;
        try {
            OutputStream outputStream = Files.newOutputStream(jsFile.toPath(), new OpenOption[0]);
            if (null != this.context.get("javascriptUtils")) {
                JavascriptGetInterceptor.writeUtilsToResponseStream(WSDLToJavaScriptProcessor.class, (OutputStream)outputStream);
            }
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, UTF8);
            writer = new BufferedWriter(outputStreamWriter);
            XmlSchemaCollection collection = serviceInfo.getXmlSchemaCollection().getXmlSchemaCollection();
            SchemaJavascriptBuilder jsBuilder = new SchemaJavascriptBuilder(serviceInfo.getXmlSchemaCollection(), prefixManager, (NameManager)nameManager);
            String jsForSchemas = jsBuilder.generateCodeForSchemaCollection(collection);
            writer.append(jsForSchemas);
            ServiceJavascriptBuilder serviceBuilder = new ServiceJavascriptBuilder(serviceInfo, null, prefixManager, (NameManager)nameManager);
            serviceBuilder.walk();
            String serviceJavascript = serviceBuilder.getCode();
            writer.append(serviceJavascript);
        }
        catch (IOException e) {
            throw new ToolException((Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new ToolException((Throwable)e);
            }
        }
    }

    private File getOutputFile(String defaultOutputFile) {
        File result;
        String output = (String)this.context.get("outputfile");
        String dir = (String)this.context.get("outputdir");
        if (dir == null) {
            dir = "./";
        }
        if (output != null) {
            result = new File(output);
            if (!result.isAbsolute()) {
                result = new File(new File(dir), output);
            }
        } else {
            result = new File(new File(dir), defaultOutputFile);
        }
        if (result.exists() && !result.renameTo(new File(result.getParent(), result.getName()))) {
            throw new ToolException(new Message("OUTFILE_EXISTS", LOG, new Object[0]));
        }
        return result;
    }
}

