/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.cxf.service.model.InterfaceInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.model.JavaInterface;
import org.apache.cxf.tools.common.model.JavaModel;
import org.apache.cxf.tools.util.ClassCollector;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.customization.JAXWSBinding;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.AbstractProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.OperationProcessor;
import org.apache.cxf.tools.wsdlto.frontend.jaxws.processor.internal.mapper.InterfaceMapper;
import org.w3c.dom.Element;

public class PortTypeProcessor
extends AbstractProcessor {
    private List<QName> operationMap = new ArrayList<QName>();

    public PortTypeProcessor(ToolContext c) {
        super(c);
    }

    public void processClassNames(ServiceInfo serviceInfo) throws ToolException {
        JAXWSBinding infBinding;
        InterfaceInfo interfaceInfo = serviceInfo.getInterface();
        if (interfaceInfo == null) {
            return;
        }
        JavaInterface intf = new InterfaceMapper(this.context).map(interfaceInfo);
        JAXWSBinding jaxwsBinding = null;
        if (serviceInfo.getDescription() != null) {
            jaxwsBinding = (JAXWSBinding)serviceInfo.getDescription().getExtensor(JAXWSBinding.class);
        }
        if ((infBinding = (JAXWSBinding)interfaceInfo.getExtensor(JAXWSBinding.class)) != null && infBinding.getPackage() != null) {
            intf.setPackageName(infBinding.getPackage());
        } else if (jaxwsBinding != null && jaxwsBinding.getPackage() != null) {
            intf.setPackageName(jaxwsBinding.getPackage());
        }
        String name = intf.getName();
        if (infBinding != null && infBinding.getJaxwsClass() != null && infBinding.getJaxwsClass().getClassName() != null) {
            name = infBinding.getJaxwsClass().getClassName();
        }
        intf.setName(name);
        ClassCollector collector = (ClassCollector)this.context.get(ClassCollector.class);
        collector.addSeiClassName(intf.getPackageName(), intf.getName(), intf.getPackageName() + "." + intf.getName());
    }

    public void process(ServiceInfo serviceInfo) throws ToolException {
        JAXWSBinding infBinding;
        this.operationMap.clear();
        JavaModel jmodel = (JavaModel)this.context.get(JavaModel.class);
        InterfaceInfo interfaceInfo = serviceInfo.getInterface();
        if (interfaceInfo == null) {
            return;
        }
        JavaInterface intf = new InterfaceMapper(this.context).map(interfaceInfo);
        intf.setJavaModel(jmodel);
        JAXWSBinding jaxwsBinding = null;
        if (serviceInfo.getDescription() != null) {
            jaxwsBinding = (JAXWSBinding)serviceInfo.getDescription().getExtensor(JAXWSBinding.class);
        }
        if ((infBinding = (JAXWSBinding)interfaceInfo.getExtensor(JAXWSBinding.class)) != null && infBinding.getPackage() != null) {
            intf.setPackageName(infBinding.getPackage());
        } else if (jaxwsBinding != null && jaxwsBinding.getPackage() != null) {
            intf.setPackageName(jaxwsBinding.getPackage());
        }
        String name = intf.getName();
        if (infBinding != null && infBinding.getJaxwsClass() != null && infBinding.getJaxwsClass().getClassName() != null) {
            name = infBinding.getJaxwsClass().getClassName();
        }
        intf.setName(name);
        Element handler = (Element)this.context.get("handler-chain");
        intf.setHandlerChains(handler);
        Collection operations = interfaceInfo.getOperations();
        for (OperationInfo operation : operations) {
            if (this.isOverloading(operation.getName())) {
                LOG.log(Level.WARNING, "SKIP_OVERLOADED_OPERATION", operation.getName());
                continue;
            }
            OperationProcessor operationProcessor = new OperationProcessor(this.context);
            operationProcessor.process(intf, operation);
        }
        jmodel.setLocation(intf.getLocation());
        jmodel.addInterface(intf.getName(), intf);
    }

    private boolean isOverloading(QName operationName) {
        if (this.operationMap.contains(operationName)) {
            return true;
        }
        this.operationMap.add(operationName);
        return false;
    }
}

